/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blockentities.renders;

import com.google.common.collect.Maps;
import com.lion.graveyard.blockentities.GravestoneBlockEntity;
import com.lion.graveyard.blocks.GravestoneBlock;
import com.lion.graveyard.init.TGBlocks;
import com.lion.graveyard.util.GravestoneIdentifier;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GravestoneBlockEntityRenderer
implements BlockEntityRenderer<GravestoneBlockEntity> {
    private static final int RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font textRenderer;
    private static final HashMap<Block, RenderType> LAYERS = Maps.newHashMap();
    private static RenderType defaultLayer = RenderType.m_110446_((ResourceLocation)new ResourceLocation("textures/entity/signs/oak.png"));

    public GravestoneBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.textRenderer = ctx.m_173586_();
    }

    public void render(GravestoneBlockEntity signBlockEntity, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j) {
        int r;
        boolean bl2;
        int q;
        BlockState blockState = signBlockEntity.m_58900_();
        Level world = signBlockEntity.m_58904_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.25, 0.5);
        float rotation = -((Direction)blockState.m_61143_((Property)GravestoneBlock.FACING)).m_122435_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.m_85849_();
        matrixStack.m_85837_(0.0, 0.3333333432674408, 0.23);
        matrixStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
        int m = GravestoneBlockEntityRenderer.getColor(signBlockEntity);
        FormattedCharSequence[] orderedTexts = signBlockEntity.getText().m_277130_(Minecraft.m_91087_().m_167974_(), text -> {
            List list = this.textRenderer.m_92923_((FormattedText)text, signBlockEntity.getMaxTextWidth());
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (signBlockEntity.getText().m_276843_()) {
            q = signBlockEntity.getText().m_276773_().m_41071_();
            bl2 = GravestoneBlockEntityRenderer.shouldRender(signBlockEntity, q);
            r = 0xF000F0;
        } else {
            q = m;
            bl2 = false;
            r = i;
        }
        for (int s = 0; s < 4; ++s) {
            FormattedCharSequence orderedText = orderedTexts[s];
            float t = -this.textRenderer.m_92724_(orderedText) / 2;
            if (bl2) {
                this.textRenderer.m_168645_(orderedText, t, (float)(s * 10 - 20), q, m, matrixStack.m_85850_().m_252922_(), vertexConsumerProvider, r);
                continue;
            }
            this.textRenderer.m_272191_(orderedText, t, (float)(s * 10 - 20), q, false, matrixStack.m_85850_().m_252922_(), vertexConsumerProvider, Font.DisplayMode.NORMAL, 0, r);
        }
        matrixStack.m_85849_();
        this.renderGrave(blockState, f, matrixStack, vertexConsumerProvider, i, j, world);
    }

    public void renderGrave(BlockState state, float f, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j, Level world) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.43, 0.5);
        matrixStack.m_85841_(2.28f, 2.15f, 2.28f);
        float rotation = ((Direction)state.m_61143_((Property)GravestoneBlock.FACING)).m_122435_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)state.m_60734_().m_5456_(), 1), ItemDisplayContext.GROUND, i, j, matrixStack, vertexConsumerProvider, world, 2);
        matrixStack.m_85849_();
    }

    private static boolean shouldRender(GravestoneBlockEntity sign, int signColor) {
        if (signColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraftClient = Minecraft.m_91087_();
        LocalPlayer clientPlayerEntity = minecraftClient.f_91074_;
        if (clientPlayerEntity != null && minecraftClient.f_91066_.m_92176_().m_90612_() && clientPlayerEntity.m_150108_()) {
            return true;
        }
        Entity entity = minecraftClient.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)sign.m_58899_())) < (double)RENDER_DISTANCE;
    }

    static int getColor(GravestoneBlockEntity sign) {
        int i = sign.getText().m_276773_().m_41071_();
        if (i == DyeColor.BLACK.m_41071_() && sign.getText().m_276843_()) {
            return -988212;
        }
        double d = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)i) * d);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)i) * d);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)i) * d);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }

    public static SignRenderer.SignModel createSignModel(EntityModelSet entityModelLoader, WoodType type) {
        return new SignRenderer.SignModel(entityModelLoader.m_171103_(ModelLayers.m_171291_((WoodType)type)));
    }

    public static VertexConsumer getConsumer(MultiBufferSource provider, Block block) {
        return provider.m_6299_(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        LAYERS.put(TGBlocks.GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.POLISHED_BASALT_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.COBBLESTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.COBBLESTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.MOSSY_COBBLESTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.MOSSY_COBBLESTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.DEEPSLATE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.DEEPSLATE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.BLACKSTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.BLACKSTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.CRACKED_BLACKSTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.CRACKED_BLACKSTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.STONE_BRICKS_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.STONE_BRICKS_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.MOSSY_STONE_BRICKS_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.MOSSY_STONE_BRICKS_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.BRICKS_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.BRICKS_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.RED_SANDSTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.RED_SANDSTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.SANDSTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.SANDSTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.GILDED_BLACKSTONE_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.GILDED_BLACKSTONE_GRAVESTONE_TEXTURE));
        LAYERS.put(TGBlocks.QUARTZ_BRICKS_GRAVESTONE.get(), RenderType.m_110446_((ResourceLocation)GravestoneIdentifier.QUARTZ_BRICKS_GRAVESTONE_TEXTURE));
    }
}

