/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.blocks.AltarBlock;
import com.lion.graveyard.entities.FallingCorpse;
import com.lion.graveyard.entities.GhoulEntity;
import com.lion.graveyard.entities.HostileGraveyardEntity;
import com.lion.graveyard.entities.RevenantEntity;
import com.lion.graveyard.entities.ai.goals.LichMeleeGoal;
import com.lion.graveyard.entities.projectiles.SkullEntity;
import com.lion.graveyard.init.TGEntities;
import com.lion.graveyard.init.TGParticles;
import com.lion.graveyard.init.TGSounds;
import com.lion.graveyard.sounds.BossMusicPlayer;
import com.lion.graveyard.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LichEntity
extends Monster
implements GeoEntity {
    private final ServerBossEvent bossBar;
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final TargetingConditions HEAD_TARGET_PREDICATE;
    private static final Predicate<LivingEntity> CAN_ATTACK_PREDICATE;
    private static final UUID ATTACKING_SPEED_BOOST_ID;
    private static final UUID ATTACKING_DMG_BOOST_ID;
    private static final UUID CRAWL_SPEED_BOOST_ID;
    private static final AttributeModifier ATTACKING_SPEED_BOOST;
    private static final AttributeModifier CRAWL_SPEED_BOOST;
    private static final AttributeModifier DMG_BOOST;
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation CORPSE_SPELL_ANIMATION = RawAnimation.begin().then("corpse_spell", Animation.LoopType.LOOP);
    private final RawAnimation START_PHASE_2_ANIMATION = RawAnimation.begin().then("phase_two", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation PHASE_2_IDLE_ANIMATION = RawAnimation.begin().then("phase_two_idle", Animation.LoopType.LOOP);
    private final RawAnimation PHASE_2_ATTACK_ANIMATION = RawAnimation.begin().then("phase_two_attack", Animation.LoopType.LOOP);
    private final RawAnimation START_PHASE_3_ANIMATION = RawAnimation.begin().then("phase_three", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation PHASE_3_ATTACK_ANIMATION = RawAnimation.begin().then("crawl", Animation.LoopType.LOOP);
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation SHOOT_SKULL_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation SUMMON_ANIMATION = RawAnimation.begin().then("summon", Animation.LoopType.LOOP);
    private final RawAnimation CONJURE_FANG_ANIMATION = RawAnimation.begin().then("corpse_spell", Animation.LoopType.LOOP);
    private final RawAnimation STUNNED_ANIMATION = RawAnimation.begin().then("stunned", Animation.LoopType.LOOP);
    private final RawAnimation CRAWL_IDLE_ANIMATION = RawAnimation.begin().then("crawl_idle", Animation.LoopType.LOOP);
    protected static final int ANIMATION_SPAWN = 0;
    protected static final int ANIMATION_IDLE = 1;
    protected static final int ANIMATION_MELEE = 2;
    protected static final int ANIMATION_CORPSE_SPELL = 3;
    protected static final int ANIMATION_START_PHASE_2 = 4;
    protected static final int ANIMATION_PHASE_2_IDLE = 5;
    protected static final int ANIMATION_PHASE_2_ATTACK = 6;
    protected static final int ANIMATION_SHOOT_SKULL = 7;
    protected static final int ANIMATION_START_PHASE_3 = 8;
    protected static final int ANIMATION_PHASE_3_ATTACK = 9;
    protected static final int ANIMATION_STOP = 10;
    protected static final int ANIMATION_SUMMON = 11;
    protected static final int ANIMATION_CONJURE_FANG = 12;
    protected static final int ANIMATION_STUNNED = 13;
    protected static final int ANIMATION_CRAWL_IDLE = 14;
    private static final EntityDataAccessor<Integer> INVUL_TIMER;
    private static final EntityDataAccessor<Integer> PHASE_INVUL_TIMER;
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> FIGHT_DURATION_TIMER;
    private static final EntityDataAccessor<Integer> PHASE_TWO_START_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> PHASE_THREE_START_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> PHASE;
    private static final EntityDataAccessor<Integer> ANIMATION;
    private static final EntityDataAccessor<Integer> HUNT_TIMER;
    private static final EntityDataAccessor<Boolean> CAN_HUNT_START;
    private static final EntityDataAccessor<Boolean> CAN_MOVE;
    private static final EntityDataAccessor<Integer> MUSIC_DELAY;
    private static final EntityDataAccessor<Integer> CONJURE_FANG_TIMER;
    private static final EntityDataAccessor<Integer> HEAL_DURATION_TIMER;
    private static final EntityDataAccessor<Integer> CORPSE_SPELL_DURATION_TIMER;
    private static final EntityDataAccessor<Integer> LEVITATION_DURATION_TIMER;
    private static final byte MUSIC_PLAY_ID = 67;
    private static final byte MUSIC_STOP_ID = 68;
    private static final int SPAWN_INVUL_TIMER = 490;
    private static final int DEFAULT_INVUL_TIMER = 200;
    private final float HEALTH_PHASE_01;
    private final float HEALTH_PHASE_02;
    public final int ATTACK_ANIMATION_DURATION = 40;
    private final int START_PHASE_TWO_ANIMATION_DURATION = 121;
    private final int START_PHASE_THREE_ANIMATION_DURATION = 220;
    private final int START_PHASE_TWO_PARTICLES = 80;
    private final int CORPSE_SPELL_DURATION;
    private final int HUNT_COOLDOWN = 600;
    private final int HUNT_DURATION;
    private final int HEALING_DURATION;
    private final int LEVITATION_DURATION;
    protected static final EntityDimensions CRAWL_DIMENSIONS;
    private int huntCooldownTicker;
    private BlockPos homePos;
    private Direction spawnDirection;
    private int phaseThreeAttackSoundAge;
    private int idleSoundAge;

    public LichEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.HEALTH_PHASE_01 = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInCastingPhase;
        this.HEALTH_PHASE_02 = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInHuntingPhase;
        this.ATTACK_ANIMATION_DURATION = 40;
        this.START_PHASE_TWO_ANIMATION_DURATION = 121;
        this.START_PHASE_THREE_ANIMATION_DURATION = 220;
        this.START_PHASE_TWO_PARTICLES = 80;
        this.CORPSE_SPELL_DURATION = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationFallingCorpseSpell;
        this.HUNT_COOLDOWN = 600;
        this.HUNT_DURATION = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationHuntingPhase;
        this.HEALING_DURATION = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationHealingSpell;
        this.LEVITATION_DURATION = Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").durationLevitationSpell;
        this.huntCooldownTicker = 100;
        this.phaseThreeAttackSoundAge = 120;
        this.idleSoundAge = 0;
        this.bossBar = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true).m_7006_(true);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animationData) {
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            if (this.getAnimationState() == 0 && this.getInvulnerableTimer() >= 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        })});
        animationData.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller2", 0, event -> {
            if (this.getAnimationState() == 10) {
                return PlayState.STOP;
            }
            if (this.getAnimationState() == 2 && this.getAttackAnimTimer() == 39 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01) && this.canMeeleAttack() && this.getAnimationState() != 0) {
                this.setAttackAnimTimer(38);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 3 && this.getPhase() == 1) {
                event.getController().setAnimation(this.CORPSE_SPELL_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 7 && this.getPhase() == 1) {
                event.getController().setAnimation(this.SHOOT_SKULL_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 11 && this.getPhase() == 1) {
                event.getController().setAnimation(this.SUMMON_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 12 && this.getPhase() == 1) {
                event.getController().setAnimation(this.CONJURE_FANG_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getPhase() == 1) {
                if (this.getAnimationState() == 1 && this.getAttackAnimTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getAnimationState() != 7) {
                    event.getController().setAnimation(this.IDLE_ANIMATION);
                    return PlayState.CONTINUE;
                }
                if ((this.getAnimationState() != 7 || this.getAnimationState() != 11 || this.getAnimationState() != 12 || this.getAnimationState() != 3) && this.getAttackAnimTimer() > 0) {
                    this.setAnimationState(2);
                }
            }
            if (this.getAnimationState() == 4 && this.getPhase() == 2) {
                event.getController().setAnimation(this.START_PHASE_2_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 13 && this.getPhase() == 3) {
                event.getController().setAnimation(this.STUNNED_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getPhase() == 3) {
                event.getController().setAnimation(this.PHASE_2_IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 6 && this.getPhase() == 3) {
                event.getController().setAnimation(this.PHASE_2_ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 8 && this.getPhase() == 4) {
                event.getController().setAnimation(this.START_PHASE_3_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (!(event.isMoving() || this.getPhase() != 5 || this.m_21224_() || (double)this.m_21223_() < 0.01)) {
                event.getController().setAnimation(this.CRAWL_IDLE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 9 && this.getPhase() == 5 && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
                event.getController().setAnimation(this.PHASE_3_ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getPhase() == 1) {
                if (this.getAttackAnimTimer() <= 0 && this.getInvulnerableTimer() <= 0) {
                    this.setAnimationState(1);
                    return PlayState.STOP;
                }
                if (this.getAttackAnimTimer() > 0 && this.getAnimationState() == 1) {
                    return PlayState.STOP;
                }
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new LichMeleeGoal(this, 1.0, false));
        this.f_21345_.m_25352_(4, (Goal)new SummonFallenCorpsesGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new ConjureFangsGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new ShootSkullGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new TeleportAndHealGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new LevitationGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder createLichAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, (double)Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").healthInCastingPhase).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").damageCastingPhase).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22284_, Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").armor).m_22268_(Attributes.f_22285_, Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").armorToughness).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void m_8119_() {
        if (!this.m_20193_().f_46443_ && this.getBossMusic() != null) {
            if (this.canPlayMusic() && this.f_20919_ == 0) {
                this.m_20193_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_20193_().m_7605_((Entity)this, (byte)68);
            }
        }
        super.m_8119_();
    }

    public void m_7822_(byte id) {
        if (id == 67 && this.getMusicDelay() == 78) {
            BossMusicPlayer.playBossMusic(this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic(this);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8107_() {
        BlockState altar;
        int i;
        if (this.homePos == null) {
            this.homePos = BlockPos.m_274561_((double)((double)this.m_146903_() + 0.5), (double)this.m_20186_(), (double)((double)this.m_146907_() + 0.5));
        }
        this.randomDisplayTick(this.m_9236_(), this.m_20183_(), this.m_217043_());
        int phaseTwoTimer = this.getStartPhaseTwoAnimTimer();
        if (phaseTwoTimer < 80 && phaseTwoTimer > 40) {
            float offset = 0.0f;
            for (i = 0; i < 25; ++i) {
                if (i < 7) {
                    offset += 0.15f;
                } else if (i > 12) {
                    offset -= 0.15f;
                }
                MathUtil.createParticleDisk(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)((float)i / 10.0f), this.m_20189_(), 0.0, 0.3, 0.0, 2.0f * offset, ParticleTypes.f_123745_, this.m_217043_());
            }
        }
        if (this.getInvulnerableTimer() > 60 && this.f_19796_.m_188503_(6) == 0 && this.getPhase() == 1) {
            MathUtil.createParticleFlare(this.m_9236_(), this.m_20185_() - 0.75, this.m_20186_() - 1.0 + 3.5 - (double)((float)this.getInvulnerableTimer() / 100.0f), this.m_20189_() - 0.75, this.f_19796_.m_188503_(300) + 150, ParticleTypes.f_123746_, ParticleTypes.f_123745_, this.f_19796_, false);
        }
        if (this.getInvulnerableTimer() > 20 && this.getPhase() == 1) {
            MathUtil.createParticleCircle(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, 5.0f, ParticleTypes.f_123745_, this.m_217043_(), 1.0f);
        }
        Vec3 rotation = this.m_20252_(1.0f);
        if (this.f_20919_ > 0 && this.f_20919_ <= 100 && this.f_19796_.m_188503_(4) == 0) {
            MathUtil.createParticleFlare(this.m_9236_(), this.m_20185_() - 0.75, this.m_20186_() - 1.0, this.m_20189_() - 0.75, this.f_19796_.m_188503_(300) + 150, ParticleTypes.f_123746_, ParticleTypes.f_123745_, this.f_19796_, false);
        }
        if (this.getPhaseInvulnerableTimer() > 0 && this.getInvulnerableTimer() <= 0 && this.getPhase() == 1) {
            MathUtil.createParticleCircle(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), 0.0, 0.0, 0.0, 2.5f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.m_217043_(), 0.5f);
        }
        if (!this.canHuntStart() && this.getPhase() == 3 && this.getAnimationState() == 13 && this.f_19796_.m_188503_(7) == 0) {
            MathUtil.createParticleFlare(this.m_9236_(), this.m_20185_() - 0.75, this.m_20186_() + 2.5, this.m_20189_() - 0.75, this.f_19796_.m_188503_(100) + 150, ParticleTypes.f_123746_, ParticleTypes.f_123745_, this.f_19796_, true);
        }
        if (this.getHealTimer() > 0 && this.getPhase() == 1) {
            MathUtil.createParticleSpiral(this.m_9236_(), this.m_20185_() + rotation.f_82479_ * 3.5, this.m_20186_() - 0.5, this.m_20189_() + rotation.f_82481_ * 3.5, 0.0, 0.0, 0.0, 350, ParticleTypes.f_123745_, this.f_19796_);
        }
        if (this.getHealTimer() == 1 && this.getPhase() == 1) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, SoundSource.HOSTILE, 3.0f, -1.0f);
            for (i = 0; i < 20; ++i) {
                MathUtil.createParticleSpiral(this.m_9236_(), this.m_20185_() + rotation.f_82479_ * 3.5, this.m_20186_() - 0.5, this.m_20189_() + rotation.f_82481_ * 3.5, this.f_19796_.m_188500_() - this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - this.f_19796_.m_188500_(), this.f_19796_.m_188500_() - this.f_19796_.m_188500_(), 350, ParticleTypes.f_123745_, this.f_19796_);
            }
        }
        if (!this.m_6084_() && this.homePos != null && (altar = this.m_9236_().m_8055_(this.homePos.m_7495_())).m_60734_() instanceof AltarBlock) {
            this.m_9236_().m_7731_(this.homePos.m_7495_(), (BlockState)altar.m_61124_((Property)AltarBlock.BLOODY, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (this.canHuntStart()) {
            List<Player> playersInRange = this.getPlayersInRange(30.0);
            for (Player player : playersInRange) {
                if (this.getHuntTimer() != 0 && this.getHuntTimer() % 300 != 0 || player.m_7500_() || !Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) continue;
                player.m_5496_(SoundEvents.f_11757_, 2.5f, -5.0f);
                for (int i2 = 0; i2 < 10; ++i2) {
                    MathUtil.createParticleCircle(this.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.01, 0.0, 1.0f, TGParticles.GRAVEYARD_SOUL_PARTICLE, this.m_217043_(), 0.5f);
                }
            }
        }
        if (!this.canHuntStart() && this.f_19796_.m_188503_(5) == 0) {
            this.m_20193_().m_5594_(null, this.m_20183_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 4.0f, -10.0f);
        }
        if (this.getMusicDelay() < 78) {
            this.setMusicDelay(this.getMusicDelay() + 1);
        }
        super.m_8107_();
    }

    public void m_6075_() {
        if (this.homePos == null) {
            this.homePos = BlockPos.m_274561_((double)((double)this.m_146903_() + 0.5), (double)this.m_20186_(), (double)((double)this.m_146907_() + 0.5));
        }
        super.m_6075_();
    }

    protected void m_8024_() {
        AttributeInstance entityAttributeDmgInstance;
        AttributeInstance entityAttributeInstance;
        if (this.homePos == null) {
            this.homePos = BlockPos.m_274561_((double)((double)this.m_146903_() + 0.5), (double)this.m_20186_(), (double)((double)this.m_146907_() + 0.5));
        }
        if (this.idleSoundAge <= 0) {
            this.m_8032_();
            this.idleSoundAge = 100;
        }
        --this.idleSoundAge;
        int duration = this.getFightDurationTimer();
        this.setFightDurationTimer(duration + 1);
        if (duration > 400) {
            if (duration < Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight && duration % 400 == 0 && this.f_19796_.m_188499_()) {
                this.summonMob(false);
            } else if (duration >= Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight && duration < Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").ghoulSpawnTimerInFight * 2 && duration % 600 == 0 && this.f_19796_.m_188499_()) {
                this.summonMob(true);
            }
        }
        if (this.getPhase() == 5) {
            if (this.phaseThreeAttackSoundAge == 120) {
                this.playStartPhaseThreeAttackSound();
            }
            this.phaseThreeAttackSoundAge = this.phaseThreeAttackSoundAge == 20 ? 120 : --this.phaseThreeAttackSoundAge;
            entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
            this.setCanMove(true);
            this.setAnimationState(9);
            if (!entityAttributeInstance.m_22109_(CRAWL_SPEED_BOOST)) {
                entityAttributeInstance.m_22118_(CRAWL_SPEED_BOOST);
            }
        }
        if (this.getPhase() == 3) {
            entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
            entityAttributeDmgInstance = this.m_21051_(Attributes.f_22281_);
            if (this.getHuntCooldownTicker() > 0) {
                this.setHuntCooldownTicker(this.getHuntCooldownTicker() - 1);
            } else {
                this.setHuntStart(true);
            }
            if (this.canHuntStart()) {
                List<Player> playersInRange = this.getPlayersInRange(30.0);
                for (Player player : playersInRange) {
                    if ((this.getHuntTimer() == 0 || this.getHuntTimer() % 300 == 0) && !player.m_7500_() && Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                        for (int i = 0; i <= 5; ++i) {
                            BlockPos targetPos = BlockPos.m_274561_((double)(this.m_20185_() + (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-10, (int)10)), (double)this.m_20186_(), (double)(this.m_20189_() + (double)Mth.m_216271_((RandomSource)this.f_19796_, (int)-10, (int)10)));
                            if (!this.m_20193_().m_8055_(targetPos).m_60795_() || !this.m_20193_().m_8055_(targetPos.m_7494_()).m_60795_() || !this.m_20193_().m_8055_(targetPos.m_7495_()).m_60796_((BlockGetter)this.m_20193_(), targetPos.m_7495_())) continue;
                            player.m_20324_((double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_());
                            break;
                        }
                    }
                    if (this.getHuntTimer() % 50 != 0 || player.m_7500_()) continue;
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, 2));
                }
                this.setCanMove(true);
                if (this.getHuntTimer() == 0) {
                    this.playHuntSound();
                    this.setHuntTimer(this.HUNT_DURATION);
                    if (Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                        this.setPhaseInvulTimer(this.HUNT_DURATION);
                    }
                }
                if (this.getHuntTimer() == 400) {
                    this.playHuntSound();
                }
                this.setAnimationState(6);
                if (!entityAttributeInstance.m_22109_(ATTACKING_SPEED_BOOST)) {
                    entityAttributeInstance.m_22118_(ATTACKING_SPEED_BOOST);
                }
                if (!entityAttributeDmgInstance.m_22109_(DMG_BOOST)) {
                    entityAttributeDmgInstance.m_22118_(DMG_BOOST);
                }
            }
            if (this.getHuntTimer() == 1 && this.getHuntCooldownTicker() == 0 && this.canHuntStart()) {
                this.m_20324_((double)this.homePos.m_123341_() + 0.5, (double)this.homePos.m_123342_() + 0.5, (double)this.homePos.m_123343_() + 0.5);
                this.setHuntCooldownTicker(600);
                this.setAnimationState(13);
                this.setHuntStart(false);
                this.setCanMove(false);
                entityAttributeInstance.m_22130_(ATTACKING_SPEED_BOOST);
                entityAttributeDmgInstance.m_22130_(DMG_BOOST);
            }
            if (this.getHuntTimer() > 0) {
                int timer = this.getHuntTimer() - 1;
                this.setHuntTimer(timer);
            }
        }
        if (this.getPhase() == 2) {
            int phaseTwoTimer = this.getStartPhaseTwoAnimTimer();
            if (this.getPhaseInvulnerableTimer() == 0) {
                this.m_20324_((double)this.homePos.m_123341_() + 0.5, (double)this.homePos.m_123342_() + 0.5, (double)this.homePos.m_123343_() + 0.5);
                this.setPhaseInvulTimer(121);
            }
            this.setAnimationState(4);
            if (phaseTwoTimer > 0) {
                if (phaseTwoTimer == 121) {
                    this.playStartPhaseTwoSound();
                }
                this.setStartPhaseTwoAnimTimer(phaseTwoTimer - 1);
            }
            if (phaseTwoTimer == 1) {
                this.setAnimationState(5);
                this.setPhase(this.getPhase() + 1);
            }
        }
        if (this.getPhase() == 4) {
            if (!Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells && this.canHuntStart()) {
                AttributeInstance entityAttributeInstance2 = this.m_21051_(Attributes.f_22279_);
                entityAttributeDmgInstance = this.m_21051_(Attributes.f_22281_);
                this.m_20324_((double)this.homePos.m_123341_() + 0.75, (double)this.homePos.m_123342_() + 0.5, (double)this.homePos.m_123343_() + 0.75);
                this.setHuntCooldownTicker(600);
                this.setAnimationState(13);
                this.setHuntStart(false);
                this.setCanMove(false);
                entityAttributeInstance2.m_22130_(ATTACKING_SPEED_BOOST);
                entityAttributeDmgInstance.m_22130_(DMG_BOOST);
            }
            int phaseThreeTimer = this.getStartPhaseThreeAnimTimer();
            if (this.getPhaseInvulnerableTimer() == 0) {
                this.setPhaseInvulTimer(220);
            }
            this.setAnimationState(8);
            if (phaseThreeTimer > 0) {
                if (phaseThreeTimer == 220) {
                    this.playStartPhaseThreeSound();
                }
                this.setStartPhaseThreeAnimTimer(phaseThreeTimer - 1);
            }
            if (phaseThreeTimer == 1) {
                this.setAnimationState(9);
                this.setPhase(this.getPhase() + 1);
            }
        }
        if (this.getPhaseInvulnerableTimer() > 0) {
            int timer = this.getPhaseInvulnerableTimer() - 1;
            this.setPhaseInvulTimer(timer);
        }
        if (this.getHealTimer() > 0) {
            List<Player> playersInRange = this.getPlayersInRange(30.0);
            for (Player player : playersInRange) {
                if (this.getHealTimer() == this.HEALING_DURATION && !player.m_7500_()) {
                    player.m_20324_(this.m_20185_(), this.m_20186_() + (double)Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").playerTeleportYOffset, this.m_20189_());
                }
                if (player.m_21023_(MobEffects.f_19599_) || player.m_7500_()) continue;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 1));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 50, 1));
            }
        }
        this.setHealTimer(this.getHealTimer() - 1);
        this.setLevitationDurationTimer(this.getLevitationDurationTimer() - 1);
        this.setConjureFangTimer(this.getConjureFangTimer() - 1);
        this.setCorpseSpellTimer(this.getCorpseSpellTimer() - 1);
        if (this.getInvulnerableTimer() > 0) {
            int i = this.getInvulnerableTimer() - 1;
            int timer = this.getPhase() == 1 ? 490 : 200;
            if (this.getInvulnerableTimer() == 1 && this.getPhase() == 1) {
                this.setAnimationState(1);
            }
            this.bossBar.m_142711_(1.0f - (float)i / (float)timer);
            this.setInvulTimer(i);
        } else {
            if (this.getAttackAnimTimer() == 40) {
                this.setAnimationState(2);
            }
            if (this.getAttackAnimTimer() > 0) {
                int animTimer = this.getAttackAnimTimer() - 1;
                this.setAttackAnimTimer(animTimer);
            }
            super.m_8024_();
            this.bossBar.m_142711_(this.m_21223_() / this.getMaxHealthPerPhase());
        }
    }

    private float getMaxHealthPerPhase() {
        if (this.getPhase() == 1) {
            return this.HEALTH_PHASE_01;
        }
        return this.HEALTH_PHASE_02;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void onSummoned(Direction direction, BlockPos altarPos) {
        this.setAnimationState(0);
        this.applyInvulAndResetBossBar(490);
        this.homePos = BlockPos.m_274561_((double)((double)altarPos.m_123341_() + 0.5), (double)altarPos.m_123342_(), (double)((double)altarPos.m_123343_() + 0.5));
        this.spawnDirection = direction;
        this.playSpawnSound();
    }

    private void applyInvulAndResetBossBar(int invul) {
        this.setInvulTimer(invul);
        this.bossBar.m_142711_(0.0f);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 5) {
            this.playDeathSound();
        }
        if (this.f_20919_ == 160 && !this.m_20193_().m_5776_()) {
            this.m_20193_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        if (pose == Pose.CROUCHING) {
            return 2.0f;
        }
        return 4.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.CROUCHING) {
            this.m_20124_(Pose.CROUCHING);
            return CRAWL_DIMENSIONS;
        }
        return super.m_6972_(pose);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity source) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!(this.getInvulnerableTimer() <= 0 && this.getPhaseInvulnerableTimer() <= 0 || source.m_269533_(DamageTypeTags.f_268630_))) {
            return false;
        }
        if (amount > this.m_21223_() && this.getPhase() < 5 && !source.m_269533_(DamageTypeTags.f_268630_) && Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isMultiphaseFight) {
            this.respawn();
            return false;
        }
        if (this.getHealTimer() > 0) {
            this.setHealTimer(1);
        } else {
            this.setHealTimer(0);
        }
        return super.m_6469_(source, amount);
    }

    private void respawn() {
        this.setPhase(this.getPhase() + 1);
        this.setAnimationState(10);
        this.m_21219_();
        this.applyInvulAndResetBossBar(200);
        this.m_21153_(this.HEALTH_PHASE_02);
        this.setAttackAnimTimer(0);
        if (this.getPhase() == 4 || this.getPhase() == 5) {
            this.m_6972_(Pose.CROUCHING);
        }
    }

    public void randomDisplayTick(Level world, BlockPos pos, RandomSource random) {
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        double d = (double)i + (double)random.m_188503_(3) - (double)random.m_188503_(3);
        double e = (double)j + 4.2;
        double f = (double)k + (double)random.m_188503_(3) - (double)random.m_188503_(3);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123783_, d, e, f, 0.0, 0.0, 0.0);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122178_(i + Mth.m_216271_((RandomSource)random, (int)-17, (int)17), j + random.m_188503_(10), k + Mth.m_216271_((RandomSource)random, (int)-17, (int)17));
        BlockState blockState = world.m_8055_((BlockPos)mutable);
        if (!blockState.m_60838_((BlockGetter)world, (BlockPos)mutable)) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)mutable.m_123341_() + random.m_188500_(), (double)mutable.m_123342_() + random.m_188500_(), (double)mutable.m_123343_() + random.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    public List<Player> getPlayersInRange(double range) {
        AABB box = new AABB(this.m_20183_()).m_82400_(range);
        return this.m_20193_().m_45976_(Player.class, box);
    }

    public boolean canMeeleAttack() {
        return this.getPhase() == 1 && this.getPhaseInvulnerableTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getHealTimer() <= 0 && this.getLevitationDurationTimer() <= 0 && this.getConjureFangTimer() <= 0 && this.getCorpseSpellTimer() <= 0 && this.m_21223_() > 35.0f;
    }

    public boolean canSpellCast() {
        return this.getPhase() == 1 && this.getAttackAnimTimer() <= 0 && this.getPhaseInvulnerableTimer() <= 0 && this.getInvulnerableTimer() <= 0 && this.getHealTimer() <= 0 && this.getLevitationDurationTimer() <= 0 && this.getConjureFangTimer() <= 0 && this.getCorpseSpellTimer() <= 0;
    }

    public boolean m_6128_() {
        return true;
    }

    private boolean summonMob(boolean hard) {
        if (this.getHuntTimer() <= 1) {
            AABB box = new AABB(this.m_20183_()).m_82400_(35.0);
            List mobs = this.m_9236_().m_45976_(HostileGraveyardEntity.class, box);
            if (mobs.size() >= Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxSummonedMobs) {
                return false;
            }
            for (int i = 10; i > 0; --i) {
                BlockPos pos = new BlockPos(this.m_146903_() + Mth.m_216271_((RandomSource)this.f_19796_, (int)-15, (int)15), this.m_146904_(), this.m_146907_() + Mth.m_216271_((RandomSource)this.f_19796_, (int)-15, (int)15));
                int amount = this.f_19796_.m_188503_(Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxGroupSizeSummonedMobs) + 1;
                if (!this.m_20193_().m_8055_(pos).m_60795_() || !this.m_20193_().m_8055_(pos.m_7494_()).m_60795_() || !this.m_20193_().m_8055_(pos.m_7494_().m_7494_()).m_60795_() || this.m_20193_().m_8055_(pos.m_7495_()).m_60795_()) continue;
                if (!hard) {
                    for (int ii = 0; ii < amount; ++ii) {
                        RevenantEntity revenant = (RevenantEntity)TGEntities.REVENANT.get().m_20615_(this.m_20193_());
                        revenant.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        revenant.setCanBurnInSunlight(false);
                        this.m_20193_().m_7967_((Entity)revenant);
                    }
                } else {
                    for (int ii = 0; ii < amount - 1; ++ii) {
                        GhoulEntity ghoul = (GhoulEntity)TGEntities.GHOUL.get().m_20615_(this.m_20193_());
                        ghoul.setVariant((byte)9);
                        ghoul.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        ghoul.setCanBurnInSunlight(false);
                        this.m_20193_().m_7967_((Entity)ghoul);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean canHuntStart() {
        return (Boolean)this.f_19804_.m_135370_(CAN_HUNT_START);
    }

    public void setHuntStart(boolean bool) {
        this.f_19804_.m_135381_(CAN_HUNT_START, (Object)bool);
    }

    public void setCanMove(boolean bool) {
        this.f_19804_.m_135381_(CAN_MOVE, (Object)bool);
    }

    public boolean canMove() {
        return (Boolean)this.f_19804_.m_135370_(CAN_MOVE);
    }

    public int getInvulnerableTimer() {
        return (Integer)this.f_19804_.m_135370_(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.f_19804_.m_135381_(INVUL_TIMER, (Object)ticks);
    }

    public int getFightDurationTimer() {
        return (Integer)this.f_19804_.m_135370_(FIGHT_DURATION_TIMER);
    }

    public void setFightDurationTimer(int ticks) {
        this.f_19804_.m_135381_(FIGHT_DURATION_TIMER, (Object)ticks);
    }

    public int getLevitationDurationTimer() {
        return (Integer)this.f_19804_.m_135370_(LEVITATION_DURATION_TIMER);
    }

    public void setLevitationDurationTimer(int ticks) {
        this.f_19804_.m_135381_(LEVITATION_DURATION_TIMER, (Object)ticks);
    }

    public int getConjureFangTimer() {
        return (Integer)this.f_19804_.m_135370_(CONJURE_FANG_TIMER);
    }

    public void setConjureFangTimer(int ticks) {
        this.f_19804_.m_135381_(CONJURE_FANG_TIMER, (Object)ticks);
    }

    public int getCorpseSpellTimer() {
        return (Integer)this.f_19804_.m_135370_(CORPSE_SPELL_DURATION_TIMER);
    }

    public void setCorpseSpellTimer(int ticks) {
        this.f_19804_.m_135381_(CORPSE_SPELL_DURATION_TIMER, (Object)ticks);
    }

    public int getHealTimer() {
        return (Integer)this.f_19804_.m_135370_(HEAL_DURATION_TIMER);
    }

    public void setHealTimer(int ticks) {
        this.f_19804_.m_135381_(HEAL_DURATION_TIMER, (Object)ticks);
    }

    public int getPhaseInvulnerableTimer() {
        return (Integer)this.f_19804_.m_135370_(PHASE_INVUL_TIMER);
    }

    public void setPhaseInvulTimer(int ticks) {
        this.f_19804_.m_135381_(PHASE_INVUL_TIMER, (Object)ticks);
    }

    public int getHuntTimer() {
        return (Integer)this.f_19804_.m_135370_(HUNT_TIMER);
    }

    public void setHuntTimer(int ticks) {
        this.f_19804_.m_135381_(HUNT_TIMER, (Object)ticks);
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION, (Object)state);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getStartPhaseTwoAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(PHASE_TWO_START_ANIM_TIMER);
    }

    public void setStartPhaseTwoAnimTimer(int startPhaseTwoAnimTimer) {
        this.f_19804_.m_135381_(PHASE_TWO_START_ANIM_TIMER, (Object)startPhaseTwoAnimTimer);
    }

    public int getStartPhaseThreeAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(PHASE_THREE_START_ANIM_TIMER);
    }

    public void setStartPhaseThreeAnimTimer(int startPhaseThreeAnimTimer) {
        this.f_19804_.m_135381_(PHASE_THREE_START_ANIM_TIMER, (Object)startPhaseThreeAnimTimer);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getHuntCooldownTicker() {
        return this.huntCooldownTicker;
    }

    public void setHuntCooldownTicker(int huntCooldownTicker) {
        this.huntCooldownTicker = huntCooldownTicker;
    }

    public int getMusicDelay() {
        return (Integer)this.f_19804_.m_135370_(MUSIC_DELAY);
    }

    public void setMusicDelay(int time) {
        this.f_19804_.m_135381_(MUSIC_DELAY, (Object)time);
    }

    private void playSpawnSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_SPAWN.get(), SoundSource.HOSTILE, 15.0f, 1.0f);
    }

    public void playAttackSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_MELEE.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    public void playHealSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_CAST_TELEPORT.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playCorpseSpellSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_CORPSE_SPELL.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playStartPhaseTwoSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_PHASE_02.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playStartPhaseThreeSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_PHASE_03.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playStartPhaseThreeAttackSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_PHASE_03_ATTACK.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playDeathSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_DEATH.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    public void playScareSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_SCARE.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playHuntSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_HUNT.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playShootSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_CAST_SKULL.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    private void playLevitationSound() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_CAST_LEVITATION.get(), SoundSource.HOSTILE, 10.0f, 1.0f);
    }

    public void m_8032_() {
        this.m_20193_().m_5594_(null, this.m_20183_(), TGSounds.LICH_IDLE.get(), SoundSource.HOSTILE, 15.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TGSounds.LICH_HURT.get();
    }

    public SoundEvent getBossMusic() {
        return TGSounds.LICH_THEME_01.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_();
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_20270_((Entity)player) < 2500.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_MOVE, (Object)false);
        this.f_19804_.m_135372_(INVUL_TIMER, (Object)0);
        this.f_19804_.m_135372_(MUSIC_DELAY, (Object)0);
        this.f_19804_.m_135372_(HUNT_TIMER, (Object)0);
        this.f_19804_.m_135372_(FIGHT_DURATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(HEAL_DURATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(LEVITATION_DURATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(CORPSE_SPELL_DURATION_TIMER, (Object)0);
        this.f_19804_.m_135372_(PHASE_INVUL_TIMER, (Object)0);
        this.f_19804_.m_135372_(ANIMATION, (Object)1);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(CONJURE_FANG_TIMER, (Object)0);
        this.f_19804_.m_135372_(PHASE_TWO_START_ANIM_TIMER, (Object)121);
        this.f_19804_.m_135372_(PHASE_THREE_START_ANIM_TIMER, (Object)220);
        this.f_19804_.m_135372_(PHASE, (Object)1);
        this.f_19804_.m_135372_(CAN_HUNT_START, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("Invul", this.getInvulnerableTimer());
        nbt.m_128405_("PhaseInvul", this.getPhaseInvulnerableTimer());
        nbt.m_128405_("Phase", Math.max(this.getPhase(), 1));
        nbt.m_128405_("AttackTimer", this.getAttackAnimTimer());
        nbt.m_128405_("FightTimer", this.getFightDurationTimer());
        nbt.m_128405_("LevTimer", this.getLevitationDurationTimer());
        nbt.m_128405_("HealTimer", this.getHealTimer());
        nbt.m_128405_("CorpseSpellTimer", this.getCorpseSpellTimer());
        nbt.m_128405_("ConjureTimer", this.getConjureFangTimer());
        nbt.m_128405_("Anim", this.getAnimationState());
        nbt.m_128350_("Health", this.m_21223_());
        nbt.m_128379_("CanMove", this.canMove());
        nbt.m_128379_("CanHunt", this.canHuntStart());
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        if (!nbt.m_128441_("Invul")) {
            this.setInvulTimer(0);
            this.setPhaseInvulTimer(0);
            this.setPhase(1);
            this.setAnimationState(1);
            this.m_21153_(this.HEALTH_PHASE_01);
            this.setAttackAnimTimer(0);
            this.setHealTimer(0);
            this.setLevitationDurationTimer(0);
            this.setCorpseSpellTimer(0);
            this.setConjureFangTimer(0);
            this.setFightDurationTimer(0);
            this.setCanMove(false);
            this.setHuntStart(false);
        } else {
            this.setInvulTimer(nbt.m_128451_("Invul"));
            this.setPhaseInvulTimer(nbt.m_128451_("PhaseInvul"));
            this.setPhase(nbt.m_128451_("Phase"));
            this.setAnimationState(nbt.m_128451_("Anim"));
            this.m_21153_(nbt.m_128457_("Health"));
            this.setAttackAnimTimer(nbt.m_128451_("AttackTimer"));
            this.setHealTimer(nbt.m_128451_("HealTimer"));
            this.setLevitationDurationTimer(nbt.m_128451_("LevTimer"));
            this.setCorpseSpellTimer(nbt.m_128451_("CorpseSpellTimer"));
            this.setConjureFangTimer(nbt.m_128451_("ConjureTimer"));
            this.setFightDurationTimer(nbt.m_128451_("FightTimer"));
            this.setCanMove(nbt.m_128471_("CanMove"));
            this.setHuntStart(nbt.m_128471_("CanHunt"));
        }
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
        super.m_7378_(nbt);
    }

    static {
        ATTACKING_SPEED_BOOST_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
        ATTACKING_DMG_BOOST_ID = UUID.fromString("120E0DFB-87AE-4653-9776-831010E291A1");
        CRAWL_SPEED_BOOST_ID = UUID.fromString("120E0DFB-87AE-1978-9776-831010E291A2");
        INVUL_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PHASE_INVUL_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        HUNT_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PHASE_TWO_START_ANIM_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PHASE_THREE_START_ANIM_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANIMATION = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        FIGHT_DURATION_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        HEAL_DURATION_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CONJURE_FANG_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CORPSE_SPELL_DURATION_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        LEVITATION_DURATION_TIMER = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PHASE = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CAN_HUNT_START = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CAN_MOVE = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        MUSIC_DELAY = SynchedEntityData.m_135353_(LichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CAN_ATTACK_PREDICATE = Entity::m_142389_;
        HEAD_TARGET_PREDICATE = TargetingConditions.m_148352_().m_26883_(20.0).m_26888_(CAN_ATTACK_PREDICATE);
        CRAWL_DIMENSIONS = EntityDimensions.m_20398_((float)1.8f, (float)2.0f);
        CRAWL_SPEED_BOOST = new AttributeModifier(CRAWL_SPEED_BOOST_ID, "Crawl speed boost", 0.18, AttributeModifier.Operation.ADDITION);
        ATTACKING_SPEED_BOOST = new AttributeModifier(ATTACKING_SPEED_BOOST_ID, "Attacking speed boost", Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").speedInHuntPhase, AttributeModifier.Operation.ADDITION);
        DMG_BOOST = new AttributeModifier(ATTACKING_DMG_BOOST_ID, "Damage speed boost", Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").damageHuntingPhaseAddition, AttributeModifier.Operation.ADDITION);
    }

    public class SummonFallenCorpsesGoal
    extends Goal {
        protected final LichEntity lich;
        private final int FALL_HEIGHT = 10;
        private final int SQUARE_SIZE = 30;
        private final int CORPSE_SPAWN_RARITY_PLAYER = 9;
        private BlockPos pos;
        private List<Player> list;
        private List<BlockPos> positions = new ArrayList<BlockPos>();

        public SummonFallenCorpsesGoal(LichEntity lich) {
            this.lich = lich;
        }

        public boolean m_8036_() {
            return LichEntity.this.getCorpseSpellTimer() <= -Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownCorpseSpell && LichEntity.this.f_19796_.m_188503_(75) == 0 && LichEntity.this.canSpellCast();
        }

        public void m_8056_() {
            if (Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").isInvulnerableDuringSpells) {
                LichEntity.this.setPhaseInvulTimer(LichEntity.this.CORPSE_SPELL_DURATION);
            }
            LichEntity.this.setCorpseSpellTimer(LichEntity.this.CORPSE_SPELL_DURATION);
            LichEntity.this.playCorpseSpellSound();
            this.lich.m_20324_((double)this.lich.homePos.m_123341_() + 0.5, (double)this.lich.homePos.m_123342_() + 0.5, (double)this.lich.homePos.m_123343_() + 0.5);
            this.pos = this.lich.m_20183_();
            this.list = LichEntity.this.getPlayersInRange(35.0);
            for (int i = -30; i < 30; ++i) {
                for (int ii = -30; ii < 30; ++ii) {
                    BlockPos position = this.lich.homePos.m_7495_().m_7495_().m_7918_(i, 0, ii);
                    if (!LichEntity.this.m_20193_().m_8055_(position).m_60796_((BlockGetter)LichEntity.this.m_20193_(), position)) continue;
                    this.positions.add(this.pos.m_7918_(i, 10, ii));
                }
            }
            super.m_8056_();
        }

        public void m_8041_() {
            LichEntity.this.setAnimationState(1);
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (LichEntity.this.getCorpseSpellTimer() > 0) {
                return true;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (LichEntity.this.getCorpseSpellTimer() > 1) {
                LichEntity.this.setAnimationState(3);
                if (LichEntity.this.getCorpseSpellTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
            if (LichEntity.this.getCorpseSpellTimer() % 200 == 0) {
                LichEntity.this.summonMob(true);
            }
            if (this.positions.size() <= 3) {
                LichEntity.this.setCorpseSpellTimer(0);
                LichEntity.this.setPhaseInvulTimer(0);
                this.m_8041_();
                return;
            }
            ServerLevel serverWorld = (ServerLevel)LichEntity.this.m_20193_();
            FallingCorpse corpse = (FallingCorpse)TGEntities.FALLING_CORPSE.get().m_20615_((Level)serverWorld);
            BlockPos blockPos = this.positions.get(LichEntity.this.f_19796_.m_188503_(this.positions.size()));
            corpse.m_20343_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.55, (double)blockPos.m_123343_() + 0.5);
            serverWorld.m_7967_((Entity)corpse);
            if (LichEntity.this.f_19796_.m_188503_(9) == 0 && this.list.size() > 0) {
                FallingCorpse corpse2 = (FallingCorpse)TGEntities.FALLING_CORPSE.get().m_20615_((Level)serverWorld);
                Player target = this.list.get(LichEntity.this.f_19796_.m_188503_(this.list.size()));
                if (target != null && !target.m_7500_()) {
                    BlockPos blockPos2 = target.m_20183_().m_7918_(0, 10, 0);
                    corpse2.m_20343_((double)blockPos2.m_123341_() + 0.5, (double)blockPos2.m_123342_() + 0.55, (double)blockPos2.m_123343_() + 0.5);
                    serverWorld.m_7967_((Entity)corpse2);
                }
            }
        }
    }

    public class ConjureFangsGoal
    extends Goal {
        private final LichEntity mob;

        public ConjureFangsGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return LichEntity.this.canSpellCast() && LichEntity.this.f_19796_.m_188503_(25) == 0 && this.mob.getConjureFangTimer() <= -100;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            LichEntity.this.setAnimationState(1);
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (LichEntity.this.getConjureFangTimer() > 0) {
                return true;
            }
            return super.m_8045_();
        }

        public void m_8056_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity != null) {
                double d = Math.min(livingEntity.m_20186_(), this.mob.m_20186_());
                double e = Math.max(livingEntity.m_20186_(), this.mob.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(livingEntity.m_20189_() - this.mob.m_20189_()), (double)(livingEntity.m_20185_() - this.mob.m_20185_()));
                if (this.mob.m_20280_((Entity)livingEntity) <= 64.0) {
                    LichEntity.this.setConjureFangTimer(40);
                    for (int i = 0; i < 16; ++i) {
                        double h = 1.25 * (double)(i + 1);
                        int j = 1 * i;
                        this.conjureFangs(this.mob.m_20185_() + (double)Mth.m_14089_((float)f) * h, this.mob.m_20189_() + (double)Mth.m_14031_((float)f) * h, d, e, f, j);
                        this.conjureFangs(this.mob.m_20185_() + (double)Mth.m_14089_((float)(-f)) * h, this.mob.m_20189_() + (double)Mth.m_14031_((float)(-f)) * h, d, e, -f, j);
                        this.conjureFangs(this.mob.m_20185_() + (double)Mth.m_14031_((float)f) * h, this.mob.m_20189_() + (double)Mth.m_14089_((float)f) * h, d, e, f, j);
                        this.conjureFangs(this.mob.m_20185_() + (double)Mth.m_14031_((float)(-f)) * h, this.mob.m_20189_() + (double)Mth.m_14089_((float)(-f)) * h, d, e, -f, j);
                    }
                }
            }
        }

        public void m_8037_() {
            if (LichEntity.this.getConjureFangTimer() > 1) {
                LichEntity.this.setAnimationState(12);
                if (LichEntity.this.getConjureFangTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }

        private void conjureFangs(double x, double z, double maxY, double y, float yaw, int warmup) {
            BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            boolean bl = false;
            double d = 0.0;
            do {
                BlockState blockState2;
                VoxelShape voxelShape;
                BlockPos blockPos2 = blockPos.m_7495_();
                BlockState blockState = this.mob.m_20193_().m_8055_(blockPos2);
                if (!blockState.m_60783_((BlockGetter)this.mob.m_20193_(), blockPos2, Direction.UP)) continue;
                if (!this.mob.m_20193_().m_46859_(blockPos) && !(voxelShape = (blockState2 = this.mob.m_20193_().m_8055_(blockPos)).m_60812_((BlockGetter)this.mob.m_20193_(), blockPos)).m_83281_()) {
                    d = voxelShape.m_83297_(Direction.Axis.Y);
                }
                bl = true;
                break;
            } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
            if (bl) {
                this.mob.m_20193_().m_7967_((Entity)new EvokerFangs(this.mob.m_20193_(), x, (double)blockPos.m_123342_() + d, z, yaw, warmup, (LivingEntity)this.mob));
            }
        }
    }

    public class ShootSkullGoal
    extends Goal {
        private final LichEntity mob;
        public int cooldown;

        public ShootSkullGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && LichEntity.this.canSpellCast();
        }

        public void m_8056_() {
            this.cooldown = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            LichEntity.this.setAnimationState(1);
            super.m_8041_();
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.mob.m_5448_();
            if (livingEntity != null) {
                if (livingEntity.m_20280_((Entity)this.mob) < 8000.0 && livingEntity.m_20280_((Entity)this.mob) > 16.0) {
                    Level world = this.mob.m_20193_();
                    ++this.cooldown;
                    if (this.cooldown == 10) {
                        LichEntity.this.playShootSound();
                        LichEntity.this.setAnimationState(7);
                    }
                    if (this.cooldown == 20) {
                        Vec3 vec3d3 = this.mob.m_20252_(1.0f);
                        double d = this.mob.m_20280_((Entity)livingEntity) * 2.0;
                        double h = Math.sqrt(Math.sqrt(d)) * 0.5;
                        double e = livingEntity.m_20185_() - this.mob.m_20185_();
                        double f = livingEntity.m_20227_(0.5) - this.mob.m_20227_(0.5) - 1.25;
                        double g = livingEntity.m_20189_() - this.mob.m_20189_();
                        SkullEntity skull = new SkullEntity(this.mob.m_9236_(), (LivingEntity)this.mob, e, f, g);
                        skull.m_6034_(this.mob.m_20185_() - vec3d3.f_82479_ * 0.5, this.mob.m_20227_(0.5) + 1.25, this.mob.m_20189_() - vec3d3.f_82481_ * 0.5);
                        world.m_7967_((Entity)skull);
                        int amount = LichEntity.this.f_19796_.m_188503_(Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").maxAmountSkullsInShootSkullSpell) + 2;
                        for (int i = 0; i < amount; ++i) {
                            SkullEntity devSkull = new SkullEntity(this.mob.m_9236_(), (LivingEntity)this.mob, this.mob.m_217043_().m_216328_(e, 2.297 * h), f, this.mob.m_217043_().m_216328_(g, 2.297 * h));
                            devSkull.m_6034_(this.mob.m_20185_() - vec3d3.f_82479_ * 0.5, this.mob.m_20227_(0.5) + 1.25, this.mob.m_20189_() - vec3d3.f_82481_ * 0.5);
                            world.m_7967_((Entity)devSkull);
                        }
                        this.mob.m_21563_().m_24960_((Entity)livingEntity, 10.0f, 10.0f);
                    }
                    if (this.cooldown == 45) {
                        this.cooldown = -40;
                        LichEntity.this.setAnimationState(1);
                    }
                } else if (this.cooldown > 0) {
                    --this.cooldown;
                }
            }
        }
    }

    public class TeleportAndHealGoal
    extends Goal {
        private final LichEntity mob;

        public TeleportAndHealGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_21223_() <= 300.0f && LichEntity.this.f_19796_.m_188503_(40) == 0 && this.mob.getHealTimer() <= -Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownTeleportPlayerAndHeal && LichEntity.this.canSpellCast();
        }

        public void m_8056_() {
            LichEntity.this.setHealTimer(LichEntity.this.HEALING_DURATION);
            this.mob.m_20324_((double)LichEntity.this.homePos.m_123341_() + 0.5, (double)LichEntity.this.homePos.m_123342_() + 0.5, (double)LichEntity.this.homePos.m_123343_() + 0.5);
            LichEntity.this.playHealSound();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            LichEntity.this.setAnimationState(1);
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (LichEntity.this.getHealTimer() > 0) {
                return true;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (LichEntity.this.getHealTimer() > 1) {
                LichEntity.this.setAnimationState(11);
                this.mob.m_5634_(0.2f);
                if (LichEntity.this.getHealTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }
    }

    public class LevitationGoal
    extends Goal {
        private final LichEntity mob;

        public LevitationGoal(LichEntity mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return LichEntity.this.canSpellCast() && LichEntity.this.f_19796_.m_188503_(125) == 0 && this.mob.getLevitationDurationTimer() <= -Graveyard.getConfig().corruptedChampionConfigEntries.get((Object)"corrupted_champion").cooldownLevitationSpell;
        }

        public void m_8056_() {
            LichEntity.this.setLevitationDurationTimer(LichEntity.this.LEVITATION_DURATION);
            List<Player> player = LichEntity.this.getPlayersInRange(30.0);
            for (Player playerEntity : player) {
                if (playerEntity.m_7500_()) continue;
                playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, LichEntity.this.LEVITATION_DURATION, 1));
            }
            LichEntity.this.playLevitationSound();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            LichEntity.this.setAnimationState(1);
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (LichEntity.this.getLevitationDurationTimer() > 0) {
                return true;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (LichEntity.this.getLevitationDurationTimer() > 1) {
                LichEntity.this.setAnimationState(11);
                if (LichEntity.this.getLevitationDurationTimer() == 1) {
                    LichEntity.this.setAnimationState(1);
                }
            }
        }
    }
}

