/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.init;

import com.lion.graveyard.Graveyard;
import com.lion.graveyard.config.GraveyardConfig;
import com.lion.graveyard.entities.AcolyteEntity;
import com.lion.graveyard.entities.CorruptedIllager;
import com.lion.graveyard.entities.CorruptedPillager;
import com.lion.graveyard.entities.CorruptedVindicator;
import com.lion.graveyard.entities.FallingCorpse;
import com.lion.graveyard.entities.GhoulEntity;
import com.lion.graveyard.entities.GhoulingEntity;
import com.lion.graveyard.entities.LichEntity;
import com.lion.graveyard.entities.NamelessHangedEntity;
import com.lion.graveyard.entities.NightmareEntity;
import com.lion.graveyard.entities.ReaperEntity;
import com.lion.graveyard.entities.RevenantEntity;
import com.lion.graveyard.entities.SkeletonCreeper;
import com.lion.graveyard.entities.WraithEntity;
import com.lion.graveyard.entities.projectiles.SkullEntity;
import com.lion.graveyard.init.TGTags;
import com.lion.graveyard.mixin.SpawnRestrictionAccessor;
import com.lion.graveyard.platform.BiomeModifications;
import com.lion.graveyard.platform.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;

public class TGEntities {
    public static final Supplier<EntityType<ReaperEntity>> REAPER = RegistryHelper.registerEntityType("reaper", () -> EntityType.Builder.m_20704_(ReaperEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.5f, 1.4f).m_20712_(Graveyard.createStringID("reaper")));
    public static final Supplier<EntityType<AcolyteEntity>> ACOLYTE = RegistryHelper.registerEntityType("acolyte", () -> EntityType.Builder.m_20704_(AcolyteEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20712_(Graveyard.createStringID("acolyte")));
    public static final Supplier<EntityType<CorruptedVindicator>> CORRUPTED_VINDICATOR = RegistryHelper.registerEntityType("corrupted_vindicator", () -> EntityType.Builder.m_20704_(CorruptedVindicator::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20712_(Graveyard.createStringID("corrupted_vindicator")));
    public static final Supplier<EntityType<CorruptedPillager>> CORRUPTED_PILLAGER = RegistryHelper.registerEntityType("corrupted_pillager", () -> EntityType.Builder.m_20704_(CorruptedPillager::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20712_(Graveyard.createStringID("corrupted_pillager")));
    public static final Supplier<EntityType<SkeletonCreeper>> SKELETON_CREEPER = RegistryHelper.registerEntityType("skeleton_creeper", () -> EntityType.Builder.m_20704_(SkeletonCreeper::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.7f).m_20712_(Graveyard.createStringID("skeleton_creeper")));
    public static final Supplier<EntityType<FallingCorpse>> FALLING_CORPSE = RegistryHelper.registerEntityType("falling_corpse", () -> EntityType.Builder.m_20704_(FallingCorpse::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.5f).m_20712_(Graveyard.createStringID("falling_corpse")));
    public static final Supplier<EntityType<GhoulEntity>> GHOUL = RegistryHelper.registerEntityType("ghoul", () -> EntityType.Builder.m_20704_(GhoulEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 2.1f).m_20712_(Graveyard.createStringID("ghoul")));
    public static final Supplier<EntityType<RevenantEntity>> REVENANT = RegistryHelper.registerEntityType("revenant", () -> EntityType.Builder.m_20704_(RevenantEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20712_(Graveyard.createStringID("revenant")));
    public static final Supplier<EntityType<WraithEntity>> WRAITH = RegistryHelper.registerEntityType("wraith", () -> EntityType.Builder.m_20704_(WraithEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.8f).m_20712_(Graveyard.createStringID("wraith")));
    public static final Supplier<EntityType<NightmareEntity>> NIGHTMARE = RegistryHelper.registerEntityType("nightmare", () -> EntityType.Builder.m_20704_(NightmareEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.6f).m_20712_(Graveyard.createStringID("nightmare")));
    public static final Supplier<EntityType<GhoulingEntity>> GHOULING = RegistryHelper.registerEntityType("ghouling", () -> EntityType.Builder.m_20704_(GhoulingEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.7f, 2.0f).m_20712_(Graveyard.createStringID("ghouling")));
    public static final Supplier<EntityType<LichEntity>> LICH = RegistryHelper.registerEntityType("lich", () -> EntityType.Builder.m_20704_(LichEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.9f, 4.0f).m_20712_(Graveyard.createStringID("lich")));
    public static final Supplier<EntityType<SkullEntity>> SKULL = RegistryHelper.registerEntityType("skull", () -> EntityType.Builder.m_20704_(SkullEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_(Graveyard.createStringID("skull")));
    public static final Supplier<EntityType<NamelessHangedEntity>> NAMELESS_HANGED = RegistryHelper.registerEntityType("nameless_hanged", () -> EntityType.Builder.m_20704_(NamelessHangedEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 2.5f).m_20712_(Graveyard.createStringID("nameless_hanged")));

    private TGEntities() {
    }

    public static void init() {
        TGEntities.createMobAttributes();
    }

    public static void postInit() {
        TGEntities.addSpawnRestrictions();
        TGEntities.addSpawns();
    }

    private static void addSpawns() {
        GraveyardConfig config = Graveyard.getConfig();
        BiomeModifications.addMobSpawn(TGTags.GHOUL_SPAWNS, MobCategory.MONSTER, GHOUL.get(), config.mobConfigEntries.get((Object)"ghoul").weight, config.mobConfigEntries.get((Object)"ghoul").minGroup, config.mobConfigEntries.get((Object)"ghoul").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.REVENANT_SPAWNS, MobCategory.MONSTER, REVENANT.get(), config.mobConfigEntries.get((Object)"revenant").weight, config.mobConfigEntries.get((Object)"revenant").minGroup, config.mobConfigEntries.get((Object)"revenant").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.REAPER_SPAWNS, MobCategory.MONSTER, REAPER.get(), config.mobConfigEntries.get((Object)"reaper").weight, config.mobConfigEntries.get((Object)"reaper").minGroup, config.mobConfigEntries.get((Object)"reaper").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.NIGHTMARE_SPAWNS, MobCategory.MONSTER, NIGHTMARE.get(), config.mobConfigEntries.get((Object)"nightmare").weight, config.mobConfigEntries.get((Object)"nightmare").minGroup, config.mobConfigEntries.get((Object)"nightmare").maxGroup);
        BiomeModifications.addMobSpawn(TGTags.SKELETON_CREEPER_SPAWNS, MobCategory.MONSTER, SKELETON_CREEPER.get(), config.mobConfigEntries.get((Object)"skeleton_creeper").weight, config.mobConfigEntries.get((Object)"skeleton_creeper").minGroup, config.mobConfigEntries.get((Object)"skeleton_creeper").maxGroup);
    }

    private static void addSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister(REAPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(ACOLYTE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        SpawnRestrictionAccessor.callRegister(CORRUPTED_VINDICATOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        SpawnRestrictionAccessor.callRegister(CORRUPTED_PILLAGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        SpawnRestrictionAccessor.callRegister(SKELETON_CREEPER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(FALLING_CORPSE.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        SpawnRestrictionAccessor.callRegister(GHOUL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(REVENANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(WRAITH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(NIGHTMARE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        SpawnRestrictionAccessor.callRegister(LICH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
    }

    private static void createMobAttributes() {
        RegistryHelper.registerEntityAttribute(REAPER, ReaperEntity::createReaperAttributes);
        RegistryHelper.registerEntityAttribute(ACOLYTE, CorruptedIllager::createCorruptedIllagerAttributes);
        RegistryHelper.registerEntityAttribute(CORRUPTED_VINDICATOR, CorruptedIllager::createCorruptedIllagerAttributes);
        RegistryHelper.registerEntityAttribute(CORRUPTED_PILLAGER, CorruptedPillager::createCorruptedPillagerAttributes);
        RegistryHelper.registerEntityAttribute(SKELETON_CREEPER, SkeletonCreeper::createSkeletonCreeperAttributes);
        RegistryHelper.registerEntityAttribute(FALLING_CORPSE, FallingCorpse::createFallingCorpseAttributes);
        RegistryHelper.registerEntityAttribute(GHOUL, GhoulEntity::createGhoulAttributes);
        RegistryHelper.registerEntityAttribute(REVENANT, RevenantEntity::createRevenantAttributes);
        RegistryHelper.registerEntityAttribute(WRAITH, WraithEntity::createWraithAttributes);
        RegistryHelper.registerEntityAttribute(NIGHTMARE, NightmareEntity::createNightmareAttributes);
        RegistryHelper.registerEntityAttribute(GHOULING, GhoulingEntity::createGhoulingAttributes);
        RegistryHelper.registerEntityAttribute(NAMELESS_HANGED, NamelessHangedEntity::createNamelessHangedAttributes);
        RegistryHelper.registerEntityAttribute(LICH, LichEntity::createLichAttributes);
    }
}

