/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;

public class NBTParser {
    public static final int TRUNK_PIECE_SIZE = 3;
    public static final int LEAF_PIECE_SIZE = 4;

    public static void parseNBTFiles() throws IOException {
        File dataDirectory = FabricLoader.getInstance().getGameDir().resolve("data").toFile();
        File targetFolder = new File(dataDirectory, "graveyard/nbt");
        File outputFile = new File(dataDirectory, "graveyard/nbt/out.txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
        if (targetFolder.exists() && targetFolder.isDirectory()) {
            File[] filesInDir;
            for (File nbtFile : filesInDir = targetFolder.listFiles()) {
                if (nbtFile.getName().equals("out.txt")) continue;
                ArrayList<Integer> trunkStates = new ArrayList<Integer>();
                ArrayList<Integer> leavesStates = new ArrayList<Integer>();
                writer.write(nbtFile.getName());
                writer.newLine();
                if (nbtFile.exists()) {
                    try {
                        CompoundTag nbt = NbtIo.m_128937_((File)nbtFile);
                        ListTag sizeList = nbt.m_128437_("size", 3);
                        int sizeX = sizeList.m_128763_(0);
                        int sizeZ = sizeList.m_128763_(2);
                        int centerX = sizeX / 2;
                        int centerZ = sizeZ / 2;
                        ListTag blocks = nbt.m_128437_("blocks", 10);
                        ListTag palette = nbt.m_128437_("palette", 10);
                        for (int i = 0; i < blocks.size(); ++i) {
                            ResourceLocation blockId;
                            Block block;
                            CompoundTag blockTag = blocks.m_128728_(i);
                            ListTag posList = blockTag.m_128437_("pos", 3);
                            int posX = posList.m_128763_(0);
                            int posY = posList.m_128763_(1);
                            int posZ = posList.m_128763_(2);
                            int state = blockTag.m_128451_("state");
                            CompoundTag paletteEntry = palette.m_128728_(state);
                            String blockName = paletteEntry.m_128461_("Name");
                            if (blockName.equals("minecraft:air") || !((block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockId = new ResourceLocation(blockName))) instanceof LeavesBlock) && !(block instanceof RotatedPillarBlock)) continue;
                            CompoundTag propertiesNbt = paletteEntry.m_128469_("Properties");
                            if (block instanceof RotatedPillarBlock) {
                                trunkStates.add(posX - centerX);
                                trunkStates.add(posY);
                                trunkStates.add(posZ - centerZ);
                                continue;
                            }
                            leavesStates.add(posX - centerX);
                            leavesStates.add(posY);
                            leavesStates.add(posZ - centerZ);
                            leavesStates.add(Integer.parseInt(propertiesNbt.m_128461_("distance")));
                        }
                        int n = nbt.m_128451_("DataVersion");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Iterator iterator = trunkStates.iterator();
                while (iterator.hasNext()) {
                    int item = (Integer)iterator.next();
                    writer.write(Integer.toString(item));
                    writer.write(", ");
                }
                writer.newLine();
                iterator = leavesStates.iterator();
                while (iterator.hasNext()) {
                    int item = (Integer)iterator.next();
                    writer.write(Integer.toString(item));
                    writer.write(", ");
                }
                writer.newLine();
                writer.newLine();
            }
        }
        writer.close();
    }
}

