/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.client.event.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;

public class CustomBossBar {
    public static Map<Integer, CustomBossBar> customBossBars = new HashMap<Integer, CustomBossBar>();
    private final ResourceLocation baseTexture;
    private final ResourceLocation overlayTexture;
    private final boolean hasOverlay;
    private final int baseHeight;
    private final int baseTextureHeight;
    private final int baseOffsetX;
    private final int baseOffsetY;
    private final int overlayOffsetX;
    private final int overlayOffsetY;
    private final int overlayWidth;
    private final int overlayHeight;
    private final int verticalIncrement;
    private final int getProgress;
    private final ChatFormatting textColor;

    public CustomBossBar(ResourceLocation baseTexture, ResourceLocation overlayTexture, int baseHeight, int baseTextureHeight, int baseOffsetX, int baseOffsetY, int overlayOffsetX, int overlayOffsetY, int overlayWidth, int overlayHeight, int verticalIncrement, int getProgress, ChatFormatting textColor) {
        this.baseTexture = baseTexture;
        this.overlayTexture = overlayTexture;
        this.hasOverlay = overlayTexture != null;
        this.baseHeight = baseHeight;
        this.baseTextureHeight = baseTextureHeight;
        this.baseOffsetX = baseOffsetX;
        this.baseOffsetY = baseOffsetY;
        this.overlayOffsetX = overlayOffsetX;
        this.overlayOffsetY = overlayOffsetY;
        this.overlayWidth = overlayWidth;
        this.overlayHeight = overlayHeight;
        this.verticalIncrement = verticalIncrement;
        this.getProgress = getProgress;
        this.textColor = textColor;
    }

    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public int getBaseHeight() {
        return this.baseHeight;
    }

    public int getBaseTextureHeight() {
        return this.baseTextureHeight;
    }

    public int getBaseOffsetX() {
        return this.baseOffsetX;
    }

    public int getBaseOffsetY() {
        return this.baseOffsetY;
    }

    public int getOverlayOffsetX() {
        return this.overlayOffsetX;
    }

    public int getOverlayOffsetY() {
        return this.overlayOffsetY;
    }

    public int getOverlayWidth() {
        return this.overlayWidth;
    }

    public int getOverlayHeight() {
        return this.overlayHeight;
    }

    public int getProgress() {
        return this.getProgress;
    }

    public int getVerticalIncrement() {
        return this.verticalIncrement;
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int y = event.getY();
        int i = Minecraft.m_91087_().m_91268_().m_85445_();
        int j = y - 9;
        Minecraft.m_91087_().m_91307_().m_6180_("CataclysmCustomBossBarBase");
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBaseTexture());
        this.drawBar(guiGraphics, event.getX() + this.getBaseOffsetX(), y + this.getBaseOffsetY(), (BossEvent)event.getBossEvent());
        MutableComponent component = event.getBossEvent().m_18861_().m_6881_().m_130940_(this.getTextColor());
        Minecraft.m_91087_().m_91307_().m_7238_();
        int l = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        int i1 = i / 2 - l / 2;
        int j1 = j;
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)component, i1, j1, 0xFFFFFF);
        if (this.hasOverlay()) {
            Minecraft.m_91087_().m_91307_().m_6180_("CataclysmCustomBossBarOverlay");
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getOverlayTexture());
            event.getGuiGraphics().m_280163_(this.getOverlayTexture(), event.getX() + this.getBaseOffsetX() + this.getOverlayOffsetX(), y + this.getOverlayOffsetY() + this.getBaseOffsetY(), 0.0f, 0.0f, this.getOverlayWidth(), this.getOverlayHeight(), this.getOverlayWidth(), this.getOverlayHeight());
            Minecraft.m_91087_().m_91307_().m_7238_();
        }
        event.setIncrement(this.getVerticalIncrement());
    }

    private void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent event) {
        guiGraphics.m_280163_(this.getBaseTexture(), x, y, 0.0f, 0.0f, this.getProgress(), this.getBaseHeight(), 256, this.getBaseTextureHeight());
        int i = (int)(event.m_142717_() * (float)(this.getProgress() + 1));
        if (i > 0) {
            guiGraphics.m_280163_(this.getBaseTexture(), x, y, 0.0f, (float)this.getBaseHeight(), i, this.getBaseHeight(), 256, this.getBaseTextureHeight());
        }
    }

    static {
        customBossBars.put(0, new CustomBossBar(new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/cloud_golem_bar_base.png"), new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/cloud_golem_bar_overlay.png"), 5, 16, 0, 10, -2, -13, 256, 32, 30, 182, ChatFormatting.WHITE));
        customBossBars.put(1, new CustomBossBar(new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/cloud_golem_thunder_bar_base.png"), new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/cloud_golem_thunder_bar_overlay.png"), 5, 16, 0, 10, -2, -13, 256, 32, 30, 182, ChatFormatting.GRAY));
        customBossBars.put(2, new CustomBossBar(new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/possessed_bar_base.png"), new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/possessed_bar_overlay.png"), 30, 64, 0, 6, -4, -6, 256, 64, 50, 178, ChatFormatting.GRAY));
        customBossBars.put(3, new CustomBossBar(new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/the_warped_one_bar_base.png"), new ResourceLocation("legendary_monsters", "textures/gui/boss_bar/the_warped_one_bar_overlay.png"), 5, 16, 0, 15, -3, -13, 256, 32, 40, 182, ChatFormatting.GREEN));
    }
}

