/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AbandonedCrypt;

import java.util.List;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AbandonedCrypt.HauntedKnightEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.AncientStronghold.Ancient_GuardianEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.miauczel.legendary_monsters.tag.ModEntityTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.jetbrains.annotations.Nullable;

public class HauntedGuardEntity
extends IAnimatedMonster
implements IForgeEntity {
    private final int textureVariant;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(HauntedGuardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int slamCooldown = 20;
    public int dragonDeathTime;
    public final AnimationState DeathAnimationState = new AnimationState();
    public int DeathAnimationTimeout = 60;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState stabAnimationState = new AnimationState();
    public AnimationState slamAnimationState = new AnimationState();
    public AnimationState combo2AnimationState = new AnimationState();
    public AnimationState slashAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();

    public HauntedGuardEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 2;
        this.m_21557_(false);
        this.textureVariant = this.f_19796_.m_188503_(3);
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.slamCooldown > 0) {
            --this.slamCooldown;
        }
        this.updateAttributes();
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Ancient_GuardianEntity.class, true));
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 2, 0, 40, 40, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HauntedGuardEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && HauntedGuardEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 4, 0, 40, 40, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HauntedGuardEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && HauntedGuardEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 6, 0, 33, 33, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HauntedGuardEntity.this.m_217043_().m_188501_() * 35.0f < 16.0f && HauntedGuardEntity.this.slamCooldown <= 0 && HauntedGuardEntity.this.m_5448_() != null;
            }

            @Override
            public void m_8041_() {
                HauntedGuardEntity.this.slamCooldown = 20;
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 5, 0, 63, 63, 4.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && HauntedGuardEntity.this.m_217043_().m_188501_() * 35.0f < 50.0f && HauntedGuardEntity.this.m_5448_() != null;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
    }

    public int getTextureVariant() {
        return this.textureVariant;
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        this.UpdateWithAttack();
        if (this.f_19862_ && this.m_5830_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.1, 0.0, 0.1));
        }
        if ((target = this.m_5448_()) != null) {
            double targetX = target.m_20185_() - this.m_20185_();
            double targetY = target.m_20188_() - this.m_20188_();
            double targetZ = target.m_20189_() - this.m_20189_();
            double horizontalDistance = Math.sqrt(targetX * targetX + targetZ * targetZ);
            float yaw = (float)(Math.atan2(targetZ, targetX) * 57.29577951308232) - 90.0f;
            float pitch = (float)(-(Math.atan2(targetY, horizontalDistance) * 57.29577951308232));
            this.f_20885_ = this.f_20883_ = yaw;
            this.f_20883_ = pitch;
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.1) {
                movementSpeedAttribute.m_22100_(0.1);
            }
        } else {
            AttributeInstance movementSpeedAttribute = this.m_21051_(Attributes.f_22279_);
            if (movementSpeedAttribute != null && movementSpeedAttribute.m_22135_() != 0.0) {
                movementSpeedAttribute.m_22100_(0.0);
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, (double)0.7f).m_22268_(Attributes.f_22277_, 14.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 1.3).m_22268_(Attributes.f_22281_, 11.0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.LIVING_ARMOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.setAttackState(7);
        this.dragonDeathTime = 0;
        ItemStack diamond = new ItemStack((ItemLike)ModItems.LONG_STICK_HALF.get(), 1);
        ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (((Boolean)ModConfig.MOB_CONFIG.Guardprojectile.get()).booleanValue() && source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.HauntedGuardHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.HauntedGuardDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 35.0;
        double baseAttackDamage = 7.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    public boolean m_7307_(Entity pEntity) {
        return pEntity.m_6095_().m_204039_(ModEntityTags.POSSESSED_ARMOR_TEAM) || super.m_7307_(pEntity);
    }

    private void AreaAttack(float range, float height, float arc, float damage, int maxExtraMobs) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        int attackedExtraMobCount = 0;
        for (LivingEntity entityHit : entitiesHit) {
            boolean isEnemy;
            boolean inArc;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            boolean inRange = entityHitDistance <= range;
            boolean bl = inArc = entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f;
            if (!inRange || !inArc || !(isEnemy = !this.m_7307_((Entity)entityHit) && entityHit != this && !(entityHit instanceof HauntedGuardEntity) && !(entityHit instanceof HauntedKnightEntity) && !this.m_7307_((Entity)entityHit))) continue;
            if (entityHit == this.m_5448_()) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 1.0f);
                entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.HauntedGuardDamageMutliplier.get()));
                continue;
            }
            if (attackedExtraMobCount >= maxExtraMobs) continue;
            this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get(), 1.0f, 1.0f);
            entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.HauntedGuardDamageMutliplier.get()));
            ++attackedExtraMobCount;
        }
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    public void UpdateWithAttack() {
        SoundEvent customAttackSound;
        int extraMobs = 2;
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 17) {
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 1.5f);
            }
            if (this.attackTicks == 20) {
                this.AreaAttack(4.5f, 4.0f, 180.0f, 10.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 15) {
                this.calculatedDash(0.2f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 1.5f);
            }
            if (this.attackTicks == 18) {
                this.AreaAttack(4.5f, 4.0f, 100.0f, 10.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
        if (this.getAttackState() == 6) {
            if (this.attackTicks == 9) {
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(4.5f, 4.0f, 100.0f, 11.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
        if (this.getAttackState() == 5) {
            if (this.attackTicks == 9) {
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 2.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(4.5f, 4.0f, 100.0f, 11.0f, extraMobs);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
            if (this.attackTicks == 41) {
                this.calculatedDash(0.2f);
                customAttackSound = (SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get();
                this.m_5496_(customAttackSound, 1.0f, 1.5f);
            }
            if (this.attackTicks == 44) {
                this.AreaAttack(4.5f, 4.0f, 180.0f, 10.0f, extraMobs);
                SoundEvent soundEvent = (SoundEvent)ModSounds.POSESSED_PALADIN_ATTACK3.get();
            }
        }
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    protected void m_6153_() {
        ++this.dragonDeathTime;
        boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
        if (this.m_9236_() instanceof ServerLevel && this.dragonDeathTime > 1 && !this.m_20067_()) {
            this.m_21557_(true);
        }
        if (this.dragonDeathTime == 30) {
            Vec3 vec3 = this.m_20182_();
        }
        if (this.dragonDeathTime == 60 && this.m_9236_() instanceof ServerLevel) {
            ItemStack diamond = new ItemStack((ItemLike)ModItems.LONG_STICK_HALF.get(), 1);
            ItemStack emerald = new ItemStack((ItemLike)Items.f_41852_, 1);
            if (Math.random() < 0.7) {
                // empty if block
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public AnimationState getAnimationState(String input) {
        if (input == "slash") {
            return this.slashAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "sit") {
            return this.sitAnimationState;
        }
        if (input == "stab") {
            return this.stabAnimationState;
        }
        if (input == "combo2") {
            return this.combo2AnimationState;
        }
        if (input == "death") {
            return this.DeathAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.slashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.stabAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.combo2AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.slamAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.DeathAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.sitAnimationState.m_216973_();
        this.DeathAnimationState.m_216973_();
        this.slamAnimationState.m_216973_();
        this.slashAnimationState.m_216973_();
        this.stabAnimationState.m_216973_();
        this.combo2AnimationState.m_216973_();
    }
}

