/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.CloudyTemple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.IAnimatedBoss.CloudGolem.Cloud_GolemEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.IAnimatedMonster;
import net.miauczel.legendary_monsters.entity.ai.goal.IAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.IMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.item.ModItems;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StratlingEntity
extends IAnimatedMonster
implements Merchant {
    private MerchantOffers offers = new MerchantOffers();
    private Player tradingPlayer;
    private boolean hasTraded = false;
    public int ticksUntilNextAllert = 0;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState upperCutAnimationState = new AnimationState();
    public AnimationState slapAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public StratlingEntity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 5;
        this.populateTrades();
        this.m_21530_();
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        return this.offers;
    }

    public void m_6255_(MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
    }

    public void m_7713_(ItemStack stack) {
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int pXp) {
    }

    private void startTrading(Player pPlayer) {
        if (this.m_5448_() == null) {
            this.m_7189_(pPlayer);
            this.m_45301_(pPlayer, this.m_5446_(), 1);
            this.hasTraded = true;
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_41720_() != Items.f_42601_ && this.m_6084_() && !this.m_5803_() && !pPlayer.m_36341_()) {
            if (this.m_6162_()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            boolean flag = this.m_6616_().isEmpty();
            if (pHand == InteractionHand.MAIN_HAND) {
                if (!flag || !this.m_9236_().f_46443_) {
                    // empty if block
                }
                pPlayer.m_36220_(Stats.f_12940_);
            }
            if (flag) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_9236_().f_46443_ && !this.offers.isEmpty()) {
                this.startTrading(pPlayer);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void populateTrades() {
        ArrayList<MerchantOffer> allPossibleOffers = new ArrayList<MerchantOffer>();
        int randomPrice = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)25);
        ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42677_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)5));
        ItemStack itemstack3 = new ItemStack((ItemLike)Items.f_42406_, Mth.m_216271_((RandomSource)this.f_19796_, (int)5, (int)8));
        ItemStack itemstack2 = new ItemStack((ItemLike)Items.f_42517_, Mth.m_216271_((RandomSource)this.f_19796_, (int)3, (int)5));
        ItemStack itemstack4 = new ItemStack((ItemLike)Items.f_151079_, Mth.m_216271_((RandomSource)this.f_19796_, (int)6, (int)10));
        ItemStack itemstack5 = new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)3, (int)5));
        ItemStack itemstack6 = new ItemStack((ItemLike)Items.f_42415_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)3));
        ItemStack itemstack7 = new ItemStack((ItemLike)Items.f_42656_, Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)1));
        ItemStack itemstack8 = new ItemStack((ItemLike)Items.f_42534_, Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)3));
        ItemStack itemstack9 = new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)6, (int)8));
        ItemStack itemstack12 = new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)2));
        ItemStack itemstack11 = new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)10, (int)25));
        ItemStack itemstack10 = new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)10, (int)25));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, randomPrice), this.createRandomEnchantedBook(), 10, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)13)), Items.f_42584_.m_7968_(), 3, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)5, (int)7)), itemstack6, 6, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)5)), Items.f_42110_.m_7968_(), 6, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)8, (int)16)), this.createRandomEnchantedBook(), 2, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)8, (int)16)), this.createRandomEnchantedBook(), 2, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)5)), itemstack1, 4, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)5)), itemstack2, 7, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)3)), itemstack3, 7, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_151049_, Mth.m_216271_((RandomSource)this.f_19796_, (int)3, (int)4)), itemstack4, 8, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_42517_, Mth.m_216271_((RandomSource)this.f_19796_, (int)2, (int)3)), itemstack5, 7, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)Items.f_42534_, Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)3)), itemstack5, 7, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)ModItems.CLOUD_ROD.get(), 1), itemstack10, 3, 1, 0.05f));
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.MUSIC_DISC_CLOUD_GOLEM.get(), 1);
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)ModItems.CLOUD_ROD.get(), 6), itemStack, 3, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)ModItems.CHISELED_ANCIENT_DRIPTONE_SHARD.get(), 1), itemstack11, 10, 1, 0.05f));
        allPossibleOffers.add(new MerchantOffer(new ItemStack((ItemLike)ModItems.ANCIENT_SPIKE.get(), 1), itemstack12, 15, 1, 0.05f));
        Collections.shuffle(allPossibleOffers, new Random(this.f_19796_.m_188505_()));
        MerchantOffers selectedOffers = new MerchantOffers();
        HashSet<String> usedKeys = new HashSet<String>();
        for (MerchantOffer offer : allPossibleOffers) {
            String key = this.getOfferKey(offer);
            if (!usedKeys.contains(key)) {
                usedKeys.add(key);
                selectedOffers.add((Object)offer);
            }
            if (selectedOffers.size() < 7) continue;
            break;
        }
        this.offers = selectedOffers;
    }

    private void handleAlerting() {
        if (this.ticksUntilNextAllert <= 0 && this.m_5448_() != null) {
            this.alertOthers();
        }
        --this.ticksUntilNextAllert;
    }

    private void alertOthers() {
        this.ticksUntilNextAllert = 100;
        double d0 = this.m_21133_(Attributes.f_22277_);
        AABB aabb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
        this.m_9236_().m_6443_(StratlingEntity.class, aabb, EntitySelector.f_20408_).stream().filter(p_34463_ -> p_34463_ != this).filter(p_289465_ -> p_289465_.m_5448_() == null).filter(p_289463_ -> {
            if (this.m_5448_() != null) {
                return !p_289463_.m_7307_((Entity)this.m_5448_());
            }
            return this.m_7307_((Entity)p_289463_);
        }).forEach(p_289464_ -> p_289464_.m_6710_(this.m_5448_()));
    }

    private String getOfferKey(MerchantOffer offer) {
        String costA = offer.m_45358_().m_41720_().m_5524_() + "_" + offer.m_45358_().m_41613_();
        String result = offer.m_45368_().m_41720_().m_5524_() + "_" + offer.m_45368_().m_41613_();
        Object costB = "";
        if (!offer.m_45364_().m_41619_()) {
            costB = offer.m_45364_().m_41720_().m_5524_() + "_" + offer.m_45364_().m_41613_();
        }
        return costA + "_" + (String)costB + "_" + result;
    }

    private ItemStack createRandomEnchantedBook() {
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.f_42690_);
        Enchantment randomEnchant = this.getRandomEnchantment();
        int randomLevel = Mth.m_216271_((RandomSource)this.f_19796_, (int)1, (int)randomEnchant.m_6586_());
        EnchantedBookItem.m_41153_((ItemStack)enchantedBook, (EnchantmentInstance)new EnchantmentInstance(randomEnchant, randomLevel));
        return enchantedBook;
    }

    private Enchantment getRandomEnchantment() {
        List<Enchantment> enchantments = BuiltInRegistries.f_256876_.m_123024_().filter(enchantment -> enchantment.f_44672_ == EnchantmentCategory.WEAPON || enchantment.f_44672_ == EnchantmentCategory.ARMOR || enchantment.f_44672_ == EnchantmentCategory.DIGGER || enchantment.f_44672_ == EnchantmentCategory.ARMOR_FEET || enchantment.f_44672_ == EnchantmentCategory.ARMOR_HEAD || enchantment.f_44672_ == EnchantmentCategory.ARMOR_LEGS || enchantment.f_44672_ == EnchantmentCategory.BOW || enchantment.f_44672_ == EnchantmentCategory.CROSSBOW || enchantment.f_44672_ == EnchantmentCategory.TRIDENT).toList();
        return enchantments.get(this.f_19796_.m_188503_(enchantments.size()));
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_183595_() {
        return false;
    }

    private void sendActionBarMessageToPlayer(Player player, String message) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)message)));
        }
    }

    @Override
    public void m_8119_() {
        for (Player livingentity : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82377_(1.3, 0.0, 1.3))) {
            if (this.m_5448_() != null) continue;
            this.sendActionBarMessageToPlayer(livingentity, "legendary_monsters.message.stratling_interaction");
        }
        this.handleAlerting();
        this.updateWithAttack();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0, this.f_19797_);
        }
        if (this.m_5448_() instanceof Cloud_GolemEntity) {
            this.m_6710_(null);
        }
        super.m_8119_();
    }

    protected boolean canDespawn() {
        return false;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
        this.hasTraded = compound.m_128471_("HasTraded");
        if (this.hasTraded && compound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compound.m_128469_("Offers"));
        } else {
            this.populateTrades();
        }
    }

    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.StratlingHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.StratlingDamageMultiplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 30.0;
        double baseAttackDamage = 5.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasTraded", this.hasTraded);
        if (this.hasTraded && !this.offers.isEmpty()) {
            compound.m_128365_("Offers", (Tag)this.offers.m_45388_());
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 3.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, SnowGolem.class, true));
        this.f_21345_.m_25352_(2, (Goal)new IMoveGoal(this, false, 3.0));
        this.f_21345_.m_25352_(1, (Goal)new StratlingAttackGoal(this, 0, 2, 0, 25, 25, 3.5f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && StratlingEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && StratlingEntity.this.m_5448_() != null && StratlingEntity.this.getAttackState() != 3;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new IAttackGoal(this, 0, 3, 0, 35, 35, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && StratlingEntity.this.m_217043_().m_188501_() * 40.0f < 16.0f && StratlingEntity.this.m_5448_() != null && StratlingEntity.this.getAttackState() != 2;
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 6.0);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "slap") {
            return this.slapAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "uppercut") {
            return this.upperCutAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.slapAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.upperCutAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.upperCutAnimationState.m_216973_();
        this.slapAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    private void dash(float a1, float a2, float minD) {
        if (this.m_20096_()) {
            LivingEntity target = this.m_5448_();
            if (this.m_5448_() != null) {
                assert (target != null);
                double distanceToTarget = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                if (distanceToTarget > (double)minD) {
                    Vec3 vector3d = this.m_20184_();
                    float f = this.m_146908_() * ((float)Math.PI / 180);
                    Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_((double)a1).m_82549_(vector3d.m_82490_((double)a2));
                    this.m_20334_(vector3d1.f_82479_, this.m_20184_().f_82480_, vector3d1.f_82481_);
                }
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            boolean flag;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if ((entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && !this.m_7307_((Entity)entityHit) && !(entityHit instanceof StratlingEntity) && !(entityHit instanceof Cloud_GolemEntity) && entityHit != this && !(flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.StratlingDamageMultiplier.get())))) continue;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() != 14 || this.getAttackState() != 17) {
            this.m_20242_(false);
        }
        int i = 0;
        while ((double)i < 0.5) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.025, 0.0);
            ++i;
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.CGA.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.CGH.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.CGD.get();
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public void updateWithAttack() {
        if (this.getAttackState() == 3) {
            if (this.attackTicks == 8) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 2.0f);
                this.dash(1.3f, 1.0f, 3.0f);
            }
            if (this.attackTicks == 13) {
                this.AreaAttack(3.2f, 3.0f, 180.0f, 8.0f);
            }
        }
        if (this.getAttackState() == 2) {
            if (this.attackTicks == 7) {
                this.m_5496_((SoundEvent)ModSounds.POSESSED_PALADIN_SWING.get(), 1.0f, 2.0f);
            }
            if (this.attackTicks == 10) {
                this.AreaAttack(3.5f, 3.0f, 180.0f, 5.0f);
            }
        }
    }

    public static class StratlingAttackGoal
    extends Goal {
        protected final IAnimatedMonster entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;

        public StratlingAttackGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public StratlingAttackGoal(IAnimatedMonster entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, EnumSet<Goal.Flag> interruptFlagTypes) {
            this.entity = entity;
            this.m_7021_(interruptFlagTypes);
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            this.entity.attackCooldown = 0;
        }

        public boolean m_8045_() {
            return this.entity.attackTicks < this.attackMaxtick;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
        }

        public boolean m_183429_() {
            return false;
        }
    }
}

