/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Pets;

import java.util.List;
import java.util.UUID;
import net.miauczel.legendary_monsters.config.ModConfig;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.IAnimatedTamableMob;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ILookingTamableMobStateGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobAttackGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobMoveGoal;
import net.miauczel.legendary_monsters.entity.ai.goal.ITamableMonster.ITamableMobStateGoal;
import net.miauczel.legendary_monsters.entity.ai.navigation.EntityRotationPatcher;
import net.miauczel.legendary_monsters.entity.ai.navigation.ModPathNavigation;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MossyGolemEntity
extends IAnimatedTamableMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(MossyGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(MossyGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(MossyGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(MossyGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int cropGrowthCooldown = 20;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();
    public AnimationState growthAnimationState = new AnimationState();
    public AnimationState sitAnimationState = new AnimationState();

    public MossyGolemEntity(EntityType<? extends IAnimatedTamableMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    private void sendActionBarMessageToPlayer(Player player, String translationKey, String entityName) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)entityName)).m_130946_(">").m_7220_((Component)Component.m_237115_((String)translationKey));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    @Override
    public double baseHealth() {
        return 60.0;
    }

    @Override
    public double baseDamage() {
        return 12.0;
    }

    @Override
    public double healthMult() {
        return (Double)ModConfig.MOB_CONFIG.MossyGolemHealthMultiplier.get();
    }

    @Override
    public double damageMult() {
        return (Double)ModConfig.MOB_CONFIG.MossyGolemDamageMutliplier.get();
    }

    private String getEntityName() {
        if (this.m_8077_()) {
            return this.m_7770_().getString();
        }
        return "legendary_monsters.message.mossy_golem_string_message_name";
    }

    @Override
    public void stopAttackingAllies() {
        if (this.m_5448_() != null && this.m_5448_() instanceof TamableAnimal && this.m_269323_() != null && ((TamableAnimal)this.m_5448_()).m_269323_() == this.m_269323_()) {
            this.m_6710_(null);
        }
    }

    public void m_21839_(boolean sitting) {
        this.f_19804_.m_135381_(SITTING, (Object)sitting);
        if (sitting) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setAttackState(3);
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_sit_enable", this.getEntityName());
            }
        } else {
            LivingEntity livingEntity = this.m_269323_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.setAttackState(0);
                this.m_21573_().m_26569_();
                this.stopAllAnimationStates();
                this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_walk_enable", this.getEntityName());
            }
            this.m_21573_().m_26573_();
            this.m_21557_(false);
        }
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    private void accelerateCropGrowth(int radius, int growthStages) {
        BlockPos entityPos = this.m_20183_();
        for (int dy = -radius; dy <= radius; ++dy) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int newAge;
                    int maxAge;
                    int currentAge;
                    BlockPos checkPos = entityPos.m_7918_(dx, dy, dz);
                    BlockState state = this.m_9236_().m_8055_(checkPos);
                    if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
                        currentAge = (Integer)state.m_61143_((Property)BlockStateProperties.f_61409_);
                        if (currentAge >= (maxAge = 7)) continue;
                        newAge = Math.min(currentAge + growthStages, maxAge);
                        this.m_9236_().m_7731_(checkPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(newAge)), 2);
                        continue;
                    }
                    if (state.m_61138_((Property)BlockStateProperties.f_61407_)) {
                        currentAge = (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_);
                        if (currentAge >= (maxAge = 3)) continue;
                        newAge = Math.min(currentAge + growthStages, maxAge);
                        this.m_9236_().m_7731_(checkPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(newAge)), 2);
                        continue;
                    }
                    if (!state.m_61138_((Property)BlockStateProperties.f_61408_) || (currentAge = ((Integer)state.m_61143_((Property)BlockStateProperties.f_61408_)).intValue()) >= (maxAge = 5)) continue;
                    newAge = Math.min(currentAge + growthStages, maxAge);
                    this.m_9236_().m_7731_(checkPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61408_, (Comparable)Integer.valueOf(newAge)), 2);
                }
            }
        }
    }

    @Nullable
    public MossyGolemEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        UUID uuid;
        MossyGolemEntity armor = (MossyGolemEntity)((EntityType)ModEntities.Mossy_Golem.get()).m_20615_((Level)pLevel);
        if (armor != null && (uuid = this.m_21805_()) != null) {
            armor.m_21816_(uuid);
            armor.m_7105_(true);
        }
        return armor;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue() || this.isStanding()) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
        }
        if (this.cropGrowthCooldown > 0) {
            --this.cropGrowthCooldown;
        }
        if (this.getAttackState() == 0 && this.cropGrowthCooldown <= 0 && this.canIncreaseCropGrowth()) {
            this.cropGrowthCooldown = 260;
            this.setAttackState(4);
        }
        if (this.getAttackState() == 0 && ((Boolean)this.f_19804_.m_135370_(SITTING)).booleanValue() && this.getAttackState() != 3) {
            this.setAttackState(3);
        }
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            return;
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(this.getAttackState() == 0 && !this.isSitting(), this.f_19797_);
        }
        this.updateAttributes();
        if (this.m_9236_().m_5776_()) {
            // empty if block
        }
    }

    public void m_8107_() {
        this.stopAttackingAllies();
        if (this.getAttackState() != 4) {
            // empty if block
        }
        this.updateWithAttack();
        super.m_8107_();
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(STANDING, (Object)false);
        this.f_19804_.m_135372_(SITTING, (Object)false);
    }

    public boolean canIncreaseCropGrowth() {
        int radius = 3;
        BlockPos entityPos = this.m_20183_();
        for (int dy = -radius; dy <= radius; ++dy) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    CropBlock cropBlock;
                    BlockPos checkPos = entityPos.m_7918_(dx, dy, dz);
                    BlockState state = this.m_9236_().m_8055_(checkPos);
                    Block block = state.m_60734_();
                    if (!(block instanceof CropBlock) || (cropBlock = (CropBlock)block).m_52307_(state)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sitting", this.m_21827_());
        compound.m_128379_("standing", this.isStanding());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ILookingTamableMobStateGoal(this, 3, 3, 0, 0, 100){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ILookingTamableMobStateGoal(this, 3, 0, 0, 0, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobStateGoal(this, 4, 4, 0, 60, 0){

            @Override
            public void m_8037_() {
                this.entity.m_20334_(0.0, this.entity.m_20184_().f_82480_, 0.0);
            }

            @Override
            public boolean m_8036_() {
                return MossyGolemEntity.this.canIncreaseCropGrowth() && MossyGolemEntity.this.cropGrowthCooldown <= 0;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)MossyGolemEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 3.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 4.0, 10.0f, 2.0f, false){

            public boolean m_8045_() {
                return super.m_8045_() && !MossyGolemEntity.this.isStanding();
            }

            public boolean m_8036_() {
                return super.m_8036_() && !MossyGolemEntity.this.isStanding();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new ITamableMobAttackGoal(this, 0, 2, 0, 35, 20, 3.0f){

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && (Boolean)MossyGolemEntity.this.f_19804_.m_135370_(SITTING) == false;
            }

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && (Boolean)MossyGolemEntity.this.f_19804_.m_135370_(SITTING) == false;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new ITamableMobMoveGoal(this, false, 3.0));
    }

    protected BodyRotationControl m_7560_() {
        return new EntityRotationPatcher((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModPathNavigation((Mob)this, worldIn);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "slam") {
            return this.smashAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "sit") {
            return this.sitAnimationState;
        }
        if (input == "growth") {
            return this.growthAnimationState;
        }
        return new AnimationState();
    }

    public void setStanding(boolean standing, Player player) {
        if (this.isStanding()) {
            this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_stand_disable", this.getEntityName());
        } else {
            this.sendActionBarMessageToPlayer(player, "legendary_monsters.message.pet_stand_enable", this.getEntityName());
        }
        this.f_19804_.m_135381_(STANDING, (Object)standing);
    }

    public boolean isSitting() {
        return (Boolean)this.f_19804_.m_135370_(SITTING);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_21830_((LivingEntity)pPlayer)) {
            if (!pPlayer.m_6144_() && !this.isStanding()) {
                this.m_21839_(!this.m_21827_());
            } else if (!this.isSitting()) {
                this.setStanding(!this.isStanding(), pPlayer);
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.smashAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.sitAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.growthAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.idleAnimationState.m_216973_();
        this.sitAnimationState.m_216973_();
        this.growthAnimationState.m_216973_();
        this.smashAnimationState.m_216973_();
    }

    private void AreaAttack(float range, float height, float arc, float damage) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            boolean flag;
            TamableAnimal tamableEntity;
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if ((entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && !this.m_7307_((Entity)entityHit) && entityHit != this && !(entityHit instanceof MossyGolemEntity) && (!(entityHit instanceof TamableAnimal) || !(tamableEntity = (TamableAnimal)entityHit).m_21824_() || tamableEntity.m_269323_() != this.m_269323_()) && !(flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)damage * (Double)ModConfig.MOB_CONFIG.MossyGolemDamageMutliplier.get())))) continue;
        }
    }

    public void CircleParticle(int precent, float x, float y, float z) {
        for (int i = 0; i < 360; ++i) {
            if (i % precent != 0) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, Math.cos(i) + (double)x, (double)y, Math.sin(i) + (double)z, 1.0, 1.0, 1.0);
        }
    }

    protected boolean m_8028_() {
        return false;
    }

    public void updateWithAttack() {
        if (this.getAttackState() == 4) {
            if (this.attackTicks == 1) {
                // empty if block
            }
            if (this.attackTicks == 14) {
                if (this.m_9236_().f_46443_) {
                    float radius = 2.0f;
                    this.CircleParticle(20, (float)this.m_20185_(), (float)(this.m_20186_() + (double)0.2f), (float)this.m_20189_());
                }
                this.m_5496_(SoundEvents.f_144074_, 2.0f, 0.75f);
                if (!this.m_9236_().f_46443_) {
                    this.accelerateCropGrowth(4, 5);
                }
            }
        }
        if (this.getAttackState() == 2 && this.attackTicks == 12) {
            this.AreaAttack(4.0f, 2.0f, 180.0f, 7.5f);
            this.SpawnCircleParticle(1.5f, 0.5f, 5.0f, true, 0.25f, 0.9f, 1.0f, 0.9f, 1.0f);
            this.SpawnCircleParticle(1.5f, -0.5f, 5.0f, true, 0.25f, 0.9f, 1.0f, 0.9f, 1.0f);
            this.m_5496_(SoundEvents.f_11892_, 1.0f, 1.0f);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21183_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 14.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22282_, 0.5).m_22268_(Attributes.f_22281_, 16.0);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.OVERGROWN_COLOSSUS_DEATH.get();
    }

    protected boolean canDespawn() {
        this.m_21530_();
        return true;
    }

    @Nullable
    public ItemEntity LGspawnatlocation(ItemStack pStack) {
        pStack.m_41700_("Enchantments", (Tag)new ListTag());
        ItemEntity itemEntity = this.m_5552_(pStack, 0.0f);
        if (itemEntity != null) {
            itemEntity.m_146915_(true);
        }
        return itemEntity;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_21530_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_21839_(compound.m_128471_("standing"));
        this.m_21839_(compound.m_128471_("Sitting"));
        if (this.m_21223_() == this.m_21233_()) {
            this.updateAttributes();
        }
    }

    @Override
    public void updateAttributes() {
        double healthMultiplier = (Double)ModConfig.MOB_CONFIG.MossyGolemHealthMultiplier.get();
        double damageMultiplier = (Double)ModConfig.MOB_CONFIG.MossyGolemDamageMutliplier.get();
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackDamageAttribute = this.m_21051_(Attributes.f_22281_);
        double baseHealth = 60.0;
        double baseAttackDamage = 16.0;
        double newHealth = baseHealth * healthMultiplier;
        double newAttackDamage = baseAttackDamage * damageMultiplier;
        if (healthAttribute != null && healthAttribute.m_22115_() != newHealth) {
            healthAttribute.m_22100_(newHealth);
            this.m_21153_((float)newHealth);
        }
        if (attackDamageAttribute != null && attackDamageAttribute.m_22115_() != newAttackDamage) {
            attackDamageAttribute.m_22100_(newAttackDamage);
        }
    }
}

