/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Mobs.Overgrown_colossusEntity;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.OriginClasses.AmbientEntity;
import net.miauczel.legendary_monsters.entity.ModEntities;
import net.miauczel.legendary_monsters.sound.ModSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class ShockwaveEntity
extends AmbientEntity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 3;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ATTACK = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float activateProgress;
    public float prevactivateProgress;
    private BlockState blockState;
    private boolean ispoisonous;
    public AnimationState emergeAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackCooldown;
    public int attackTicks;

    public ShockwaveEntity(EntityType<? extends ShockwaveEntity> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public ShockwaveEntity(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, boolean poisonous, float setDamage) {
        this((EntityType<? extends ShockwaveEntity>)((EntityType)ModEntities.SHOCKWAVE.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.setDamage(setDamage);
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
            this.m_5496_(SoundEvents.f_12442_, 1.0f, 0.5f);
            this.damage(livingentity);
        }
        int i = 0;
        while ((double)i < 0.5) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            ++i;
        }
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ATTACK, (Object)false);
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
    }

    public void m_8119_() {
        LivingEntity livingentity1 = this.getCaster();
        this.ispoisonous = livingentity1 instanceof Overgrown_colossusEntity;
        BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        BlockState block2 = Blocks.f_256831_.m_49966_();
        if (this.ispoisonous) {
            for (i = 0; i < 20; ++i) {
                x = this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                y = this.m_20186_() + 0.5;
                z = this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                motx = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                moty = 0.5f + this.f_19796_.m_188501_() * 2.0f;
                motz = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), x, y, z, motx, moty, motz);
            }
        } else {
            for (i = 0; i < 20; ++i) {
                x = this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                y = this.m_20186_() + 0.5;
                z = this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                motx = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                moty = 0.5f + this.f_19796_.m_188501_() * 2.0f;
                motz = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), x, y, z, motx, moty, motz);
            }
        }
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
            this.damage(livingentity);
        }
        if (this.lifeTicks == 32 && !this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.ICE_SPIKE_EMERGE.get(), this.m_5720_(), 0.5f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
        }
        super.m_8119_();
        if (this.getAttackState() == 0) {
            this.setAttackState(1);
        }
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        this.prevactivateProgress = this.activateProgress;
        if (this.isActivate() && this.activateProgress > 0.0f) {
            this.activateProgress -= 1.0f;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (!this.isActivate() && this.activateProgress < 10.0f) {
                    this.activateProgress += 1.0f;
                }
                if (this.lifeTicks == 6) {
                    this.setActivate(true);
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -10 && this.isActivate()) {
                this.setActivate(false);
            }
            if (this.warmupDelayTicks < -10 && this.warmupDelayTicks > -30) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
    }

    public boolean isActivate() {
        return (Boolean)this.f_19804_.m_135370_(ATTACK);
    }

    public void setActivate(boolean Activate) {
        this.f_19804_.m_135381_(ATTACK, (Object)Activate);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    private void damage(LivingEntity ImpactEntity) {
        LivingEntity livingentity = this.getCaster();
        if (ImpactEntity.m_6084_() && !ImpactEntity.m_20147_() && ImpactEntity != livingentity && this.caster != null && !this.caster.m_7307_((Entity)ImpactEntity) && this.f_19797_ % 5 == 0) {
            if (livingentity == null) {
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this.caster);
                ImpactEntity.m_6469_(damageSource, this.getDamage());
            } else {
                if (livingentity.m_7307_((Entity)ImpactEntity)) {
                    return;
                }
                DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268566_), (Entity)this.caster);
                ImpactEntity.m_6469_(damageSource, this.getDamage());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                double y = this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_());
                double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_();
                double motx = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                double moty = 0.5f + this.f_19796_.m_188501_() * 2.0f;
                double motz = (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 3.0f;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.blockState), x, y, z, motx, moty, motz);
            }
        }
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AnimationState getAnimationState(String input) {
        if (input == "emerge") {
            return this.emergeAnimationState;
        }
        return new AnimationState();
    }

    public void setSleep(boolean sleep) {
        this.setAttackState(sleep ? 1 : 0);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.setAttackState(1);
        BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        double d0 = this.m_20185_();
        double d1 = this.m_20186_() + 2.0;
        double d2 = this.m_20189_();
        double d3 = this.f_19796_.m_188583_() * 0.07;
        double d4 = this.f_19796_.m_188583_() * 0.07;
        double d5 = this.f_19796_.m_188583_() * 0.07;
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)input);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.emergeAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.emergeAnimationState.m_216973_();
    }

    public float getAnimationProgress(float pPartialTicks) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int $$1 = this.lifeTicks - 2;
        return $$1 <= 0 ? 1.0f : 1.0f - ((float)$$1 - pPartialTicks) / 20.0f;
    }
}

