/*
 * Decompiled with CFR 0.152.
 */
package net.miauczel.legendary_monsters.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.miauczel.legendary_monsters.entity.AnimatedMonster.Projectile.LightningBeamEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class LightningBeamRenderer
extends EntityRenderer<LightningBeamEntity> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final float linearity;

    public LightningBeamRenderer(EntityRendererProvider.Context context, float linearity) {
        super(context);
        this.linearity = linearity;
    }

    public void render(LightningBeamEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        double playerX = mc.f_91074_.m_20185_();
        double playerZ = mc.f_91074_.m_20189_();
        double entityX = entity.m_20185_();
        double entityZ = entity.m_20189_();
        double dirX = playerX - entityX;
        double dirZ = playerZ - entityZ;
        double magnitude = Math.sqrt(dirX * dirX + dirZ * dirZ);
        if (magnitude != 0.0) {
            dirX /= magnitude;
            dirZ /= magnitude;
        }
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        float startX = (float)entity.endPosX;
        float startZ = (float)entity.endPosZ;
        int i = 0;
        while ((double)i < entity.endPosY) {
            float maxDeviation = (1.0f - this.linearity) * 2.0f;
            float endX = startX + RANDOM.m_188501_() * maxDeviation - maxDeviation / 2.0f;
            float endZ = startZ + RANDOM.m_188501_() * maxDeviation - maxDeviation / 2.0f;
            this.render3DSegment(matrixStack.m_85850_().m_252922_(), vertexConsumer, startX, startZ, i, endX, endZ, i + 1, dirX, dirZ, 0.8f, 0.8f, 1.0f);
            startX = endX;
            startZ = endZ;
            ++i;
        }
        matrixStack.m_85849_();
        packedLight = 0xF000F0;
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private void render3DSegment(Matrix4f matrix, VertexConsumer consumer, float startX, float startZ, int startY, float endX, float endZ, int endY, double dirX, double dirZ, float red, float green, float blue) {
        float thickness = 0.1f;
        float perpX = (float)(-dirZ);
        float perpZ = (float)dirX;
        this.renderQuad(matrix, consumer, startX, startZ, startY, endX, endZ, endY, red, green, blue, perpX *= thickness, perpZ *= thickness);
        this.renderQuad(matrix, consumer, startX, startZ, startY, endX, endZ, endY, red, green, blue, -perpX, -perpZ);
    }

    private void renderQuad(Matrix4f matrix, VertexConsumer consumer, float x1, float z1, int y1, float x2, float z2, int y2, float red, float green, float blue, float perpX, float perpZ) {
        consumer.m_252986_(matrix, x1 - perpX, (float)y1 * 1.0f, z1 - perpZ).m_85950_(red, green, blue, 0.5f).m_7421_(0.0f, 0.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2 - perpX, (float)y2 * 1.0f, z2 - perpZ).m_85950_(red, green, blue, 0.5f).m_7421_(1.0f, 0.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x2 + perpX, (float)y2 * 1.0f, z2 + perpZ).m_85950_(red, green, blue, 0.5f).m_7421_(1.0f, 1.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, x1 + perpX, (float)y1 * 1.0f, z1 + perpZ).m_85950_(red, green, blue, 0.5f).m_7421_(0.0f, 1.0f).m_7122_(0, 10).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(LightningBeamEntity entity) {
        return new ResourceLocation("legendary_monsters", "textures/entity/cloud_golem/model.png");
    }
}

