/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.forge.mixin.impl;

import glitchcore.network.CustomPacket;
import glitchcore.network.PacketHandler;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.jodah.typetools.TypeResolver;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketHandler.class}, remap=false)
public abstract class MixinPacketHandler {
    @Shadow
    @Final
    private ResourceLocation channelName;
    @Unique
    private SimpleChannel channel;
    @Unique
    private AtomicInteger messageId = new AtomicInteger();

    @Overwrite
    public <T extends CustomPacket<T>> void register(ResourceLocation name, CustomPacket<T> packet) {
        Class dataType = TypeResolver.resolveRawArgument(CustomPacket.class, packet.getClass());
        if (dataType == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve packet data type: " + packet);
        }
        this.channel.messageBuilder(dataType, this.messageId.incrementAndGet()).encoder(CustomPacket::encode).decoder(packet::decode).consumerMainThread((data, forgeContext) -> {
            ((NetworkEvent.Context)forgeContext.get()).enqueueWork(() -> this.lambda$register$0(packet, data, (Supplier)forgeContext));
            ((NetworkEvent.Context)forgeContext.get()).setPacketHandled(true);
        }).add();
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToPlayer(T data, ServerPlayer player) {
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), data);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToAll(T packet, MinecraftServer server) {
        this.channel.send(PacketDistributor.ALL.noArg(), packet);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToServer(T data) {
        this.channel.send(PacketDistributor.SERVER.noArg(), data);
    }

    @Overwrite
    private void init() {
        String protocolVersion = Integer.toString(1);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.channelName).clientAcceptedVersions(protocolVersion::equals).serverAcceptedVersions(protocolVersion::equals).networkProtocolVersion(() -> protocolVersion).simpleChannel();
    }

    private /* synthetic */ void lambda$register$0(CustomPacket packet, CustomPacket data, final Supplier forgeContext) {
        packet.handle(data, new CustomPacket.Context(){

            @Override
            public boolean isClientSide() {
                return ((NetworkEvent.Context)forgeContext.get()).getNetworkManager().m_178313_() == PacketFlow.CLIENTBOUND;
            }

            @Override
            public Optional<Player> getPlayer() {
                return Optional.ofNullable(((NetworkEvent.Context)forgeContext.get()).getSender()).or(() -> this.isClientSide() ? Optional.ofNullable(Minecraft.m_91087_().f_91074_) : Optional.empty());
            }
        });
    }
}

