/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.CompactItemSet;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CauldronRecipeUtils {
    @Nullable
    public static FluidAndItemsCraftResult craftMultiple(Level level, boolean boiling, int tankCapacity, SoftFluidStack currentFluid, List<ItemStack> inputItems) {
        FluidAndItemCraftResult currentResult;
        boolean success = false;
        CompactItemSet craftedItems = new CompactItemSet();
        do {
            if ((currentResult = CauldronRecipeUtils.craft(level, boiling, tankCapacity, currentFluid, inputItems)) == null) continue;
            success = true;
            currentFluid = currentResult.resultFluid();
            craftedItems.add(currentResult.craftedItem());
        } while (currentResult != null);
        if (!success) {
            return null;
        }
        return FluidAndItemsCraftResult.of(craftedItems.toList(), currentFluid);
    }

    @Nullable
    public static FluidAndItemCraftResult craft(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluidStack, List<ItemStack> items) {
        if (fluidStack.isEmpty()) {
            return null;
        }
        FluidAndItemCraftResult crafted = CauldronRecipeUtils.craftFluidSpecial(level, boiling, tankCapacity, fluidStack, items);
        if (crafted != null) {
            return crafted;
        }
        if (boiling || !fluidStack.is((Holder)BuiltInSoftFluids.WATER)) {
            crafted = CauldronRecipeUtils.craftItemSingle(level, true, tankCapacity, fluidStack, items);
            if (crafted != null) {
                return crafted;
            }
            if (items.size() == 1) {
                crafted = CauldronRecipeUtils.craftItemSurround(level, true, tankCapacity, fluidStack, items.get(0));
                return crafted;
            }
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSingle(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluid, Collection<ItemStack> item) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result = container.craftWithCraftingRecipes(level);
        if (result != null) {
            for (ItemStack i : item) {
                if (i.m_41619_()) continue;
                i.m_41774_(1);
            }
            return result;
        }
        return null;
    }

    @Nullable
    private static FluidAndItemCraftResult craftItemSurround(Level level, boolean boiling, int tankCapacity, SoftFluidStack fluid, ItemStack item) {
        if (item.m_41613_() < 8) {
            return null;
        }
        CauldronCraftingContainer container = CauldronCraftingContainer.surround8(boiling, tankCapacity, fluid, item);
        FluidAndItemCraftResult result8x = container.craftWithCraftingRecipes(level);
        if (result8x != null) {
            item.m_41774_(8);
            return result8x;
        }
        return null;
    }

    @Nullable
    public static FluidAndItemCraftResult craftFluidSpecial(Level level, boolean boiling, int tankCapacity, SoftFluidStack softFluidStack, Collection<ItemStack> items) {
        CauldronCraftingContainer container = CauldronCraftingContainer.of(boiling, tankCapacity, softFluidStack, items);
        FluidAndItemCraftResult crafted = container.craftWithCauldronRecipes(level);
        if (crafted != null) {
            for (ItemStack i : items) {
                if (i.m_41619_()) continue;
                i.m_41774_(1);
            }
            return crafted;
        }
        return null;
    }
}

