/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.registry;

import com.obscuria.aquamirae.common.entities.Anglerfish;
import com.obscuria.aquamirae.common.entities.CaptainCornelia;
import com.obscuria.aquamirae.common.entities.Eel;
import com.obscuria.aquamirae.common.entities.GoldenMoth;
import com.obscuria.aquamirae.common.entities.LuminousJelly;
import com.obscuria.aquamirae.common.entities.Maw;
import com.obscuria.aquamirae.common.entities.MazeMother;
import com.obscuria.aquamirae.common.entities.PillagersPatrol;
import com.obscuria.aquamirae.common.entities.Spinefish;
import com.obscuria.aquamirae.common.entities.TorturedSoul;
import com.obscuria.aquamirae.common.entities.projectiles.MazeRose;
import com.obscuria.aquamirae.common.entities.projectiles.PoisonedChakra;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AquamiraeEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"aquamirae");
    public static final RegistryObject<EntityType<GoldenMoth>> GOLDEN_MOTH = AquamiraeEntities.register("golden_moth", EntityType.Builder.m_20704_(GoldenMoth::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(GoldenMoth::new).m_20719_().m_20699_(0.5f, 0.2f));
    public static final RegistryObject<EntityType<Maw>> MAW = AquamiraeEntities.register("maw", EntityType.Builder.m_20704_(Maw::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Maw::new).m_20699_(1.2f, 1.2f));
    public static final RegistryObject<EntityType<Anglerfish>> ANGLERFISH = AquamiraeEntities.register("anglerfish", EntityType.Builder.m_20704_(Anglerfish::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Anglerfish::new).m_20699_(2.0f, 2.6f));
    public static final RegistryObject<EntityType<MazeMother>> MAZE_MOTHER = AquamiraeEntities.register("maze_mother", EntityType.Builder.m_20704_(MazeMother::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(MazeMother::new).m_20699_(8.0f, 3.0f));
    public static final RegistryObject<EntityType<CaptainCornelia>> CAPTAIN_CORNELIA = AquamiraeEntities.register("captain_cornelia", EntityType.Builder.m_20704_(CaptainCornelia::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CaptainCornelia::new).m_20719_().m_20699_(0.6f, 2.3f));
    public static final RegistryObject<EntityType<PillagersPatrol>> PILLAGERS_PATROL = AquamiraeEntities.register("pillagers_patrol", EntityType.Builder.m_20704_(PillagersPatrol::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(false).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(PillagersPatrol::new).m_20719_().m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<TorturedSoul>> TORTURED_SOUL = AquamiraeEntities.register("tortured_soul", EntityType.Builder.m_20704_(TorturedSoul::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TorturedSoul::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<Eel>> EEL = AquamiraeEntities.register("eel", EntityType.Builder.m_20704_(Eel::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Eel::new).m_20699_(2.4f, 3.4f));
    public static final RegistryObject<EntityType<MazeRose>> MAZE_ROSE = AquamiraeEntities.register("maze_rose", EntityType.Builder.m_20704_(MazeRose::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(MazeRose::new).m_20699_(1.3f, 0.15f));
    public static final RegistryObject<EntityType<PoisonedChakra>> POISONED_CHAKRA = AquamiraeEntities.register("poisoned_chakra", EntityType.Builder.m_20704_(PoisonedChakra::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(PoisonedChakra::new).m_20699_(1.3f, 0.15f));
    public static final RegistryObject<EntityType<Spinefish>> SPINEFISH = AquamiraeEntities.register("spinefish", EntityType.Builder.m_20704_(Spinefish::new, (MobCategory)MobCategory.WATER_AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(Spinefish::new).m_20699_(0.7f, 0.7f));
    public static final RegistryObject<EntityType<LuminousJelly>> LUMINOUS_JELLY = AquamiraeEntities.register("luminous_jelly", EntityType.Builder.m_20704_(LuminousJelly::new, (MobCategory)MobCategory.WATER_AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(LuminousJelly::new).m_20699_(0.5f, 0.9f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GOLDEN_MOTH.get(), GoldenMoth.createAttributes().m_22265_());
        event.put((EntityType)MAW.get(), Maw.createAttributes().m_22265_());
        event.put((EntityType)ANGLERFISH.get(), Anglerfish.createAttributes().m_22265_());
        event.put((EntityType)MAZE_MOTHER.get(), MazeMother.createAttributes().m_22265_());
        event.put((EntityType)CAPTAIN_CORNELIA.get(), CaptainCornelia.createAttributes().m_22265_());
        event.put((EntityType)PILLAGERS_PATROL.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)TORTURED_SOUL.get(), TorturedSoul.createAttributes().m_22265_());
        event.put((EntityType)EEL.get(), Eel.createAttributes().m_22265_());
        event.put((EntityType)SPINEFISH.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)LUMINOUS_JELLY.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)POISONED_CHAKRA.get(), LivingEntity.m_21183_().m_22265_());
        event.put((EntityType)MAZE_ROSE.get(), LivingEntity.m_21183_().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawns(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)GOLDEN_MOTH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GoldenMoth.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SPINEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Spinefish.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ANGLERFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Anglerfish.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)MAW.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Maw.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)TORTURED_SOUL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TorturedSoul.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)PILLAGERS_PATROL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PillagersPatrol.getSpawnRules(), SpawnPlacementRegisterEvent.Operation.REPLACE);
    }
}

