/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.client.SolarPanelModelData;

public class SolarPanelBakedModel
implements IDynamicBakedModel {
    public static final FaceBakery COOKER = new FaceBakery();
    public final SolarPanelBlock block;
    public final ResourceLocation registryName;
    static final ResourceLocation modelName = new ModelResourceLocation("solarflux", "solar_panel", "");
    final Function<ResourceLocation, TextureAtlasSprite> spriteGetter = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
    ResourceLocation baseTx;
    ResourceLocation topTx;

    public SolarPanelBakedModel(SolarPanelBlock spb) {
        this.block = spb;
        this.registryName = ForgeRegistries.BLOCKS.getKey((Object)spb);
    }

    public static BakedQuad quad(Vector3f from, Vector3f to, float[] uv, int uvRot, TextureAtlasSprite sprite, Direction facing) {
        return COOKER.m_111600_(from, to, new BlockElementFace(null, 0, "#0", new BlockFaceUV(uv, uvRot)), sprite, facing, (ModelState)BlockModelRotation.X0_Y0, null, true, modelName);
    }

    public static void createSolarPanelQuads(List<BakedQuad> quads, Direction side, float h, TextureAtlasSprite top, TextureAtlasSprite base, SolarPanelModelData data) {
        boolean west = !data.west();
        boolean east = !data.east();
        boolean north = !data.north();
        boolean south = !data.south();
        quads.add(SolarPanelBakedModel.quad(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, h, 16.0f), new float[]{0.0f, side.m_122434_() == Direction.Axis.Y ? 0.0f : 16.0f - h, 16.0f, 16.0f}, 4, side == Direction.UP ? top : base, side));
        if (west) {
            float[] fArray;
            Vector3f vector3f = new Vector3f(0.0f, h, 1.0f);
            Vector3f vector3f2 = new Vector3f(1.0f, h + 0.25f, 15.0f);
            if (side != Direction.UP) {
                float[] fArray2 = new float[4];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
                fArray2[2] = 16.0f;
                fArray = fArray2;
                fArray2[3] = 1.0f;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.0f;
                fArray3[1] = 0.0f;
                fArray3[2] = 1.0f;
                fArray = fArray3;
                fArray3[3] = 16.0f;
            }
            quads.add(SolarPanelBakedModel.quad(vector3f, vector3f2, fArray, 4, base, side));
        }
        if (east) {
            float[] fArray;
            Vector3f vector3f = new Vector3f(15.0f, h, 1.0f);
            Vector3f vector3f3 = new Vector3f(16.0f, h + 0.25f, 15.0f);
            if (side != Direction.UP) {
                float[] fArray4 = new float[4];
                fArray4[0] = 0.0f;
                fArray4[1] = 0.0f;
                fArray4[2] = 16.0f;
                fArray = fArray4;
                fArray4[3] = 1.0f;
            } else {
                float[] fArray5 = new float[4];
                fArray5[0] = 15.0f;
                fArray5[1] = 0.0f;
                fArray5[2] = 16.0f;
                fArray = fArray5;
                fArray5[3] = 16.0f;
            }
            quads.add(SolarPanelBakedModel.quad(vector3f, vector3f3, fArray, 4, base, side));
        }
        if (north) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(1.0f, h, 0.0f), new Vector3f(15.0f, h + 0.25f, 1.0f), new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4, base, side));
        }
        if (south) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(1.0f, h, 15.0f), new Vector3f(15.0f, h + 0.25f, 16.0f), new float[]{0.0f, 0.0f, 16.0f, 1.0f}, 4, base, side));
        }
        if (west || north || !data.westNorth()) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(0.0f, h, 0.0f), new Vector3f(1.0f, h + 0.25f, 1.0f), new float[]{0.0f, 0.0f, 1.0f, 1.0f}, 4, base, side));
        }
        if (east || north || !data.eastNorth()) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(15.0f, h, 0.0f), new Vector3f(16.0f, h + 0.25f, 1.0f), new float[]{15.0f, 0.0f, 16.0f, 1.0f}, 4, base, side));
        }
        if (south || east || !data.eastSouth()) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(15.0f, h, 15.0f), new Vector3f(16.0f, h + 0.25f, 16.0f), new float[]{15.0f, 15.0f, 16.0f, 16.0f}, 4, base, side));
        }
        if (west || south || !data.westSouth()) {
            quads.add(SolarPanelBakedModel.quad(new Vector3f(0.0f, h, 15.0f), new Vector3f(1.0f, h + 0.25f, 16.0f), new float[]{0.0f, 15.0f, 1.0f, 16.0f}, 4, base, side));
        }
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction sideIn, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        Direction[] sides;
        Direction[] directionArray;
        SolarPanelModelData data = SolarPanelModelData.findOrItem(extraData);
        TextureAtlasSprite top = this.t_top();
        TextureAtlasSprite base = this.t_base();
        float h = this.block.panel.getPanelData().height * 16.0f;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (sideIn == null) {
            directionArray = Direction.values();
        } else {
            Direction[] directionArray2 = new Direction[1];
            directionArray = directionArray2;
            directionArray2[0] = sideIn;
        }
        for (Direction side : sides = directionArray) {
            if (side == null) continue;
            SolarPanelBakedModel.createSolarPanelQuads(quads, side, h, top, base, data);
        }
        return quads;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        return modelData.derive().with(SolarPanelModelData.PROPERTY, (Object)SolarPanelModelData.gather((BlockGetter)level, pos, state.m_60734_())).build();
    }

    public ItemTransforms m_7442_() {
        return new ItemTransforms(this.getTransform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND), this.getTransform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND), this.getTransform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND), this.getTransform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND), this.getTransform(ItemDisplayContext.HEAD), this.getTransform(ItemDisplayContext.GUI), this.getTransform(ItemDisplayContext.GROUND), this.getTransform(ItemDisplayContext.FIXED));
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransform getTransform(ItemDisplayContext type) {
        switch (type) {
            case GUI: {
                return new ItemTransform(new Vector3f(30.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.625f, 0.625f, 0.625f));
            }
        }
        return ItemTransform.f_111754_;
    }

    public TextureAtlasSprite m_6160_() {
        return ThreadLocalRandom.current().nextInt(5) > 0 ? this.t_base() : this.t_top();
    }

    public TextureAtlasSprite t_base() {
        if (this.baseTx == null) {
            this.baseTx = new ResourceLocation(this.registryName.m_135827_(), "block/" + this.registryName.m_135815_() + "_base");
        }
        return this.spriteGetter.apply(this.baseTx);
    }

    public TextureAtlasSprite t_top() {
        if (this.topTx == null) {
            this.topTx = new ResourceLocation(this.registryName.m_135827_(), "block/" + this.registryName.m_135815_() + "_top");
        }
        return this.spriteGetter.apply(this.topTx);
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }
}

