/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.mobcompack.items;

import com.cartoonishvillain.mobcompack.Tags;
import com.cartoonishvillain.mobcompack.client.renderer.HammerRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hammer
extends DiggerItem
implements GeoItem {
    private static final String CONTROLLER_NAME = "hammerController";
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation CHOMP = RawAnimation.begin().thenPlay("chomp");

    public Hammer(Tier p_42961_, int p_42962_, float p_42963_, Item.Properties p_42964_) {
        super(p_42963_, (float)p_42962_, p_42961_, Tags.MINEABLE_WITH_JAWHAMMER, p_42964_);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        if (!player.m_9236_().f_46443_) {
            BlockHitResult lookingAt = (BlockHitResult)player.m_19907_(16.0, 1.0f, false);
            if (itemstack.m_41735_(player.m_9236_().m_8055_(pos)) && lookingAt.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                Direction pointTowards = lookingAt.m_82434_();
                this.threeByThree(itemstack, pos, player, pointTowards);
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    public void threeByThree(ItemStack itemStack, BlockPos initialPos, Player player, Direction pointTowards) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        switch (pointTowards) {
            case UP: 
            case DOWN: {
                for (int x = initialPos.m_123341_() - 1; x <= initialPos.m_123341_() + 1; ++x) {
                    for (int z = initialPos.m_123343_() - 1; z <= initialPos.m_123343_() + 1; ++z) {
                        BlockPos pos;
                        BlockState state;
                        if (itemStack.m_41776_() <= itemStack.m_41773_() || (state = level.m_8055_(pos = new BlockPos(x, initialPos.m_123342_(), z))).equals(Blocks.f_50016_.m_49966_()) || !itemStack.m_41735_(state)) continue;
                        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81463_, (Object)itemStack).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos));
                        state.m_287290_(builder).forEach(value -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)value));
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        itemStack.m_41622_(1, (LivingEntity)player, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int y = initialPos.m_123342_() - 1; y <= initialPos.m_123342_() + 1; ++y) {
                    for (int z = initialPos.m_123343_() - 1; z <= initialPos.m_123343_() + 1; ++z) {
                        BlockPos pos;
                        BlockState state;
                        if (itemStack.m_41776_() <= itemStack.m_41773_() || (state = level.m_8055_(pos = new BlockPos(initialPos.m_123341_(), y, z))).equals(Blocks.f_50016_.m_49966_()) || !itemStack.m_41735_(state)) continue;
                        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81463_, (Object)itemStack).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos));
                        state.m_287290_(builder).forEach(value -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)value));
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        itemStack.m_41622_(1, (LivingEntity)player, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int x = initialPos.m_123341_() - 1; x <= initialPos.m_123341_() + 1; ++x) {
                    for (int y = initialPos.m_123342_() - 1; y <= initialPos.m_123342_() + 1; ++y) {
                        BlockPos pos;
                        BlockState state;
                        if (itemStack.m_41776_() <= itemStack.m_41773_() || (state = level.m_8055_(pos = new BlockPos(x, y, initialPos.m_123343_()))).equals(Blocks.f_50016_.m_49966_()) || !itemStack.m_41735_(state)) continue;
                        LootParams.Builder builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81463_, (Object)itemStack).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos));
                        state.m_287290_(builder).forEach(value -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)value));
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        itemStack.m_41622_(1, (LivingEntity)player, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
                    }
                }
                break;
            }
        }
    }

    private PlayState predicate(AnimationState<Hammer> event) {
        if (!event.isMoving() && Minecraft.m_91405_()) {
            return event.setAndContinue(CHOMP);
        }
        return PlayState.STOP;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new HammerRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, CONTROLLER_NAME, 20, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

