/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.channel;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.Channel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.S2CMessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class S2CChannel<MSG>
extends Channel<MSG> {
    public S2CChannel(ResourceLocation id, MessageType<MSG> messageType) {
        super(id, messageType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void register() {
        ClientNetworking.registerS2CReceiver(this.id, buf -> {
            Object message = this.messageType.decode(buf);
            S2CMessageContext context = new S2CMessageContext(this);
            this.messageType.onReceive(message, context);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void unregister() {
        ClientNetworking.unregisterS2CReceiver(this.id);
    }

    public void sendTo(ServerPlayer player, MSG message) {
        ServerGamePacketListenerImpl handler = player.f_8906_;
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot send message to the " + this.id + " channel while player " + player.m_7755_() + " is not in-game");
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.messageType.encode(message, buf);
        handler.m_9829_(ServerNetworking.createS2CPacket(this.id, buf));
    }
}

