/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.network;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.bargain.BargainCatalog;

public final class NetUtils {
    private NetUtils() {
    }

    @Nullable
    public static Vec3 readLookAt(@NotNull FriendlyByteBuf buffer) {
        return buffer.readBoolean() ? new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()) : null;
    }

    public static void writeLookAt(@NotNull FriendlyByteBuf buffer, @Nullable Vec3 lookAt) {
        buffer.writeBoolean(lookAt != null);
        if (lookAt != null) {
            buffer.writeDouble(lookAt.f_82479_);
            buffer.writeDouble(lookAt.f_82480_);
            buffer.writeDouble(lookAt.f_82481_);
        }
    }

    @NotNull
    public static Map<ResourceLocation, BargainCatalog> readCatalogs(@NotNull FriendlyByteBuf buffer) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            BargainCatalog c = BargainCatalog.read(buffer);
            map.put(c.bargain(), c);
        }
        return map;
    }

    public static void writeCatalogs(@NotNull FriendlyByteBuf buffer, @NotNull Map<ResourceLocation, BargainCatalog> previews) {
        buffer.m_130130_(previews.size());
        for (BargainCatalog e : previews.values()) {
            e.write(buffer);
        }
    }
}

