/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.vorbis;

import com.sedmelluq.discord.lavaplayer.natives.vorbis.VorbisDecoderLibrary;
import dev.felnull.imp.include.com.sedmelluq.lava.common.natives.NativeResourceHolder;
import java.nio.ByteBuffer;

public class VorbisDecoder
extends NativeResourceHolder {
    private final VorbisDecoderLibrary library = VorbisDecoderLibrary.getInstance();
    private final long instance = this.library.create();
    private int channelCount = 0;

    public void initialise(ByteBuffer infoBuffer, ByteBuffer setupBuffer) {
        this.checkNotReleased();
        if (!infoBuffer.isDirect() || !setupBuffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        if (!this.library.initialise(this.instance, infoBuffer, infoBuffer.position(), infoBuffer.remaining(), setupBuffer, setupBuffer.position(), setupBuffer.remaining())) {
            throw new IllegalStateException("Could not initialise library.");
        }
        this.channelCount = this.library.getChannelCount(this.instance);
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void input(ByteBuffer buffer) {
        this.checkNotReleased();
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Buffer argument must be a direct buffer.");
        }
        int result = this.library.input(this.instance, buffer, buffer.position(), buffer.remaining());
        buffer.position(buffer.position() + buffer.remaining());
        if (result != 0) {
            throw new IllegalStateException("Passing input failed with error " + result + ".");
        }
    }

    public int output(float[][] channels) {
        this.checkNotReleased();
        if (channels.length != this.channelCount) {
            throw new IllegalStateException("Invalid channel float buffer length");
        }
        int result = this.library.output(this.instance, channels, channels[0].length);
        if (result < 0) {
            throw new IllegalStateException("Retrieving output failed");
        }
        return result;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }
}

