/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.PlayersFixedListWidget;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.SmartRadioButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.otyacraftengine.client.gui.components.FixedListWidget;
import dev.felnull.otyacraftengine.client.gui.components.RadioButton;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.util.FlagThread;
import dev.felnull.otyacraftengine.util.OEPlayerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SavedPlayListBaseMMMonitor
extends PlayListBaseMMMonitor {
    private static final ResourceLocation CREATE_PLAYLIST_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/container/music_manager/monitor/create_play_list.png");
    private static final Component INVITE_TEXT = Component.m_237115_((String)"imp.text.invite");
    private static final Component INVITE_PLAYER_BY_MCID_OR_UUID_TEXT = Component.m_237115_((String)"imp.text.invitePlayerByMCIDOrUUID");
    private static final Component UNINVITED_TEXT = Component.m_237115_((String)"imp.text.uninvited");
    private static final Component INVITED_TEXT = Component.m_237115_((String)"imp.text.invited");
    private final List<UUID> onlinePlayers = new ArrayList<UUID>();
    private final List<UUID> invitePlayers = new ArrayList<UUID>();
    private EditBox invitePlayerByNameEditBox;
    private SmartButton addInvitePlayerButton;
    private SmartRadioButton publicRadio;
    private SmartRadioButton privateRadio;
    private SmartRadioButton initAuthReadOnlyRadio;
    private SmartRadioButton initAuthMemberRadio;
    private PlayerUUIDLoadThread playerUUIDLoadThread;
    private PlayersFixedListWidget onlinePlayersFixedButtonsList;
    private PlayersFixedListWidget invitePlayersFixedButtonsList;

    public SavedPlayListBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        Supplier<Set<RadioButton>> pRdos = () -> ImmutableSet.of((Object)this.publicRadio, (Object)this.privateRadio);
        this.publicRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 5, this.getStartY() + 140, PUBLIC_RDO_TEXT, n -> this.setPublishingType(PlayListBaseMMMonitor.PublishingType.PUBLIC), pRdos));
        this.publicRadio.setSelected(this.getPublishingType() == PlayListBaseMMMonitor.PublishingType.PUBLIC);
        this.privateRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 95, this.getStartY() + 140, PRIVATE_RDO_TEXT, n -> this.setPublishingType(PlayListBaseMMMonitor.PublishingType.PRIVATE), pRdos));
        this.privateRadio.setSelected(this.getPublishingType() == PlayListBaseMMMonitor.PublishingType.PRIVATE);
        Supplier<Set<RadioButton>> iRdos = () -> ImmutableSet.of((Object)this.initAuthReadOnlyRadio, (Object)this.initAuthMemberRadio);
        this.initAuthReadOnlyRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 189, this.getStartY() + 140, READONLY_RDO_TEXT, n -> this.setInitialAuthority(PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY), iRdos));
        this.initAuthReadOnlyRadio.setSelected(this.getInitialAuthorityType() == PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY);
        this.initAuthMemberRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 279, this.getStartY() + 140, MEMBER_RDO_TEXT, n -> this.setInitialAuthority(PlayListBaseMMMonitor.InitialAuthorityType.MEMBER), iRdos));
        this.initAuthMemberRadio.setSelected(this.getInitialAuthorityType() == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER);
        this.invitePlayerByNameEditBox = new EditBox(IIMPSmartRender.mc.f_91062_, this.getStartX() + 189, this.getStartY() + 112, 141, 12, (Component)Component.m_237115_((String)"imp.editBox.invitePlayerByName"));
        this.invitePlayerByNameEditBox.m_94199_(300);
        this.invitePlayerByNameEditBox.m_94144_(this.getInvitePlayerName());
        this.invitePlayerByNameEditBox.m_94151_(this::setInvitePlayerName);
        this.addRenderWidget(this.invitePlayerByNameEditBox);
        this.addInvitePlayerButton = this.addRenderWidget(new SmartButton(this.getStartX() + 333, this.getStartY() + 111, 33, 14, (Component)Component.m_237115_((String)"imp.button.addInvitePlayer"), n -> {
            this.startPlayerUUIDLoad(this.invitePlayerByNameEditBox.m_94155_());
            this.invitePlayerByNameEditBox.m_94144_("");
        }));
        this.addInvitePlayerButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 106, 19, 11, 11);
        this.addInvitePlayerButton.setHideText(true);
        this.onlinePlayersFixedButtonsList = this.addRenderWidget(new PlayersFixedListWidget(this.getStartX() + 189, this.getStartY() + 23, 87, 65, (Component)Component.m_237115_((String)"imp.fixedList.onlinePlayers"), 5, this.onlinePlayers, (FixedListWidget.PressEntry<UUID>)((FixedListWidget.PressEntry)(widget, item) -> this.addInvitePlayer((UUID)item)), this.onlinePlayersFixedButtonsList));
        this.invitePlayersFixedButtonsList = this.addRenderWidget(new PlayersFixedListWidget(this.getStartX() + 278, this.getStartY() + 23, 87, 65, (Component)Component.m_237115_((String)"imp.fixedList.invitePlayers"), 5, this.invitePlayers, (FixedListWidget.PressEntry<UUID>)((FixedListWidget.PressEntry)(widget, item) -> this.removeInvitePlayer((UUID)item)), this.invitePlayersFixedButtonsList));
    }

    @Override
    public boolean canDone(MusicManagerBlockEntity blockEntity) {
        return super.canDone(blockEntity) && this.getPublishingType(blockEntity) != null && this.getInitialAuthorityType(blockEntity) != null;
    }

    @Override
    public List<Component> getNotEntered(List<Component> names, MusicManagerBlockEntity blockEntity) {
        if (this.getPublishingType(blockEntity) == null) {
            names.add(PUBLIC_ST_TEXT);
        }
        if (this.getInitialAuthorityType(blockEntity) == null) {
            names.add(INITIAL_AUTHORITY_TEXT);
        }
        return super.getNotEntered(names, blockEntity);
    }

    @Override
    public void render(GuiGraphics guiGraphics, float f, int mouseX, int mouseY) {
        super.render(guiGraphics, f, mouseX, mouseY);
        OERenderUtils.drawTexture((ResourceLocation)CREATE_PLAYLIST_TEXTURE, (PoseStack)guiGraphics.m_280168_(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        this.drawSmartText(guiGraphics, INVITE_PLAYER_BY_MCID_OR_UUID_TEXT, this.getStartX() + 189, this.getStartY() + 102);
        this.drawSmartCenterText(guiGraphics, UNINVITED_TEXT, this.getStartX() + 230, this.getStartY() + 90);
        this.drawSmartCenterText(guiGraphics, INVITED_TEXT, this.getStartX() + 312, this.getStartY() + 90);
    }

    @Override
    protected Component getPlayerListName() {
        return INVITE_TEXT;
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 5.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, PUBLIC_RDO_TEXT, this.getPublishingType(blockEntity) == PlayListBaseMMMonitor.PublishingType.PUBLIC);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 95.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, PRIVATE_RDO_TEXT, this.getPublishingType(blockEntity) == PlayListBaseMMMonitor.PublishingType.PRIVATE);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 189.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, READONLY_RDO_TEXT, this.getInitialAuthorityType(blockEntity) == PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 279.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, MEMBER_RDO_TEXT, this.getInitialAuthorityType(blockEntity) == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER);
        OERenderUtils.renderTextureSprite((ResourceLocation)CREATE_PLAYLIST_TEXTURE, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, UNINVITED_TEXT, 230.0f, 91.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, INVITED_TEXT, 312.0f, 91.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, INVITE_PLAYER_BY_MCID_OR_UUID_TEXT, 189.0f, 102.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 189.0f, 112.0f, 0.004f, 141.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getInvitePlayerName(blockEntity));
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 333.0f, 111.0f, 0.004f, 33.0f, 14.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 106, 19, 11, 11, 256, 256);
        ArrayList opl = new ArrayList(IIMPSmartRender.mc.f_91074_.f_108617_.m_105143_());
        opl.remove(IIMPSmartRender.mc.f_91074_.m_36316_().getId());
        opl.removeAll(this.getInvitePlayers(blockEntity));
        Collection<UUID> ep = this.excludeInvitePlayers(blockEntity);
        if (ep != null) {
            opl.removeAll(this.excludeInvitePlayers(blockEntity));
        }
        for (int k = 0; k < Math.min(5, opl.size()); ++k) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 189.0f, 23 + k * 13, 0.004f, 77.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
            poseStack.m_85836_();
            poseStack.m_252880_(190.0f * onPxW, monitorHeight - (float)(23 + k * 13 + 1 + 11) * onPxH, 0.006f);
            OERenderUtils.renderPlayerFaceSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (UUID)((UUID)opl.get(k)), (float)(onPxH * 11.0f), (int)i, (int)j);
            poseStack.m_85849_();
            String name = OEClientUtils.getPlayerNameByUUID((UUID)((UUID)opl.get(k))).orElse(((UUID)opl.get(k)).toString());
            MutableComponent tx = Component.m_237113_((String)name);
            float sc = Math.min(1.0f, 59.0f / (float)IIMPSmartRender.mc.f_91062_.m_92852_((FormattedText)tx));
            this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)tx, 204.0f, (float)(23 + k * 13) + 3.5f, 0.006f, onPxW, onPxH, monitorHeight, sc, i);
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 267.0f, 23.0f, 0.004f, 65.0f, i, j, onPxW, onPxH, monitorHeight, opl.size(), 5);
        List<UUID> ipl = this.getInvitePlayers(blockEntity);
        for (int k = 0; k < Math.min(5, ipl.size()); ++k) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 278.0f, 23 + k * 13, 0.004f, 77.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
            poseStack.m_85836_();
            poseStack.m_252880_(279.0f * onPxW, monitorHeight - (float)(23 + k * 13 + 1 + 11) * onPxH, 0.006f);
            OERenderUtils.renderPlayerFaceSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (UUID)ipl.get(k), (float)(onPxH * 11.0f), (int)i, (int)j);
            poseStack.m_85849_();
            String name = OEClientUtils.getPlayerNameByUUID((UUID)ipl.get(k)).orElse(ipl.get(k).toString());
            MutableComponent tx = Component.m_237113_((String)name);
            float sc = Math.min(1.0f, 59.0f / (float)IIMPSmartRender.mc.f_91062_.m_92852_((FormattedText)tx));
            this.renderSmartTextSprite(poseStack, multiBufferSource, (Component)tx, 293.0f, (float)(23 + k * 13) + 3.5f, 0.006f, onPxW, onPxH, monitorHeight, sc, i);
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 355.0f, 23.0f, 0.004f, 65.0f, i, j, onPxW, onPxH, monitorHeight, ipl.size(), 5);
    }

    @Override
    public void depose() {
        super.depose();
        this.stopPlayerUUIDLoad();
    }

    @Override
    public void tick() {
        super.tick();
        this.updateOnlinePlayers();
        this.updateInvitePlayers();
    }

    private void updateOnlinePlayers() {
        this.onlinePlayers.clear();
        this.onlinePlayers.addAll(IIMPSmartRender.mc.f_91074_.f_108617_.m_105143_());
        this.onlinePlayers.remove(IIMPSmartRender.mc.f_91074_.m_36316_().getId());
        this.onlinePlayers.removeAll(this.getInvitePlayers());
        Collection<UUID> ex = this.excludeInvitePlayers();
        if (ex != null) {
            this.onlinePlayers.removeAll(ex);
        }
    }

    private void updateInvitePlayers() {
        this.invitePlayers.clear();
        this.invitePlayers.addAll(this.getInvitePlayers());
    }

    protected Collection<UUID> excludeInvitePlayers(MusicManagerBlockEntity musicManagerBlockEntity) {
        return null;
    }

    protected Collection<UUID> excludeInvitePlayers() {
        BlockEntity blockEntity = this.getScreen().getBlockEntity();
        if (blockEntity instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)blockEntity;
            return this.excludeInvitePlayers(musicManagerBlock);
        }
        return null;
    }

    protected void setPublishingType(@Nullable PlayListBaseMMMonitor.PublishingType publishingType) {
        this.getScreen().insPublishing(publishingType == null ? "" : publishingType.getName());
    }

    protected void setInvitePlayerName(@NotNull String name) {
        this.getScreen().insInvitePlayerName(name);
    }

    protected void setInitialAuthority(@Nullable PlayListBaseMMMonitor.InitialAuthorityType initialAuthorityType) {
        this.getScreen().insInitialAuthority(initialAuthorityType == null ? "" : initialAuthorityType.getName());
    }

    protected void removeInvitePlayer(@NotNull UUID uuid) {
        ArrayList<UUID> pls = new ArrayList<UUID>(this.getInvitePlayers());
        pls.remove(uuid);
        this.setInvitePlayers(pls);
    }

    protected void addInvitePlayer(@NotNull UUID uuid) {
        if (IIMPSmartRender.mc.f_91074_.m_36316_().equals((Object)uuid)) {
            return;
        }
        ArrayList<UUID> pls = new ArrayList<UUID>(this.getInvitePlayers());
        if (pls.contains(uuid)) {
            return;
        }
        pls.add(uuid);
        this.setInvitePlayers(pls);
    }

    protected void setInvitePlayers(List<UUID> players) {
        this.getScreen().insInvitePlayers(players);
    }

    private void startPlayerUUIDLoad(String text) {
        this.stopPlayerUUIDLoad();
        this.playerUUIDLoadThread = new PlayerUUIDLoadThread(text);
        this.playerUUIDLoadThread.start();
    }

    private void stopPlayerUUIDLoad() {
        if (this.playerUUIDLoadThread != null) {
            this.playerUUIDLoadThread.stopped();
            this.playerUUIDLoadThread = null;
        }
    }

    private class PlayerUUIDLoadThread
    extends FlagThread {
        private final String name;

        private PlayerUUIDLoadThread(String name) {
            this.name = name;
        }

        public void run() {
            try {
                if (this.isStopped()) {
                    return;
                }
                SavedPlayListBaseMMMonitor.this.addInvitePlayer(UUID.fromString(this.name));
                if (this.isStopped()) {
                    return;
                }
                return;
            }
            catch (Exception exception) {
                if (this.isStopped()) {
                    return;
                }
                OEPlayerUtils.getUUIDByName((String)this.name).ifPresent(SavedPlayListBaseMMMonitor.this::addInvitePlayer);
                return;
            }
        }
    }
}

