/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.felnull.imp.include.dev.felnull.fnjl.math.FNVec2d;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNMath;
import dev.felnull.imp.include.dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.client.renderer.texture.TextureScale;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import dev.felnull.otyacraftengine.client.util.OETextureUtils;
import java.net.URL;
import java.util.regex.Pattern;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.tuple.Pair;

public class PlayImageRenderer {
    private static final ResourceLocation MISSING_YOUTUBE_THUMBNAIL_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/image/missing_youtube_thumbnail.png");
    private static final ResourceLocation MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE = new ResourceLocation("iammusicplayer", "textures/gui/image/missing_sound_cloud_artwork.png");
    private static final PlayImageRenderer INSTANCE = new PlayImageRenderer();
    private static final String YOUTUBE_THUMBNAIL_URL = "https://i.ytimg.com/vi/%s/hqdefault.jpg";
    private static final Pattern YOUTUBE_THUMBNAIL_URL_REGEX = Pattern.compile("https://i.ytimg.com/vi/.+/hqdefault.jpg");
    private static final Pattern SOUND_CLOUD_URL_REGEX = Pattern.compile("https://soundcloud.com/.+");
    private static final String SCT_IMG_ST = "<img ";
    private static final String SCT_IMG_END = ">";
    private static final String SCT_SRC_ST = "src=\"";
    private static final String SCT_SRC_END = "\"";

    public static PlayImageRenderer getInstance() {
        return INSTANCE;
    }

    public String getSwapURL(String url) {
        String scurl;
        if (url.startsWith("imp_sct_") && SOUND_CLOUD_URL_REGEX.matcher(scurl = url.substring("imp_sct_".length())).matches()) {
            String ret = null;
            try {
                ret = PlayImageRenderer.extractSoundCloudImage(FNURLUtil.getResponse(new URL(scurl)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
        return null;
    }

    public boolean isAllowURL(String url) {
        if (YOUTUBE_THUMBNAIL_URL_REGEX.matcher(url).matches()) {
            return true;
        }
        if (url.startsWith("imp_sct_")) {
            String scurl = url.substring("imp_sct_".length());
            return SOUND_CLOUD_URL_REGEX.matcher(scurl).matches();
        }
        if (url.startsWith("imp_ncmp_")) {
            String curl = url.substring("imp_ncmp_".length());
            return !curl.isEmpty();
        }
        return false;
    }

    public void draw(ImageInfo imageInfo, PoseStack poseStack, float x, float y, int size) {
        this.draw(imageInfo, poseStack, x, y, size, true);
    }

    public void draw(ImageInfo imageInfo, PoseStack poseStack, float x, float y, float size, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.drawPlayerFaceImage(imageInfo.getIdentifier(), poseStack, x, y, size);
            return;
        }
        Pair<ResourceLocation, Vec2> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.drawTextureImage((ResourceLocation)td.getLeft(), poseStack, ((Vec2)td.getRight()).f_82470_, ((Vec2)td.getRight()).f_82471_, x, y, size);
        }
    }

    public void drawPlayerFaceImage(String name, PoseStack poseStack, float x, float y, float size) {
        ResourceLocation texture = OETextureUtils.getPlayerSkinTexture((String)name);
        OERenderUtils.drawTexture((ResourceLocation)texture, (PoseStack)poseStack, (float)x, (float)y, (float)size, (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
        OERenderUtils.drawTexture((ResourceLocation)texture, (PoseStack)poseStack, (float)x, (float)y, (float)(size * 5.0f), (float)size, (float)size, (float)size, (float)(size * 8.0f), (float)(size * 8.0f));
    }

    private void drawTextureImage(ResourceLocation location, PoseStack poseStack, float wScale, float hScale, float x, float y, float size) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtils.drawTexture((ResourceLocation)location, (PoseStack)poseStack, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h);
    }

    public void renderSprite(ImageInfo imageInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j) {
        this.renderSprite(imageInfo, poseStack, multiBufferSource, x, y, z, size, i, j, true);
    }

    public void renderSprite(ImageInfo imageInfo, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j, boolean cash) {
        if (imageInfo.isEmpty()) {
            return;
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.PLAYER_FACE) {
            this.renderPlayerFaceImageSprite(imageInfo.getIdentifier(), poseStack, multiBufferSource, x, y, z, size, i, j);
            return;
        }
        Pair<ResourceLocation, Vec2> td = this.getImageTexture(imageInfo, cash);
        if (td != null) {
            this.renderTextureImageSprite((ResourceLocation)td.getLeft(), poseStack, multiBufferSource, ((Vec2)td.getRight()).f_82470_, ((Vec2)td.getRight()).f_82471_, x, y, z, size, i, j);
        }
    }

    private void renderPlayerFaceImageSprite(String name, PoseStack poseStack, MultiBufferSource multiBufferSource, float x, float y, float z, float size, int i, int j) {
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, z);
        OERenderUtils.renderPlayerFaceSprite((PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (String)name, (float)size, (int)i, (int)j);
        poseStack.m_85849_();
    }

    private void renderTextureImageSprite(ResourceLocation location, PoseStack poseStack, MultiBufferSource multiBufferSource, float wScale, float hScale, float x, float y, float z, float size, int i, int j) {
        if (location == null) {
            return;
        }
        float w = size * wScale;
        float h = size * hScale;
        OERenderUtils.renderTextureSprite((ResourceLocation)location, (PoseStack)poseStack, (MultiBufferSource)multiBufferSource, (float)(x + (size - w) / 2.0f), (float)(y + (size - h) / 2.0f), (float)z, (float)0.0f, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)0.0f, (float)0.0f, (float)w, (float)h, (float)w, (float)h, (int)i, (int)j);
    }

    private Pair<ResourceLocation, Vec2> getImageTexture(ImageInfo imageInfo, boolean cash) {
        if (imageInfo.getImageType() == ImageInfo.ImageType.URL) {
            ResourceLocation loc = OETextureUtils.getAndLoadURLTextureAsync((String)imageInfo.getIdentifier(), (boolean)cash).of();
            TextureScale scale = OETextureUtils.getTextureScale((ResourceLocation)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new Vec2(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.YOUTUBE_THUMBNAIL) {
            ResourceLocation loc = OETextureUtils.getAndLoadURLTextureAsync((String)String.format(YOUTUBE_THUMBNAIL_URL, imageInfo.getIdentifier()), (boolean)cash).of(MISSING_YOUTUBE_THUMBNAIL_TEXTURE);
            TextureScale scale = OETextureUtils.getTextureScale((ResourceLocation)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (loc == MISSING_YOUTUBE_THUMBNAIL_TEXTURE) {
                FNVec2d st = FNMath.scale(120.0, 90.0);
                w = (float)st.getX();
                h = (float)st.getY();
            } else if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new Vec2(w, h));
        }
        if (imageInfo.getImageType() == ImageInfo.ImageType.SOUND_CLOUD_ARTWORK) {
            String idf = imageInfo.getIdentifier();
            ResourceLocation loc = OETextureUtils.getAndLoadURLTextureAsync((String)("imp_sct_" + idf), (boolean)cash).of(MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE);
            TextureScale scale = OETextureUtils.getTextureScale((ResourceLocation)loc);
            float w = 1.0f;
            float h = 1.0f;
            if (loc == MISSING_SOUND_CLOUD_THUMBNAIL_TEXTURE) {
                FNVec2d st = FNMath.scale(1.0, 1.0);
                w = (float)st.getX();
                h = (float)st.getY();
            } else if (scale != null) {
                w = (float)scale.w();
                h = (float)scale.h();
            }
            return Pair.of((Object)loc, (Object)new Vec2(w, h));
        }
        return null;
    }

    private static String extractSoundCloudImage(String html) {
        String ts = html.substring(html.indexOf(SCT_IMG_ST) + SCT_IMG_ST.length());
        ts = ts.substring(0, ts.indexOf(SCT_IMG_END));
        ts = ts.substring(ts.indexOf(SCT_SRC_ST) + SCT_SRC_ST.length());
        ts = ts.substring(0, ts.indexOf(SCT_SRC_END));
        return ts;
    }
}

