/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.org.apache.http.Header;
import dev.felnull.imp.include.org.apache.http.client.config.RequestConfig;
import dev.felnull.imp.include.org.apache.http.client.entity.UrlEncodedFormEntity;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.impl.client.HttpClientBuilder;
import dev.felnull.imp.include.org.apache.http.message.BasicNameValuePair;
import dev.felnull.imp.include.org.jsoup.Jsoup;
import dev.felnull.imp.include.org.jsoup.nodes.Document;
import dev.felnull.imp.include.org.jsoup.nodes.Element;
import dev.felnull.imp.include.org.jsoup.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NicoAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String TRACK_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)nicovideo\\.jp/watch/(.{2}[0-9]+)(?:\\?.*|)$";
    private static final Pattern trackUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)nicovideo\\.jp/watch/(.{2}[0-9]+)(?:\\?.*|)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final AtomicBoolean loggedIn = new AtomicBoolean();

    public NicoAudioSourceManager() {
        this(null, null);
    }

    public NicoAudioSourceManager(String email, String password) {
        if (!DataFormatTools.isNullOrEmpty(email) && !DataFormatTools.isNullOrEmpty(password)) {
            this.logIn(email, password);
        }
    }

    @Override
    public String getSourceName() {
        return "niconico";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher trackMatcher = trackUrlPattern.matcher(reference.identifier);
        if (trackMatcher.matches()) {
            return this.loadTrack(trackMatcher.group(1));
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private AudioTrack loadTrack(String videoId) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            AudioTrack audioTrack;
            block15: {
                CloseableHttpResponse response = httpInterface.execute(new HttpGet("http://ext.nicovideo.jp/api/getthumbinfo/" + videoId));
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                        throw new IOException("Unexpected response code from video info: " + statusCode);
                    }
                    Document document = Jsoup.parse(response.getEntity().getContent(), StandardCharsets.UTF_8.name(), "", Parser.xmlParser());
                    audioTrack = this.extractTrackFromXml(videoId, document);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return audioTrack;
        }
        catch (IOException e) {
            throw new FriendlyException("Error occurred when extracting video info.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private AudioTrack extractTrackFromXml(String videoId, Document document) {
        Iterator iterator = document.select(":root > thumb").iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String uploader = element.selectFirst("user_nickname").text();
            String title = element.selectFirst("title").text();
            String thumbnailUrl = element.selectFirst("thumbnail_url").text();
            long duration = DataFormatTools.durationTextToMillis(element.selectFirst("length").text());
            return new NicoAudioTrack(new AudioTrackInfo(title, uploader, duration, videoId, false, NicoAudioSourceManager.getWatchUrl(videoId), thumbnailUrl, null), this);
        }
        return null;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new NicoAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logIn(String email, String password) {
        AtomicBoolean atomicBoolean = this.loggedIn;
        synchronized (atomicBoolean) {
            if (this.loggedIn.get()) {
                return;
            }
            HttpPost loginRequest = new HttpPost("https://secure.nicovideo.jp/secure/login");
            loginRequest.setEntity(new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("mail", email), new BasicNameValuePair("password", password)), StandardCharsets.UTF_8));
            try (HttpInterface httpInterface = this.getHttpInterface();
                 CloseableHttpResponse response = httpInterface.execute(loginRequest);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 302) {
                    throw new IOException("Unexpected response code " + statusCode);
                }
                Header location = response.getFirstHeader("Location");
                if (location == null || location.getValue().contains("message=")) {
                    throw new FriendlyException("Login details for NicoNico are invalid.", FriendlyException.Severity.COMMON, null);
                }
                this.loggedIn.set(true);
            }
            catch (IOException e) {
                throw new FriendlyException("Exception when trying to log into NicoNico", FriendlyException.Severity.SUSPICIOUS, e);
            }
        }
    }

    private static String getWatchUrl(String videoId) {
        return "https://www.nicovideo.jp/watch/" + videoId;
    }
}

