/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeFormatInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMpegStreamAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackDetails;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeTrackFormat;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.net.URI;
import java.util.List;
import java.util.StringJoiner;

public class YoutubeAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioTrack.class);
    private final YoutubeAudioSourceManager sourceManager;

    public YoutubeAudioTrack(AudioTrackInfo trackInfo, YoutubeAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            FormatWithUrl format = this.loadBestFormatWithUrl(httpInterface);
            log.debug("Starting track from URL: {}", (Object)format.signedUrl);
            if (this.trackInfo.isStream || format.details.getContentLength() == Long.MAX_VALUE) {
                this.processStream(localExecutor, format);
            } else {
                this.processStatic(localExecutor, httpInterface, format);
            }
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }

    private void processStatic(LocalAudioTrackExecutor localExecutor, HttpInterface httpInterface, FormatWithUrl format) throws Exception {
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(httpInterface, format.signedUrl, format.details.getContentLength());){
            if (format.details.getType().getMimeType().endsWith("/webm")) {
                this.processDelegate(new MatroskaAudioTrack(this.trackInfo, stream), localExecutor);
            } else {
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private void processStream(LocalAudioTrackExecutor localExecutor, FormatWithUrl format) throws Exception {
        if ("audio/webm".equals(format.details.getType().getMimeType())) {
            throw new FriendlyException("YouTube WebM streams are currently not supported.", FriendlyException.Severity.COMMON, null);
        }
        try (HttpInterface streamingInterface = this.sourceManager.getHttpInterface();){
            this.processDelegate(new YoutubeMpegStreamAudioTrack(this.trackInfo, streamingInterface, format.signedUrl), localExecutor);
        }
    }

    private FormatWithUrl loadBestFormatWithUrl(HttpInterface httpInterface) throws Exception {
        YoutubeTrackDetails details = this.sourceManager.getTrackDetailsLoader().loadDetails(httpInterface, this.getIdentifier(), true, this.sourceManager);
        if (details == null) {
            throw new FriendlyException("This video is not available", FriendlyException.Severity.COMMON, null);
        }
        List<YoutubeTrackFormat> formats = details.getFormats(httpInterface, this.sourceManager.getSignatureResolver());
        YoutubeTrackFormat format = YoutubeAudioTrack.findBestSupportedFormat(formats);
        URI signedUrl = this.sourceManager.getSignatureResolver().resolveFormatUrl(httpInterface, details.getPlayerScript(), format);
        return new FormatWithUrl(format, signedUrl);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new YoutubeAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private static boolean isBetterFormat(YoutubeTrackFormat format, YoutubeTrackFormat other) {
        YoutubeFormatInfo info = format.getInfo();
        if (info == null) {
            return false;
        }
        if (other == null) {
            return true;
        }
        if ("audio/webm".equals(info.mimeType) && format.getAudioChannels() > 2L) {
            return false;
        }
        if (info.ordinal() != other.getInfo().ordinal()) {
            return info.ordinal() < other.getInfo().ordinal();
        }
        return format.getBitrate() > other.getBitrate();
    }

    private static YoutubeTrackFormat findBestSupportedFormat(List<YoutubeTrackFormat> formats) {
        YoutubeTrackFormat bestFormat = null;
        for (YoutubeTrackFormat format2 : formats) {
            if (!format2.isDefaultAudioTrack() || !YoutubeAudioTrack.isBetterFormat(format2, bestFormat)) continue;
            bestFormat = format2;
        }
        if (bestFormat == null) {
            StringJoiner joiner = new StringJoiner(", ");
            formats.forEach(format -> joiner.add(format.getType().toString()));
            throw new IllegalStateException("No supported audio streams available, available types: " + String.valueOf(joiner));
        }
        return bestFormat;
    }

    private static class FormatWithUrl {
        private final YoutubeTrackFormat details;
        private final URI signedUrl;

        private FormatWithUrl(YoutubeTrackFormat details, URI signedUrl) {
            this.details = details;
            this.signedUrl = signedUrl;
        }
    }
}

