/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools;

import java.util.function.Function;

public class RingBufferMath {
    private final double[] values;
    private final Function<Double, Double> inputProcessor;
    private final Function<Double, Double> outputProcessor;
    private double sum;
    private int position;
    private int size;

    public RingBufferMath(int size, Function<Double, Double> inputProcessor, Function<Double, Double> outputProcessor) {
        this.values = new double[size];
        this.inputProcessor = inputProcessor;
        this.outputProcessor = outputProcessor;
    }

    public void add(double value) {
        value = this.inputProcessor.apply(value);
        this.sum -= this.values[this.position];
        this.values[this.position] = value;
        this.sum += this.values[this.position];
        this.position = this.position + 1 == this.values.length ? 0 : this.position + 1;
        this.size = Math.min(this.values.length, this.size + 1);
    }

    public double mean() {
        if (this.size == 0) {
            return this.outputProcessor.apply(0.0);
        }
        return this.outputProcessor.apply(this.sum / (double)this.size);
    }
}

