/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.felnull.fnjl.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class FNImageUtil {
    public static BufferedImage clone(BufferedImage image) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D graphics = out.createGraphics();
        graphics.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        return out;
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        return FNImageUtil.resize(image, width, height, 16);
    }

    public static BufferedImage resize(BufferedImage image, int width, int height, int hints) {
        BufferedImage out = new BufferedImage(width, height, image.getType());
        Graphics2D graphics = out.createGraphics();
        graphics.drawImage(image.getScaledInstance(width, height, hints), 0, 0, width, height, null);
        return out;
    }

    public static byte[] toByteArray(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, baos);
        baos.flush();
        byte[] imgebyte = baos.toByteArray();
        baos.close();
        return imgebyte;
    }

    public static InputStream toInputStream(BufferedImage image, String formatName) throws IOException {
        return new ByteArrayInputStream(FNImageUtil.toByteArray(image, formatName));
    }

    public static void inputToOutputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static boolean isImage(byte[] data) {
        try {
            ImageIO.read(new ByteArrayInputStream(data)).getType();
            return true;
        }
        catch (IOException | NullPointerException e) {
            return false;
        }
    }

    public static BufferedImage reductionSize(BufferedImage image, long size) throws IOException {
        return FNImageUtil.reductionSize(image, size, "png");
    }

    public static BufferedImage reductionSize(BufferedImage image, long size, String formatName) throws IOException {
        long lastSize = FNImageUtil.toByteArray(image, formatName).length;
        if (lastSize <= size) {
            return image;
        }
        float scale = (float)size / (float)lastSize;
        BufferedImage nimg = FNImageUtil.resize(image, (int)((float)image.getWidth() * scale), (int)((float)image.getHeight() * scale));
        return FNImageUtil.reductionSizeW(nimg, size, lastSize, formatName);
    }

    private static BufferedImage reductionSizeW(BufferedImage image, long size, long lastSize, String formatName) throws IOException {
        byte[] data = FNImageUtil.toByteArray(image, formatName);
        if ((long)data.length == lastSize) {
            throw new IOException("Can't be smaller than this");
        }
        if ((long)data.length <= size) {
            return image;
        }
        BufferedImage nimg = FNImageUtil.resize(image, image.getWidth() / 2, image.getHeight() / 2);
        return FNImageUtil.reductionSizeW(nimg, size, data.length, formatName);
    }
}

