/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.Units;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import dev.felnull.imp.include.dev.lavalink.youtube.CannotBeLoaded;
import dev.felnull.imp.include.dev.lavalink.youtube.OptionDisabledException;
import dev.felnull.imp.include.dev.lavalink.youtube.YoutubeAudioSourceManager;
import dev.felnull.imp.include.dev.lavalink.youtube.cipher.CipherManager;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.ClientConfig;
import dev.felnull.imp.include.dev.lavalink.youtube.clients.skeleton.Client;
import dev.felnull.imp.include.dev.lavalink.youtube.track.TemporalInfo;
import dev.felnull.imp.include.org.apache.http.client.methods.CloseableHttpResponse;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpPost;
import dev.felnull.imp.include.org.apache.http.entity.StringEntity;
import dev.felnull.imp.include.org.apache.http.util.EntityUtils;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonMusicClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(NonMusicClient.class);
    protected static String WEB_PLAYER_PARAMS = "2AMB";
    protected static String MOBILE_PLAYER_PARAMS = "CgIIAdgDAQ%3D%3D";
    protected int playlistPageCount = 6;

    @NotNull
    protected abstract ClientConfig getBaseClientConfig(@NotNull HttpInterface var1);

    @NotNull
    protected JsonBrowser loadJsonResponse(@NotNull HttpInterface httpInterface, @NotNull HttpPost request, @NotNull String context) throws IOException {
        if (request.getEntity() instanceof StringEntity) {
            log.debug("Requesting {} ({}) with payload {}", request.getURI(), context, EntityUtils.toString(request.getEntity(), StandardCharsets.UTF_8));
        } else {
            log.debug("Requesting {} ({})", (Object)context, (Object)request.getURI());
        }
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            HttpClientTools.assertSuccessWithContent(response, context);
            HttpClientTools.assertJsonContentType(response);
            String json = EntityUtils.toString(response.getEntity());
            log.trace("Response from {} ({}) {}", request.getURI(), context, json);
            JsonBrowser jsonBrowser = JsonBrowser.parse(json);
            return jsonBrowser;
        }
    }

    @NotNull
    protected JsonBrowser loadTrackInfoFromInnertube(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId, @Nullable Client.PlayabilityStatus status) throws CannotBeLoaded, IOException {
        return this.loadTrackInfoFromInnertube(source, httpInterface, videoId, status, true);
    }

    @NotNull
    protected JsonBrowser loadTrackInfoFromInnertube(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId, @Nullable Client.PlayabilityStatus status, boolean validatePlayabilityStatus) throws CannotBeLoaded, IOException {
        Client.PlayabilityStatus playabilityStatus;
        CipherManager cipherManager = source.getCipherManager();
        ClientConfig config = this.getBaseClientConfig(httpInterface);
        if (status == null) {
            config.withClientField("clientScreen", "EMBED").withThirdPartyEmbedUrl("https://google.com");
        }
        config.withRootField("videoId", videoId).withRootField("racyCheckOk", true).withRootField("contentCheckOk", true);
        String params = this.getPlayerParams();
        if (params != null) {
            config.withRootField("params", params);
        }
        String payload = config.setAttributes(httpInterface).toJsonString();
        if (this.requirePlayerScript()) {
            CipherManager.CachedPlayerScript playerScript = cipherManager.getCachedPlayerScript(httpInterface);
            String timestamp = cipherManager.getTimestamp(httpInterface, playerScript.url);
            payload = config.withPlaybackSignatureTimestamp(timestamp).setAttributes(httpInterface).toJsonString();
        }
        HttpPost request = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/player?prettyPrint=false");
        request.setEntity(new StringEntity(payload, "UTF-8"));
        JsonBrowser json = this.loadJsonResponse(httpInterface, request, "player api response");
        JsonBrowser playabilityJson = json.get("playabilityStatus");
        JsonBrowser videoDetails = json.get("videoDetails");
        if ((validatePlayabilityStatus || videoDetails.isNull()) && (playabilityStatus = this.getPlayabilityStatus(playabilityJson, status != null)) == Client.PlayabilityStatus.NON_EMBEDDABLE) {
            if (this.isEmbedded()) {
                throw new FriendlyException("Loading information for video failed", FriendlyException.Severity.COMMON, new RuntimeException("Non-embeddable video cannot be loaded by embedded client"));
            }
            json = this.loadTrackInfoFromInnertube(source, httpInterface, videoId, playabilityStatus, true);
            this.getPlayabilityStatus(json.get("playabilityStatus"), true);
        }
        if (videoDetails.isNull()) {
            throw new FriendlyException("Loading information for video failed", FriendlyException.Severity.SUSPICIOUS, new RuntimeException("Missing videoDetails block, JSON: " + json.format()));
        }
        if (!videoId.equals(videoDetails.get("videoId").text())) {
            throw new FriendlyException("The video returned is not what was requested.", FriendlyException.Severity.SUSPICIOUS, new RuntimeException("Incorrect video response, JSON: " + json.format()));
        }
        return json;
    }

    @NotNull
    protected JsonBrowser loadSearchResults(@NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        String payload = this.getBaseClientConfig(httpInterface).withRootField("query", searchQuery).withRootField("params", "EgIQAfABAQ==").setAttributes(httpInterface).toJsonString();
        HttpPost request = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/search?prettyPrint=false");
        request.setEntity(new StringEntity(payload, "UTF-8"));
        try {
            return this.loadJsonResponse(httpInterface, request, "search response");
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    @NotNull
    protected List<AudioTrack> extractSearchResults(@NotNull YoutubeAudioSourceManager source, @NotNull JsonBrowser json) {
        return json.get("contents").get("sectionListRenderer").get("contents").values().stream().flatMap(item -> item.get("itemSectionRenderer").get("contents").values().stream()).map(item -> this.extractAudioTrack(item.get("compactVideoRenderer"), source)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    protected JsonBrowser loadMixResult(@NotNull HttpInterface httpInterface, @NotNull String mixId, @Nullable String selectedVideoId) {
        ClientConfig clientConfig = this.getBaseClientConfig(httpInterface).withRootField("videoId", selectedVideoId).withRootField("playlistId", mixId).setAttributes(httpInterface);
        HttpPost request = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/next?prettyPrint=false");
        request.setEntity(new StringEntity(clientConfig.toJsonString(), "UTF-8"));
        try {
            return this.loadJsonResponse(httpInterface, request, "mix response");
        }
        catch (IOException e) {
            throw new FriendlyException("Could not read mix page.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    @NotNull
    protected JsonBrowser extractMixPlaylistData(@NotNull JsonBrowser json) {
        return json.get("contents").get("singleColumnWatchNextResults").get("playlist").get("playlist");
    }

    @NotNull
    protected JsonBrowser loadPlaylistResult(@NotNull HttpInterface httpInterface, @NotNull String playlistId) {
        ClientConfig clientConfig = this.getBaseClientConfig(httpInterface).withRootField("browseId", "VL" + playlistId).setAttributes(httpInterface);
        HttpPost request = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/browse?prettyPrint=false");
        request.setEntity(new StringEntity(clientConfig.toJsonString(), "UTF-8"));
        try {
            return this.loadJsonResponse(httpInterface, request, "playlist response");
        }
        catch (IOException e) {
            throw ExceptionTools.toRuntimeException(e);
        }
    }

    @Nullable
    protected String extractPlaylistError(@NotNull JsonBrowser json) {
        JsonBrowser alerts = json.get("alerts");
        if (!alerts.isNull()) {
            for (JsonBrowser alert : alerts.values()) {
                JsonBrowser alertInner = alert.get("alertRenderer");
                String type = alertInner.get("type").text();
                if (!"ERROR".equals(type)) continue;
                JsonBrowser textObject = alertInner.get("text");
                String runs = textObject.get("runs").values().stream().map(run -> run.get("text").text()).collect(Collectors.joining());
                return DataFormatTools.defaultOnNull(textObject.get("simpleText").text(), runs);
            }
        }
        return null;
    }

    @Nullable
    protected String extractPlaylistName(@NotNull JsonBrowser json) {
        return json.get("header").get("playlistHeaderRenderer").get("title").get("runs").index(0).get("text").text();
    }

    @NotNull
    protected JsonBrowser extractPlaylistVideoList(@NotNull JsonBrowser json) {
        return json.get("contents").get("singleColumnBrowseResultsRenderer").get("tabs").index(0).get("tabRenderer").get("content").get("sectionListRenderer").get("contents").index(0).get("playlistVideoListRenderer");
    }

    @Nullable
    protected String extractPlaylistContinuationToken(@NotNull JsonBrowser videoList) {
        return videoList.get("continuations").index(0).get("nextContinuationData").get("continuation").text();
    }

    @NotNull
    protected JsonBrowser extractPlaylistContinuationVideos(@NotNull JsonBrowser continuationJson) {
        return continuationJson.get("continuationContents").get("playlistVideoListContinuation");
    }

    protected void extractPlaylistTracks(@NotNull JsonBrowser json, @NotNull List<AudioTrack> tracks, @NotNull YoutubeAudioSourceManager source) {
        if (!json.get("contents").isNull()) {
            json = json.get("contents");
        }
        if (json.isNull()) {
            return;
        }
        for (JsonBrowser track : json.values()) {
            JsonBrowser item = track.get("playlistVideoRenderer");
            JsonBrowser authorJson = item.get("shortBylineText");
            if (item.get("isPlayable").isNull() || authorJson.isNull()) continue;
            String videoId = item.get("videoId").text();
            JsonBrowser titleField = item.get("title");
            String title = DataFormatTools.defaultOnNull(titleField.get("simpleText").text(), titleField.get("runs").index(0).get("text").text());
            String author = DataFormatTools.defaultOnNull(authorJson.get("runs").index(0).get("text").text(), "Unknown artist");
            long duration = Units.secondsToMillis(item.get("lengthSeconds").asLong(Long.MAX_VALUE));
            tracks.add(this.buildAudioTrack(source, item, title, author, duration, videoId, false));
        }
    }

    @Nullable
    protected AudioTrack extractAudioTrack(@NotNull JsonBrowser json, @NotNull YoutubeAudioSourceManager source) {
        if (json.isNull() || json.get("lengthText").isNull() || !json.get("unplayableText").isNull()) {
            return null;
        }
        String videoId = json.get("videoId").text();
        JsonBrowser titleJson = !json.get("headline").isNull() ? json.get("headline") : json.get("title");
        String title = DataFormatTools.defaultOnNull(titleJson.get("runs").index(0).get("text").text(), titleJson.get("simpleText").text());
        String author = DataFormatTools.defaultOnNull(json.get("longBylineText").get("runs").index(0).get("text").text(), json.get("shortBylineText").get("runs").index(0).get("text").text());
        if (author == null) {
            log.debug("Author field is null, client: {}, json: {}", (Object)this.getIdentifier(), (Object)json.format());
            author = "Unknown artist";
        }
        JsonBrowser durationJson = json.get("lengthText");
        String durationText = DataFormatTools.defaultOnNull(durationJson.get("runs").index(0).get("text").text(), durationJson.get("simpleText").text());
        long duration = DataFormatTools.durationTextToMillis(durationText);
        return this.buildAudioTrack(source, json, title, author, duration, videoId, false);
    }

    @Override
    public boolean canHandleRequest(@NotNull String identifier) {
        return !identifier.startsWith("ytmsearch:");
    }

    @Override
    public void setPlaylistPageCount(int playlistPageCount) {
        this.playlistPageCount = playlistPageCount;
    }

    @Override
    public AudioItem loadVideo(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String videoId) throws CannotBeLoaded, IOException {
        if (!this.getOptions().getVideoLoading()) {
            throw new OptionDisabledException("Video loading is disabled for this client");
        }
        JsonBrowser json = this.loadTrackInfoFromInnertube(source, httpInterface, videoId, null, false);
        JsonBrowser playabilityStatus = json.get("playabilityStatus");
        JsonBrowser videoDetails = json.get("videoDetails");
        String title = videoDetails.get("title").text();
        String author = videoDetails.get("author").text();
        if (author == null) {
            log.debug("Author field is null, client: {}, json: {}", (Object)this.getIdentifier(), (Object)json.format());
            author = "Unknown artist";
        }
        TemporalInfo temporalInfo = TemporalInfo.fromRawData(playabilityStatus, videoDetails);
        return this.buildAudioTrack(source, videoDetails, title, author, temporalInfo.durationMillis, videoId, temporalInfo.isActiveStream);
    }

    @Override
    public AudioItem loadSearch(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        if (!this.getOptions().getSearching()) {
            throw new OptionDisabledException("Searching is disabled for this client");
        }
        JsonBrowser json = this.loadSearchResults(httpInterface, searchQuery);
        List<AudioTrack> tracks = this.extractSearchResults(source, json);
        if (tracks.isEmpty()) {
            return AudioReference.NO_TRACK;
        }
        return new BasicAudioPlaylist("Search results for: " + searchQuery, tracks, null, true);
    }

    @Override
    public AudioItem loadMix(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String mixId, @Nullable String selectedVideoId) {
        if (!this.getOptions().getPlaylistLoading()) {
            throw new OptionDisabledException("Mix loading is disabled for this client");
        }
        JsonBrowser json = this.loadMixResult(httpInterface, mixId, selectedVideoId);
        JsonBrowser playlist = this.extractMixPlaylistData(json);
        JsonBrowser titleElement = playlist.get("title");
        String title = titleElement.isNull() ? "YouTube mix" : titleElement.text();
        List<AudioTrack> tracks = playlist.get("contents").values().stream().map(item -> this.extractAudioTrack(item.get("playlistPanelVideoRenderer"), source)).filter(Objects::nonNull).collect(Collectors.toList());
        if (tracks.isEmpty()) {
            throw new FriendlyException("Could not find tracks from mix.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return new BasicAudioPlaylist(title, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    @Override
    public AudioItem loadPlaylist(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String playlistId, @Nullable String selectedVideoId) {
        if (!this.getOptions().getPlaylistLoading()) {
            throw new OptionDisabledException("Playlist loading is disabled for this client");
        }
        JsonBrowser json = this.loadPlaylistResult(httpInterface, playlistId);
        String error = this.extractPlaylistError(json);
        if (error != null) {
            throw new FriendlyException(error, FriendlyException.Severity.COMMON, null);
        }
        String playlistName = this.extractPlaylistName(json);
        if (playlistName == null) {
            throw new IllegalStateException("Failed to extract playlist name", new RuntimeException("Playlist name was not found, JSON: " + json.format()));
        }
        JsonBrowser playlistVideoList = this.extractPlaylistVideoList(json);
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        this.extractPlaylistTracks(playlistVideoList, tracks, source);
        String continuationsToken = this.extractPlaylistContinuationToken(playlistVideoList);
        int currentPageCount = 0;
        while (continuationsToken != null && ++currentPageCount < this.playlistPageCount) {
            ClientConfig clientConfig = this.getBaseClientConfig(httpInterface).withRootField("continuation", continuationsToken).setAttributes(httpInterface);
            HttpPost request = new HttpPost("https://youtubei.googleapis.com/youtubei/v1/browse?prettyPrint=false");
            request.setEntity(new StringEntity(clientConfig.toJsonString(), "UTF-8"));
            try {
                JsonBrowser continuationJson = this.loadJsonResponse(httpInterface, request, "playlist response");
                playlistVideoList = this.extractPlaylistContinuationVideos(continuationJson);
                continuationsToken = this.extractPlaylistContinuationToken(playlistVideoList);
                this.extractPlaylistTracks(playlistVideoList, tracks, source);
            }
            catch (IOException e) {
                throw ExceptionTools.toRuntimeException(e);
            }
        }
        if (tracks.isEmpty()) {
            throw new FriendlyException("Could not find tracks from playlist.", FriendlyException.Severity.SUSPICIOUS, new RuntimeException("JSON: " + json.format()));
        }
        return new BasicAudioPlaylist(playlistName, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    @Override
    public AudioItem loadSearchMusic(@NotNull YoutubeAudioSourceManager source, @NotNull HttpInterface httpInterface, @NotNull String searchQuery) {
        throw new FriendlyException("This client cannot search music", FriendlyException.Severity.COMMON, new RuntimeException(this.getIdentifier() + " cannot be used to search music"));
    }
}

