/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.org.apache.http.impl.client;

import dev.felnull.imp.include.org.apache.http.HttpEntity;
import dev.felnull.imp.include.org.apache.http.HttpResponse;
import dev.felnull.imp.include.org.apache.http.StatusLine;
import dev.felnull.imp.include.org.apache.http.annotation.Contract;
import dev.felnull.imp.include.org.apache.http.annotation.ThreadingBehavior;
import dev.felnull.imp.include.org.apache.http.client.HttpResponseException;
import dev.felnull.imp.include.org.apache.http.client.ResponseHandler;
import dev.felnull.imp.include.org.apache.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

