/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.org.mozilla.javascript.engine;

import dev.felnull.imp.include.org.mozilla.javascript.Context;
import dev.felnull.imp.include.org.mozilla.javascript.Scriptable;
import dev.felnull.imp.include.org.mozilla.javascript.ScriptableObject;
import javax.script.Bindings;

public class BindingsObject
extends ScriptableObject {
    private final Bindings bindings;

    BindingsObject(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Bindings must not be null");
        }
        this.bindings = bindings;
    }

    @Override
    public String getClassName() {
        return "BindingsObject";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.bindings.containsKey(name)) {
            return Scriptable.NOT_FOUND;
        }
        return Context.jsToJava(this.bindings.get(name), Object.class);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        this.bindings.put(name, Context.javaToJS(value, start));
    }

    @Override
    public void delete(String name) {
        this.bindings.remove(name);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return this.bindings.containsKey(name);
    }

    @Override
    public Object[] getIds() {
        return this.bindings.keySet().toArray();
    }
}

