/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.music.resource.Music;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CassetteTapeItem
extends Item
implements DyeableLeatherItem {
    private final BaseType type;

    public CassetteTapeItem(Item.Properties properties, BaseType type) {
        super(properties.m_41487_(1));
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (CassetteTapeItem.getTapePercentage(itemStack) != 0.0f) {
            if (!level.m_5776_()) {
                CassetteTapeItem.setTapePercentage(itemStack, 0.0f);
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public BaseType getType() {
        return this.type;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        Music m = CassetteTapeItem.getMusic(itemStack);
        if (m != null) {
            list.add((Component)Component.m_237113_((String)m.getName()).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Nullable
    public static Music getMusic(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("Music")) {
            return (Music)TagSerializable.loadSavedTag((CompoundTag)stack.m_41783_().m_128469_("Music"), (TagSerializable)new Music());
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        if (CassetteTapeItem.getMusic(stack) != null) {
            return Component.m_237115_((String)(this.m_5671_(stack) + ".written"));
        }
        return super.m_7626_(stack);
    }

    public static ItemStack setMusic(ItemStack stack, Music music) {
        stack.m_41784_().m_128365_("Music", (Tag)music.createSavedTag());
        return stack;
    }

    public static float getTapePercentage(ItemStack stack) {
        if (stack.m_41783_() != null) {
            return stack.m_41783_().m_128457_("TapePercentage");
        }
        return 0.0f;
    }

    public static ItemStack setTapePercentage(ItemStack stack, float par) {
        stack.m_41784_().m_128350_("TapePercentage", par);
        return stack;
    }

    public static boolean isSameCassetteTape(ItemStack stack, ItemStack stack2) {
        if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)stack2)) {
            return true;
        }
        if (!stack.m_150930_(stack2.m_41720_())) {
            return false;
        }
        if (stack.m_41720_() instanceof CassetteTapeItem && stack2.m_41720_() instanceof CassetteTapeItem) {
            Music m1 = CassetteTapeItem.getMusic(stack);
            Music m2 = CassetteTapeItem.getMusic(stack2);
            if (m1 == null && m2 == null) {
                return true;
            }
            if (m1 == null || m2 == null) {
                return false;
            }
            return m1.equals(m2);
        }
        return false;
    }

    public static enum BaseType {
        NORMAL,
        GLASS;

    }
}

