/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.handler;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class ServerMessageHandler {
    public static void onHandLidCycleMessage(IMPPackets.LidCycleMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ItemStack item = message.itemLocation.getItem(packetContext.getPlayer());
            if (item.m_41720_() instanceof BoomboxItem) {
                UUID id = BoomboxItem.getRingerUUID(item);
                if (id == null || !id.equals(message.boomboxId)) {
                    return;
                }
                BoomboxData data = BoomboxItem.getData(item);
                data.cycleLidOpen(packetContext.getPlayer().m_9236_());
                BoomboxItem.setData(item, data);
            }
        });
    }

    public static void onMusicPlayListChangeAuthority(IMPPackets.MusicPlayListChangeAuthorityMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                MusicManager.getInstance().changeAuthority(packetContext.getPlayer().m_20194_(), message.playlist, message.player, message.authorityType, player);
            }
        });
    }

    public static void onMultipleMusicAdd(IMPPackets.MultipleMusicAddMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                MusicManager.getInstance().addMultipleMusic(packetContext.getPlayer().m_20194_(), message.playlist, message.musics, player);
            }
        });
    }

    public static void onMusicOrPlayListDeleteMessage(IMPPackets.MusicOrPlayListDeleteMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                MusicManager mm = MusicManager.getInstance();
                if (message.music) {
                    mm.deleteMusic(packetContext.getPlayer().m_20194_(), message.playListID, message.musicID, player);
                } else {
                    mm.deletePlayList(packetContext.getPlayer().m_20194_(), message.playListID, player);
                }
            }
        });
    }

    public static void onMusicUpdateResultMessage(IMPPackets.MusicRingUpdateResultMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> MusicRingManager.getInstance().onUpdate((ServerPlayer)packetContext.getPlayer(), message.uuid(), message.waitId(), message.ringResponseStateType()));
    }

    public static void onMusicReadyResultMessage(IMPPackets.MusicRingReadyResultMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> MusicRingManager.getInstance().addReadyPlayer((ServerPlayer)packetContext.getPlayer(), message.uuid, message.waitID, message.result, message.retry, message.elapsed));
    }

    public static void onMusicAddMessage(IMPPackets.MusicMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            MusicManager mm = MusicManager.getInstance();
            MusicPlayList pl = mm.getSaveData(packetContext.getPlayer().m_20194_()).getPlayLists().get(message.playlist);
            if (pl != null && pl.getAuthority().getAuthorityType(packetContext.getPlayer().m_36316_().getId()).canAddMusic()) {
                Music m = new Music(UUID.randomUUID(), message.name, message.author, message.source, message.image, packetContext.getPlayer().m_36316_().getId(), System.currentTimeMillis());
                mm.addMusicToPlayList((ServerPlayer)packetContext.getPlayer(), pl.getUuid(), m);
            }
        });
    }

    public static void onMusicEditMessage(IMPPackets.MusicMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                MusicManager.getInstance().editMusic(packetContext.getPlayer().m_20194_(), message.uuid, message.playlist, message.name, message.image, player);
            }
        });
    }

    public static void onMusicPlayListEditMessage(IMPPackets.MusicPlayListMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                MusicManager.getInstance().editPlayList(packetContext.getPlayer().m_20194_(), message.uuid, message.name, message.image, message.invitePlayers, message.publiced, message.initMember, player);
            }
        });
    }

    public static void onMusicPlayListAddMessage(IMPPackets.MusicPlayListMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            ServerPlayer player = (ServerPlayer)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.m_9236_())) {
                HashMap<UUID, AuthorityInfo.AuthorityType> authTypes = new HashMap<UUID, AuthorityInfo.AuthorityType>();
                message.invitePlayers.forEach(n -> authTypes.put((UUID)n, AuthorityInfo.AuthorityType.INVITATION));
                AuthorityInfo auth = new AuthorityInfo(message.publiced, packetContext.getPlayer().m_36316_().getId(), packetContext.getPlayer().m_36316_().getName(), authTypes, message.initMember ? AuthorityInfo.AuthorityType.MEMBER : AuthorityInfo.AuthorityType.READ_ONLY);
                MusicPlayList pl = new MusicPlayList(UUID.randomUUID(), message.name, message.image, auth, new ArrayList<UUID>(), System.currentTimeMillis());
                MusicManager mm = MusicManager.getInstance();
                mm.addPlayList(packetContext.getPlayer().m_20194_(), pl);
                mm.addPlayListToPlayer(packetContext.getPlayer().m_20194_(), pl.getUuid(), (ServerPlayer)packetContext.getPlayer());
                for (Music importMusic : message.importMusics) {
                    Music music = new Music(UUID.randomUUID(), importMusic.getName(), importMusic.getAuthor(), importMusic.getSource(), importMusic.getImage(), player.m_36316_().getId(), System.currentTimeMillis());
                    mm.addMusicToPlayList(player, pl.getUuid(), music);
                }
                MusicManagerBlockEntity be = (MusicManagerBlockEntity)((ServerPlayer)packetContext.getPlayer()).m_9236_().m_7702_(message.blockEntityExistence.blockPos());
                if (be != null) {
                    be.setSelectedPlayList((ServerPlayer)packetContext.getPlayer(), pl.getUuid());
                }
            }
        });
    }

    public static void onMusicSyncRequestMessage(IMPPackets.MusicSyncRequestMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            MusicManager mm = MusicManager.getInstance();
            ServerPlayer pl = (ServerPlayer)packetContext.getPlayer();
            switch (message.syncType) {
                case PLAYLIST_MY_LIST: {
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, mm.getPlayerPlayLists(pl, MusicManager.PlayListGetType.JOIN), new ArrayList<Music>());
                    break;
                }
                case PLAYLIST_CAN_JOIN: {
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, mm.getPlayerPlayLists(pl, MusicManager.PlayListGetType.NO_JOIN), new ArrayList<Music>());
                    break;
                }
                case MUSIC_BY_PLAYLIST: {
                    MusicPlayList mpl = mm.getSaveData(packetContext.getPlayer().m_20194_()).getPlayLists().get(message.syncId);
                    if (mpl == null || !mpl.getAuthority().getAuthorityType(pl.m_36316_().getId()).isMoreReadOnly()) break;
                    ArrayList<Music> musics = new ArrayList<Music>();
                    mpl.getMusicList().forEach(n -> {
                        Music music = mm.getSaveData(packetContext.getPlayer().m_20194_()).getMusics().get(n);
                        if (music != null) {
                            musics.add(music);
                        }
                    });
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, new ArrayList<MusicPlayList>(), musics);
                }
            }
        });
    }

    public static void onMusicDataUpdate() {
        if (GameInstance.getServer() != null) {
            GameInstance.getServer().m_6846_().m_11314_().forEach(n -> ServerMessageHandler.sendMusicSyncData(n, IMPPackets.MusicSyncType.UPDATE, n.m_36316_().getId(), new ArrayList<MusicPlayList>(), new ArrayList<Music>()));
        }
    }

    private static void sendMusicSyncData(ServerPlayer player, IMPPackets.MusicSyncType syncType, UUID uuid, List<MusicPlayList> playLists, List<Music> musics) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)IMPPackets.MUSIC_SYNC, (FriendlyByteBuf)new IMPPackets.MusicSyncResponseMessage(syncType, uuid, playLists, musics).toFBB());
    }
}

