/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.client.BlackboardManager;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class BlackboardBakedModel
implements CustomBakedModel {
    private final ModelState modelTransform;
    private final BakedModel back;

    public BlackboardBakedModel(BakedModel back, ModelState modelTransform) {
        this.back = back;
        this.modelTransform = modelTransform;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.back.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.m_213637_(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == null) {
            Direction dir = (Direction)state.m_61143_((Property)BlackboardBlock.FACING);
            BlackboardManager.Key key = (BlackboardManager.Key)data.get(BlackboardBlockTile.BLACKBOARD_KEY);
            if (key != null) {
                BlackboardManager.Blackboard blackboard = BlackboardManager.getInstance(key);
                quads.addAll(blackboard.getOrCreateModel(dir, this::generateQuads));
            }
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(BlackboardManager.Blackboard blackboard, Direction dir) {
        byte[][] pixels = blackboard.getPixels();
        boolean emissive = blackboard.isGlow();
        TextureAtlasSprite black = ModMaterials.BLACKBOARD_BLACK.m_119204_();
        TextureAtlasSprite white = ModMaterials.BLACKBOARD_WHITE.m_119204_();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Transformation rotation = this.modelTransform.m_6189_();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            byte prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Byte current = null;
                if (y < pixels[x].length) {
                    byte b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                int tint = 0xFF000000 | BlackboardBlock.colorFromByte(prevColor);
                TextureAtlasSprite sprite = prevColor == 0 ? black : white;
                quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation, prevColor != 0 && emissive));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    public static BakedQuad createPixelQuad(float x, float y, float width, float height, TextureAtlasSprite sprite, int color, Transformation transform, boolean emissive) {
        float u0 = 1.0f - x;
        float v0 = 1.0f - y;
        float u1 = 1.0f - (x + width);
        float v1 = 1.0f - (y + height);
        BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite, (Transformation)transform);
        builder.setAutoDirection();
        BlackboardBakedModel.putVertex(builder, x + width, y + height, u1, v1, color);
        BlackboardBakedModel.putVertex(builder, x + width, y, u1, v0, color);
        BlackboardBakedModel.putVertex(builder, x, y, u0, v0, color);
        BlackboardBakedModel.putVertex(builder, x, y + height, u0, v1, color);
        if (emissive) {
            builder.lightEmission(15);
        }
        return builder.build();
    }

    private static void putVertex(BakedQuadBuilder builder, float x, float y, float u, float v, int color) {
        Vector3f posV = new Vector3f(x, y, 0.6875f);
        posV.set((float)Math.round(posV.x() * 16.0f) / 16.0f, (float)Math.round(posV.y() * 16.0f) / 16.0f, (float)Math.round(posV.z() * 16.0f) / 16.0f);
        builder.m_5483_((double)posV.x, (double)posV.y, (double)posV.z);
        builder.m_193479_(color);
        builder.m_7421_(u, v);
        builder.m_5601_(0.0f, 0.0f, -1.0f);
        builder.m_5752_();
    }
}

