/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;

@Issue(modId="minecraft", issueId="ResourceLocation Deduplication", versionRange="1.20.1", mixins={"main.ResourceLocationMixin"}, config="resourceLocationDedupe", description="Deduplicates ResourceLocations, should be tested to check if it is worth for your case")
public class ResourceLocationDedupe {
    public static final AtomicLong TIMER = new AtomicLong();
    private static final ObjectOpenCustomHashSet<String> NAMESPACE_CACHE;
    private static final ObjectOpenCustomHashSet<String> PATH_CACHE;

    public ResourceLocationDedupe() {
        IEventBus gameBus = MinecraftForge.EVENT_BUS;
        gameBus.addListener(this::printTimer);
    }

    private void printTimer(ServerStoppedEvent event) {
        AllTheLeaks.LOGGER.info("ResourceLocationDedupe: " + TIMER.get() / 1000000L + "ms");
    }

    public static synchronized String internNamespace(String namespace) {
        return (String)NAMESPACE_CACHE.addOrGet((Object)namespace);
    }

    public static synchronized String internPath(String path) {
        return (String)PATH_CACHE.addOrGet((Object)path);
    }

    static {
        Hash.Strategy<String> BASIC_HASH_STRATEGY = new Hash.Strategy<String>(){

            public int hashCode(String o) {
                return Objects.hashCode(o);
            }

            public boolean equals(String a, String b) {
                return Objects.equals(a, b);
            }
        };
        NAMESPACE_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
        PATH_CACHE = new ObjectOpenCustomHashSet((Hash.Strategy)BASIC_HASH_STRATEGY);
    }
}

