/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.player;

import com.yungnickyoung.minecraft.ribbits.module.ItemModule;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class PlayerInstrumentTracker {
    private static final float AUDIENCE_RANGE = 32.0f;
    private static final ConcurrentHashMap<Player, Set<Player>> performerToAudienceMap = new ConcurrentHashMap();

    public static void onServerTick() {
        for (Player performer : performerToAudienceMap.keySet()) {
            PlayerInstrumentTracker.updateAudienceForPerformer(performer);
        }
    }

    private static void updateAudienceForPerformer(Player performer) {
        HashSet<Player> audienceMembers = new HashSet<Player>((Collection)performerToAudienceMap.get(performer));
        if (performer.m_213877_() || !performer.m_21120_(performer.m_7655_()).m_150930_((Item)ItemModule.MARACA.get())) {
            PlayerInstrumentTracker.removePerformer(performer);
            return;
        }
        List playersInRange = performer.m_9236_().m_45976_(Player.class, performer.m_20191_().m_82377_(32.0, 32.0, 32.0));
        playersInRange.forEach(player -> {
            if (!audienceMembers.contains(player)) {
                audienceMembers.add((Player)player);
                Services.PLATFORM.startHearingMaraca((ServerPlayer)performer, (ServerPlayer)player);
            }
        });
        audienceMembers.removeIf(player -> {
            if (player.m_213877_() || !playersInRange.contains(player)) {
                Services.PLATFORM.stopHearingMaraca((ServerPlayer)performer, (ServerPlayer)player);
                return true;
            }
            return false;
        });
        performerToAudienceMap.put(performer, audienceMembers);
    }

    public static void addPerformer(Player performer) {
        performerToAudienceMap.put(performer, new HashSet());
    }

    public static void removePerformer(Player performer) {
        for (Player audienceMember : performerToAudienceMap.get(performer)) {
            Services.PLATFORM.stopHearingMaraca((ServerPlayer)performer, (ServerPlayer)audienceMember);
        }
        performerToAudienceMap.remove(performer);
    }
}

