/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.client.particle.SpinTrailParticle;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Gathering_Water_Particle
extends SpinTrailParticle {
    private static final ResourceLocation MAIN_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/gathering_lightning.png");
    private static final ResourceLocation NULL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/lightning_storm_7.png");
    private static final ResourceLocation PROTON_TRAIL_TEXTURE = new ResourceLocation("cataclysm", "textures/particle/gathering_lightning.png");

    protected Gathering_Water_Particle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float r, float g, float b) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed, r, g, b);
        this.orbitAxis = this.f_107223_.m_188503_(3);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.orbitOffset = new Vec3(0.0, 0.0, 0.0);
        this.orbitDistance = 3.0;
        this.orbitSpeed = 12.0f;
        this.f_107230_ = 1.0f;
        this.f_107219_ = false;
        this.f_107225_ = 20 + this.f_107223_.m_188503_(10);
    }

    @Override
    public int m_6355_(float partialTicks) {
        return 240;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        super.m_5744_(vertexConsumer, camera, partialTick);
    }

    public float getAlpha() {
        return Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
    }

    @Override
    public void m_5989_() {
        this.f_107215_ *= 0.9;
        this.f_107216_ *= 0.9;
        this.f_107217_ *= 0.9;
        super.m_5989_();
        float fadeIn = 0.8f * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.trailA = fadeIn * fadeOut;
    }

    @Override
    public Vec3 getOrbitPosition(float angle) {
        Vec3 center = new Vec3(this.orbitX, this.orbitY, this.orbitZ);
        float f = this.reverseOrbit ? -1.0f : 1.0f;
        Vec3 add = Vec3.f_82478_;
        float rot = angle * 3.0f * this.orbitSpeed * ((float)Math.PI / 180);
        switch (this.orbitAxis) {
            case 0: {
                add = new Vec3(0.0, this.orbitDistance * 0.5, this.orbitDistance * 0.5).m_82496_(rot * f);
                break;
            }
            case 1: {
                add = new Vec3(this.orbitDistance * 0.5, 0.0, this.orbitDistance * 0.5).m_82524_(rot * f);
                break;
            }
            case 2: {
                add = new Vec3(this.orbitDistance * 0.5, this.orbitDistance * 0.5, 0.0).m_82535_(rot * f);
            }
        }
        return center.m_82549_(add);
    }

    @Override
    public float getTrailHeight() {
        return 0.4f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return PROTON_TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public static class GatheringData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<GatheringData> DESERIALIZER = new ParticleOptions.Deserializer<GatheringData>(){

            public GatheringData fromCommand(ParticleType<GatheringData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float r = reader.readFloat();
                reader.expect(' ');
                float g = reader.readFloat();
                reader.expect(' ');
                float b = reader.readFloat();
                return new GatheringData(r, g, b);
            }

            public GatheringData fromNetwork(ParticleType<GatheringData> particleTypeIn, FriendlyByteBuf buffer) {
                return new GatheringData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final float r;
        private final float g;
        private final float b;

        public GatheringData(float r, float g, float b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.r);
            buffer.writeFloat(this.g);
            buffer.writeFloat(this.b);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
        }

        public ParticleType<GatheringData> m_6012_() {
            return (ParticleType)ModParticle.GATHERING_WATER.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getB() {
            return this.b;
        }

        public static Codec<GatheringData> CODEC(ParticleType<GatheringData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("r").forGetter(GatheringData::getR), (App)Codec.FLOAT.fieldOf("g").forGetter(GatheringData::getG), (App)Codec.FLOAT.fieldOf("b").forGetter(GatheringData::getB)).apply((Applicative)codecBuilder, GatheringData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<GatheringData> {
        public Particle createParticle(GatheringData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Gathering_Water_Particle particle = new Gathering_Water_Particle(level, x, y, z, xSpeed, ySpeed, zSpeed, data.getR(), data.getG(), data.getB());
            return particle;
        }
    }
}

