/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class FactionSubPredicate
implements EntitySubPredicate {
    private static final Codec<FactionSubPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IPlayableFaction.CODEC.optionalFieldOf("faction").forGetter(p -> Optional.ofNullable(p.faction)), (App)Codec.INT.fieldOf("level").forGetter(p -> p.level)).apply((Applicative)instance, (faction1, level1) -> new FactionSubPredicate(faction1.orElse(null), (int)level1)));
    @Nullable
    private final IPlayableFaction<?> faction;
    private final @Range(from=1L, to=0x7FFFFFFFL) int level;

    private FactionSubPredicate(@Nullable IPlayableFaction<?> faction, int level) {
        Preconditions.checkArgument((level > 0 ? 1 : 0) != 0, (Object)"Level must be greater than 0");
        this.faction = faction;
        this.level = level;
    }

    public static FactionSubPredicate of(@NotNull IPlayableFaction<?> faction) {
        return new FactionSubPredicate(faction, 1);
    }

    public static FactionSubPredicate of(@NotNull IPlayableFaction<?> faction, @Range(from=1L, to=0x7FFFFFFFL) int level) {
        return new FactionSubPredicate(faction, level);
    }

    public static FactionSubPredicate of(@Range(from=1L, to=0x7FFFFFFFL) int level) {
        return new FactionSubPredicate(null, level);
    }

    public boolean m_153246_(@NotNull Entity pEntity, @NotNull ServerLevel pLevel, @Nullable Vec3 p_218830_) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            return FactionPlayerHandler.getOpt(player).map(handler -> {
                IPlayableFaction<?> currentFaction = handler.getCurrentFaction();
                if (currentFaction != null) {
                    if (this.faction == null) {
                        return handler.getCurrentLevel() >= this.level;
                    }
                    if (currentFaction == this.faction) {
                        return handler.getCurrentLevel() >= this.level;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @NotNull
    public JsonObject m_213616_() {
        DataResult jsonElementDataResult = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        return ((JsonElement)jsonElementDataResult.result().orElseThrow()).getAsJsonObject();
    }

    @NotNull
    public EntitySubPredicate.Type m_213836_() {
        return FactionSubPredicate::fromJson;
    }

    public static FactionSubPredicate fromJson(JsonObject json) {
        DataResult decode = CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        return (FactionSubPredicate)((Pair)decode.result().orElseThrow()).getFirst();
    }
}

