/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SpawnHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.blocks.mother.IRemainsBlock;
import de.teamlapen.vampirism.blocks.mother.MotherTreeStructure;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.GhostEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.ClientboundBossEventSoundPacket;
import de.teamlapen.vampirism.network.ClientboundPlayEventPacket;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MotherBlockEntity
extends BlockEntity {
    private final ServerBossEvent bossEvent = new ServerBossEvent((Component)Component.m_237115_((String)"block.vampirism.mother"), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private final Set<ServerPlayer> activePlayers = new HashSet<ServerPlayer>();
    private final Set<UUID> involvedPlayers = new HashSet<UUID>();
    private MotherTreeStructure cachedStructure;
    private boolean isFrozen = false;
    private int freezeTimer = 0;
    @Nullable
    private AABB area;
    private int destructionTimer = 0;

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MotherBlockEntity e) {
        if (e.isFrozen && e.freezeTimer-- <= 0) {
            e.unFreezeFight(level, blockPos, blockState);
        }
        if (!e.isFrozen && e.f_58857_ != null && e.isIntact()) {
            if (e.f_58857_.m_213780_().m_188503_(50) == 0) {
                List<Triple> vuls;
                e.updateFightStatus();
                if (!e.activePlayers.isEmpty() && !(vuls = e.getTreeStructure(false).getVerifiedVulnerabilities(level).filter(t -> ((IRemainsBlock)t.getRight()).isVulnerable((BlockState)t.getMiddle())).toList()).isEmpty()) {
                    for (ServerPlayer player2 : e.activePlayers) {
                        if (player2.m_150110_().f_35934_) continue;
                        BlockPos p = (BlockPos)vuls.get(e.f_58857_.m_213780_().m_188503_(vuls.size())).getLeft();
                        player2.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, 2));
                        ModParticles.spawnParticlesServer(player2.m_9236_(), new FlyingBloodParticleOptions(100, false, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 0.5f), player2.m_20185_(), player2.m_20186_() + (double)(player2.m_20192_() / 2.0f), player2.m_20189_(), 5, 0.1f, 0.1f, 0.1f, 0.0);
                    }
                }
            }
            if (e.f_58857_.m_213780_().m_188501_() < Math.max(0.02f, Math.min(0.1f, (float)e.activePlayers.size() * 0.002f))) {
                Set<BlockPos> blocks = e.getTreeStructure(false).getCachedBlocks();
                if ((double)e.f_58857_.m_45976_(GhostEntity.class, e.getArea().m_82400_(10.0)).size() < Math.min((double)e.activePlayers.size() * 1.6, 10.0)) {
                    blocks.stream().skip(e.f_58857_.m_213780_().m_188503_(blocks.size())).findFirst().ifPresent(pos -> e.spawnGhost(level, (BlockPos)pos));
                }
            }
        }
        if (e.f_58857_ != null && e.destructionTimer > 0 && e.destructionTimer++ % 3 == 0) {
            MotherTreeStructure structure = e.getTreeStructure(false);
            Optional<Set<BlockPos>> hierarchy = structure.popHierarchy();
            if (hierarchy.isPresent()) {
                for (BlockPos p : hierarchy.get()) {
                    if (!(level.m_8055_(p).m_60734_() instanceof IRemainsBlock)) continue;
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                    ModParticles.spawnParticlesServer(level, (ParticleOptions)new DustParticleOptions(new Vector3f(0.7f, 0.7f, 0.7f), 1.0f), (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (float)p.m_123343_() + 0.5f, 20, 0.3, 0.3, 0.3, 0.01);
                    e.f_58857_.m_5594_(null, p, (SoundEvent)ModSounds.REMAINS_DEATH.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
                }
            } else {
                e.destructionTimer = -1;
                if (e.f_58857_ != null) {
                    e.f_58857_.m_5594_(null, blockPos, (SoundEvent)ModSounds.MOTHER_DEATH.get(), SoundSource.BLOCKS, 2.0f, 0.8f);
                }
                e.concludeFight();
            }
        }
        if (level.m_46467_() % 64L == 0L) {
            AABB area = e.getArea();
            Stream.concat(e.activePlayers.stream(), e.bossEvent.m_8324_().stream()).distinct().filter(player -> area.m_272282_(player.m_20182_()) > 1600.0).toList().forEach(player -> {
                e.bossEvent.m_6539_(player);
                e.activePlayers.remove(player);
            });
            AABB inflate = area.m_82377_(5.0, 5.0, 5.0);
            AABB inflate2 = inflate.m_82377_(10.0, 10.0, 10.0);
            if (!e.activePlayers.isEmpty()) {
                inflate = inflate.m_82377_(10.0, 10.0, 10.0);
                inflate2 = inflate2.m_82377_(20.0, 10.0, 20.0);
            }
            if (e.isIntact()) {
                level.m_45976_(ServerPlayer.class, inflate).forEach(e::addPlayer);
            }
            level.m_45976_(ServerPlayer.class, inflate2).forEach(e::addPlayerToBossEvent);
        }
    }

    public MotherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTiles.MOTHER.get(), pos, state);
        this.bossEvent.m_142711_(1.0f);
        this.bossEvent.m_7005_(true);
    }

    public boolean isCanBeBroken() {
        return this.destructionTimer == -1;
    }

    public boolean isIntact() {
        return this.destructionTimer == 0;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.destructionTimer = tag.m_128451_("destruction_timer");
        this.isFrozen = tag.m_128471_("is_frozen");
        this.freezeTimer = tag.m_128451_("freeze_timer");
        if (this.isFrozen) {
            this.bossEvent.m_6451_(BossEvent.BossBarColor.WHITE);
        }
        this.involvedPlayers.clear();
        if (tag.m_128425_("involved_players", 9)) {
            ListTag involvedPlayers = tag.m_128437_("involved_players", 11);
            for (Tag involvedPlayer : involvedPlayers) {
                this.involvedPlayers.add(NbtUtils.m_129233_((Tag)involvedPlayer));
            }
        }
    }

    public void onStructureBlockRemoved() {
        this.cachedStructure = null;
    }

    public void m_7651_() {
        super.m_7651_();
        this.bossEvent.m_7706_();
        this.activePlayers.clear();
    }

    private void addPlayer(Player player) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && !this.activePlayers.contains(serverPlayer = (ServerPlayer)player)) {
            this.updateFightStatus();
            this.addPlayerToBossEvent(serverPlayer);
            this.activePlayers.add(serverPlayer);
        }
    }

    private void addPlayerToBossEvent(ServerPlayer player) {
        this.bossEvent.m_6543_(player);
        VampirismMod.dispatcher.sendTo(new ClientboundBossEventSoundPacket(this.bossEvent.m_18860_(), (ResourceKey<SoundEvent>)ModSounds.MOTHER_AMBIENT.getKey()), player);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onVulnerabilityHit(LivingEntity entity, boolean destroyed) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            this.informAboutAttacker(player);
        }
        this.updateFightStatus();
        if (destroyed && this.isIntact()) {
            this.freezeFight();
        }
    }

    public void updateFightStatus() {
        List<Triple<BlockPos, BlockState, IRemainsBlock>> vuls = this.getTreeStructure(false).getVerifiedVulnerabilities(this.f_58857_).toList();
        List<Triple> remaining = vuls.stream().filter(vul -> ((IRemainsBlock)vul.getRight()).isVulnerable((BlockState)vul.getMiddle())).toList();
        if (!remaining.isEmpty()) {
            int remainingHealth = remaining.stream().mapToInt(s -> {
                BlockEntity entity = this.f_58857_.m_7702_((BlockPos)s.getLeft());
                if (entity instanceof VulnerableRemainsBlockEntity) {
                    VulnerableRemainsBlockEntity vulnerable = (VulnerableRemainsBlockEntity)entity;
                    return vulnerable.getHealth();
                }
                return 100;
            }).sum();
            this.bossEvent.m_142711_((float)remainingHealth / ((float)vuls.size() * 100.0f));
        } else {
            this.bossEvent.m_142711_(0.0f);
            this.endFight();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("destruction_timer", this.destructionTimer);
        tag.m_128379_("is_frozen", this.isFrozen);
        tag.m_128405_("freeze_timer", this.freezeTimer);
        ListTag involvedPlayers = new ListTag();
        for (UUID involvedPlayer : this.involvedPlayers) {
            involvedPlayers.add((Object)NbtUtils.m_129226_((UUID)involvedPlayer));
        }
        tag.m_128365_("involved_players", (Tag)involvedPlayers);
    }

    private void endFight() {
        this.activePlayers.forEach(p -> VampirismMod.dispatcher.sendTo(new ClientboundPlayEventPacket(2, this.m_58899_(), 0), (ServerPlayer)p));
        this.bossEvent.m_7706_();
        this.bossEvent.m_8321_(false);
        this.activePlayers.clear();
        this.initiateDestruction();
    }

    private void freezeFight() {
        this.spawnGhosts();
        this.isFrozen = true;
        this.freezeTimer = 400;
        this.getTreeStructure(false).getVerifiedVulnerabilities(this.f_58857_).forEach(vul -> ((IRemainsBlock)vul.getRight()).freeze(this.f_58857_, (BlockPos)vul.getLeft(), (BlockState)vul.getMiddle()));
        this.bossEvent.m_6451_(BossEvent.BossBarColor.WHITE);
    }

    @NotNull
    private MotherTreeStructure getTreeStructure(boolean forceRefresh) {
        if (forceRefresh || this.cachedStructure == null) {
            this.cachedStructure = MotherTreeStructure.getTreeView(this.f_58857_, this.f_58858_);
        }
        return this.cachedStructure;
    }

    private void initiateDestruction() {
        this.getTreeStructure(true);
        this.destructionTimer = 1;
    }

    private void unFreezeFight(Level level, BlockPos blockPos, BlockState blockState) {
        this.isFrozen = false;
        this.getTreeStructure(false).getVerifiedVulnerabilities(this.f_58857_).forEach(vul -> ((IRemainsBlock)vul.getRight()).unFreeze(level, (BlockPos)vul.getLeft(), (BlockState)vul.getMiddle()));
        this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
    }

    public void informAboutAttacker(ServerPlayer serverPlayer) {
        this.addPlayer((Player)serverPlayer);
        this.involvedPlayers.add(serverPlayer.m_20148_());
    }

    public Collection<ServerPlayer> involvedPlayers() {
        return this.activePlayers;
    }

    private void spawnGhost(Level level, BlockPos pos) {
        SpawnHelper.spawn(ModEntities.GHOST, level, ghost -> {
            ghost.m_146884_(Vec3.m_82512_((Vec3i)pos));
            ghost.setHome(this.getArea().m_82400_(15.0));
        });
    }

    private AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_).m_82377_(9.0, 0.0, 9.0).m_82363_(0.0, -10.0, 0.0).m_82363_(0.0, 4.0, 0.0);
        }
        return this.area;
    }

    private void spawnGhosts() {
        int size;
        Set<BlockPos> vuls = this.getTreeStructure(false).getCachedBlocks();
        int i = size = this.f_58857_.m_45976_(GhostEntity.class, this.getArea()).size();
        while ((double)i < Math.max(3.0, Math.min((double)this.activePlayers.size() * 1.6, 10.0))) {
            vuls.stream().skip(this.f_58857_.m_213780_().m_188503_(vuls.size())).findFirst().ifPresent(pos -> this.spawnGhost(this.f_58857_, (BlockPos)pos));
            ++i;
        }
    }

    public void concludeFight() {
        Set involvedEntities = this.involvedPlayers.stream().map(arg_0 -> ((ServerLevel)((ServerLevel)this.f_58857_)).m_8791_(arg_0)).filter(LivingEntity.class::isInstance).filter(s -> !s.m_5833_()).map(LivingEntity.class::cast).collect(Collectors.toSet());
        for (LivingEntity livingentity : involvedEntities) {
            if (!(livingentity instanceof ServerPlayer)) continue;
            ServerPlayer serverplayer = (ServerPlayer)livingentity;
            ModAdvancements.TRIGGER_MOTHER_WIN.m_222618_(serverplayer);
            serverplayer.m_36222_(ModStats.mother_defeated, 1);
            FactionPlayerHandler.getOpt((Player)serverplayer).filter(s -> s.getCurrentFaction() != null && s.getCurrentLevel() < s.getCurrentFaction().getHighestReachableLevel()).ifPresent(handler -> handler.setFactionLevel(handler.getCurrentFaction(), handler.getCurrentLevel() + 1));
        }
    }
}

