/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import de.teamlapen.lib.lib.util.ResourceLocationTypeAdapter;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IFactionMinionTask;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.minion.INoGlobalCommandTask;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.client.gui.screens.SelectMinionTaskRadialScreen;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.RegUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="vampirism", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientConfigHelper {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TypeToken.getParameterized(List.class, (Type[])new Type[]{IAction.class}).getType(), (Object)new IActionListTypeAdapter()).registerTypeAdapter(TypeToken.getParameterized(List.class, (Type[])new Type[]{SelectMinionTaskRadialScreen.Entry.class}).getType(), (Object)new EntryListTypeAdapter()).registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).create();
    private static final TypeToken<Map<ResourceLocation, List<IAction<?>>>> ACTION_TOKEN = TypeToken.getParameterized(Map.class, (Type[])new Type[]{ResourceLocation.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{IAction.class}).getType()});
    private static final TypeToken<Map<ResourceLocation, List<SelectMinionTaskRadialScreen.Entry>>> MINION_TASK_TOKEN = TypeToken.getParameterized(Map.class, (Type[])new Type[]{ResourceLocation.class, TypeToken.getParameterized(List.class, (Type[])new Type[]{SelectMinionTaskRadialScreen.Entry.class}).getType()});
    private static final ResourceLocation NONE = new ResourceLocation("none");
    private static Map<ResourceLocation, List<IAction<?>>> ACTION_ORDER = new HashMap();
    private static Map<ResourceLocation, List<SelectMinionTaskRadialScreen.Entry>> MINION_TASK_ORDER = new HashMap<ResourceLocation, List<SelectMinionTaskRadialScreen.Entry>>();

    @SubscribeEvent
    public static void onConfigChanged(@NotNull ModConfigEvent event) {
        if (VampirismConfig.isClientConfigSpec(event.getConfig().getSpec())) {
            String string;
            try {
                string = (String)VampirismConfig.CLIENT.actionOrder.get();
                ACTION_ORDER = Objects.requireNonNullElseGet((Map)GSON.fromJson(string, ACTION_TOKEN), HashMap::new);
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                VampirismConfig.LOGGER.error("Failed to parse action order config", e);
                VampirismConfig.CLIENT.actionOrder.set((Object)((String)VampirismConfig.CLIENT.actionOrder.getDefault()));
                ACTION_ORDER = new HashMap();
            }
            try {
                string = (String)VampirismConfig.CLIENT.minionTaskOrder.get();
                MINION_TASK_ORDER = Objects.requireNonNullElseGet((Map)GSON.fromJson(string, MINION_TASK_TOKEN), HashMap::new);
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                VampirismConfig.LOGGER.error("Failed to parse minion task order config", e);
                VampirismConfig.CLIENT.minionTaskOrder.set((Object)((String)VampirismConfig.CLIENT.minionTaskOrder.getDefault()));
                MINION_TASK_ORDER = new HashMap<ResourceLocation, List<SelectMinionTaskRadialScreen.Entry>>();
            }
        }
    }

    public static boolean testActions(Object string) {
        try {
            GSON.fromJson((String)string, ACTION_TOKEN);
        }
        catch (JsonSyntaxException | ClassCastException | IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean testTasks(Object string) {
        try {
            GSON.fromJson((String)string, MINION_TASK_TOKEN);
        }
        catch (JsonSyntaxException | ClassCastException | IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Deprecated
    @Nullable
    public static List<IAction<?>> getActionOrder(@NotNull ResourceLocation id) {
        return ACTION_ORDER.get(id);
    }

    @NotNull
    public static List<IAction<?>> getActionOrder(@NotNull IPlayableFaction<?> faction) {
        return Objects.requireNonNullElseGet(ACTION_ORDER.get(faction.getID()), () -> {
            List<IAction<?>> order = ClientConfigHelper.getDefaultActionOrder(faction);
            ClientConfigHelper.saveActionOrder(faction.getID(), order);
            return order;
        });
    }

    public static List<IAction<?>> getDefaultActionOrder(IPlayableFaction<?> faction) {
        return RegUtil.values(VampirismRegistries.ACTIONS).stream().filter(action -> action.matchesFaction(faction)).collect(Collectors.toList());
    }

    @NotNull
    public static List<SelectMinionTaskRadialScreen.Entry> getMinionTaskOrder(@Nullable IFaction<?> faction) {
        return Objects.requireNonNullElseGet(MINION_TASK_ORDER.get(Optional.ofNullable(faction).map(IFaction::getID).orElse(NONE)), () -> {
            List<SelectMinionTaskRadialScreen.Entry> order = ClientConfigHelper.getDefaultMinionTaskOrder(faction);
            ClientConfigHelper.saveMinionTaskOrder(faction, order);
            return order;
        });
    }

    public static List<SelectMinionTaskRadialScreen.Entry> getDefaultMinionTaskOrder(@Nullable IFaction<?> faction) {
        return Stream.concat(RegUtil.values(VampirismRegistries.MINION_TASKS).stream().filter(task -> !(task instanceof INoGlobalCommandTask)).filter(task -> {
            if (task instanceof IFactionMinionTask) {
                IFactionMinionTask factionTask = (IFactionMinionTask)task;
                return factionTask.getFaction() == null || factionTask.getFaction() == faction;
            }
            return true;
        }).map(SelectMinionTaskRadialScreen.Entry::new), SelectMinionTaskRadialScreen.CUSTOM_ENTRIES.values().stream()).collect(Collectors.toList());
    }

    public static void saveActionOrder(@NotNull ResourceLocation id, @NotNull List<IAction<?>> actions) {
        ACTION_ORDER.put(id, actions);
        try {
            String object = GSON.toJson(ACTION_ORDER, ACTION_TOKEN.getType());
            VampirismConfig.CLIENT.actionOrder.set((Object)object);
        }
        catch (JsonParseException e) {
            VampirismConfig.LOGGER.error("Failed to save action order", (Throwable)e);
        }
    }

    public static void saveMinionTaskOrder(@Nullable IFaction<?> faction, @NotNull List<SelectMinionTaskRadialScreen.Entry> tasks) {
        MINION_TASK_ORDER.put(Optional.ofNullable(faction).map(IFaction::getID).orElse(NONE), tasks);
        try {
            String object = GSON.toJson(MINION_TASK_ORDER, MINION_TASK_TOKEN.getType());
            VampirismConfig.CLIENT.minionTaskOrder.set((Object)object);
        }
        catch (JsonParseException e) {
            VampirismConfig.LOGGER.error("Failed to save minion task order", (Throwable)e);
        }
    }

    private static final class IActionListTypeAdapter
    extends TypeAdapter<List<IAction<?>>> {
        private IActionListTypeAdapter() {
        }

        @NotNull
        public List<IAction<?>> read(@NotNull JsonReader in) throws IOException {
            ArrayList actions = new ArrayList();
            in.beginArray();
            while (in.hasNext()) {
                IAction<?> action = RegUtil.getAction(new ResourceLocation(in.nextString()));
                if (action == null) continue;
                actions.add(action);
            }
            in.endArray();
            return actions;
        }

        public void write(@NotNull JsonWriter out, @Nullable List<IAction<?>> value) throws IOException {
            out.beginArray();
            if (value != null) {
                for (IAction<?> action : value) {
                    out.value(RegUtil.id(action).toString());
                }
            }
            out.endArray();
        }
    }

    private static final class EntryListTypeAdapter
    extends TypeAdapter<List<SelectMinionTaskRadialScreen.Entry>> {
        private EntryListTypeAdapter() {
        }

        @NotNull
        public List<SelectMinionTaskRadialScreen.Entry> read(@NotNull JsonReader in) throws IOException {
            ArrayList<SelectMinionTaskRadialScreen.Entry> actions = new ArrayList<SelectMinionTaskRadialScreen.Entry>();
            in.beginArray();
            while (in.hasNext()) {
                ResourceLocation resourceLocation = new ResourceLocation(in.nextString());
                IMinionTask<?, ?> minionTask = RegUtil.getMinionTask(resourceLocation);
                SelectMinionTaskRadialScreen.Entry entry = SelectMinionTaskRadialScreen.CUSTOM_ENTRIES.get(resourceLocation);
                if (entry != null) {
                    actions.add(entry);
                    continue;
                }
                if (minionTask == null) continue;
                actions.add(new SelectMinionTaskRadialScreen.Entry(minionTask));
            }
            in.endArray();
            return actions;
        }

        public void write(@NotNull JsonWriter out, @Nullable List<SelectMinionTaskRadialScreen.Entry> value) throws IOException {
            out.beginArray();
            if (value != null) {
                for (SelectMinionTaskRadialScreen.Entry action : value) {
                    out.value(action.getId().toString());
                }
            }
            out.endArray();
        }
    }
}

