/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.client.renderer.blockentity.VampirismBESR;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class TotemBESR
extends VampirismBESR<TotemBlockEntity> {
    private static final ResourceLocation TEXTURE_BEACON_BEAM = new ResourceLocation("vampirism", "textures/entity/totem_beam.png");
    private static final int HEIGHT = 100;

    public TotemBESR(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull TotemBlockEntity te, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int i, int i1) {
        float textureScale = te.shouldRenderBeam();
        if (textureScale > 0.0f) {
            long totalWorldTime = te.m_58904_().m_46467_();
            int captureProgress = te.getCaptureProgress();
            float[] baseColors = te.getBaseColors();
            int offset = 0;
            if (captureProgress > 0) {
                float[] overtakeColors = te.getCapturingColors();
                offset = captureProgress * 100 / 100;
                BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)0, (int)offset, (float[])overtakeColors, (float)0.2f, (float)0.25f);
            }
            BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)iRenderTypeBuffer, (ResourceLocation)TEXTURE_BEACON_BEAM, (float)partialTicks, (float)textureScale, (long)totalWorldTime, (int)offset, (int)(100 - offset), (float[])baseColors, (float)0.2f, (float)0.25f);
        } else {
            IFaction<?> faction = te.getControllingFaction();
            if (faction != null) {
                this.renderFactionName(faction, matrixStack, iRenderTypeBuffer, i);
            }
        }
    }

    public boolean shouldRenderOffScreen(@NotNull TotemBlockEntity te) {
        return true;
    }

    private void renderFactionName(@NotNull IFaction<?> faction, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource iRenderTypeBuffer, int packedLight) {
        MutableComponent displayNameIn = faction.getNamePlural().m_6879_().m_130938_(style -> style.m_131148_(faction.getChatColor()));
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.0, 0.5);
        matrixStack.m_252781_(Minecraft.m_91087_().f_91063_.m_109153_().m_253121_());
        matrixStack.m_85841_(-0.025f, -0.025f, -0.025f);
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float f1 = 0.0f;
        int j = (int)(f1 * 255.0f) << 24;
        Font font = Minecraft.m_91087_().f_91062_;
        float nameOffset = -font.m_92852_((FormattedText)displayNameIn) / 2;
        font.m_272077_((Component)displayNameIn, nameOffset, 0.0f, 0x20FFFFFF, false, matrix4f, iRenderTypeBuffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        font.m_272077_((Component)displayNameIn, nameOffset, 0.0f, -1, false, matrix4f, iRenderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, packedLight);
        matrixStack.m_85849_();
    }
}

