/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.effects.FreezeEffect;
import de.teamlapen.vampirism.effects.GarlicEffect;
import de.teamlapen.vampirism.effects.OblivionEffect;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.effects.VampirismNightVisionPotion;
import de.teamlapen.vampirism.effects.VampirismPoisonEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"vampirism");
    public static final RegistryObject<MobEffect> SANGUINARE = EFFECTS.register("sanguinare", () -> new SanguinareEffect(MobEffectCategory.NEUTRAL, 6949000));
    public static final RegistryObject<MobEffect> SATURATION = EFFECTS.register("saturation", () -> new VampirismEffect(MobEffectCategory.BENEFICIAL, 14483200));
    public static final RegistryObject<MobEffect> SUNSCREEN = EFFECTS.register("sunscreen", () -> new VampirismEffect(MobEffectCategory.BENEFICIAL, 0xFFF100).m_19472_((Attribute)ModAttributes.SUNDAMAGE.get(), "9dc9420c-3e5e-41c7-9ba4-ff70e9dc69fc", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> DISGUISE_AS_VAMPIRE = EFFECTS.register("disguise_as_vampire", () -> new VampirismEffect(MobEffectCategory.NEUTRAL, 0x999900));
    public static final RegistryObject<MobEffect> FIRE_PROTECTION = EFFECTS.register("fire_protection", () -> new VampirismEffect(MobEffectCategory.BENEFICIAL, 14981690));
    public static final RegistryObject<MobEffect> GARLIC = EFFECTS.register("garlic", GarlicEffect::new);
    public static final RegistryObject<MobEffect> POISON = EFFECTS.register("poison", () -> new VampirismPoisonEffect(5149489));
    public static final RegistryObject<MobEffect> FREEZE = EFFECTS.register("freeze", FreezeEffect::new);
    public static final RegistryObject<MobEffect> NEONATAL = EFFECTS.register("neonatal", () -> new VampirismEffect(MobEffectCategory.NEUTRAL, 0xFFBBBB).m_19472_(Attributes.f_22281_, "377d132d-d091-43b2-8a8f-b940f9bc894c", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22279_, "ad6d7def-46e2-485f-afba-39252767f114", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> OBLIVION = EFFECTS.register("oblivion", OblivionEffect::new);
    public static final RegistryObject<MobEffect> ARMOR_REGENERATION = EFFECTS.register("armor_regeneration", () -> new VampirismEffect(MobEffectCategory.NEUTRAL, 13727298));
    public static final RegistryObject<MobEffect> BAD_OMEN_HUNTER = EFFECTS.register("bad_omen_hunter", () -> new BadOmenEffect(){

        @Override
        public IFaction<?> getFaction() {
            return VReference.HUNTER_FACTION;
        }
    });
    public static final RegistryObject<MobEffect> BAD_OMEN_VAMPIRE = EFFECTS.register("bad_omen_vampire", () -> new BadOmenEffect(){

        @Override
        public IFaction<?> getFaction() {
            return VReference.VAMPIRE_FACTION;
        }
    });
    public static final RegistryObject<MobEffect> LORD_SPEED = EFFECTS.register("lord_speed", () -> new VampirismEffect(MobEffectCategory.BENEFICIAL, 0xFFFFFF).m_19472_(Attributes.f_22279_, "efe607d8-db8a-4156-b9d0-6a0640593057", 0.07f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> LORD_ATTACK_SPEED = EFFECTS.register("lord_attack_speed", () -> new VampirismEffect(MobEffectCategory.BENEFICIAL, 0xFFFFFF).m_19472_(Attributes.f_22283_, "a2ca9534-3baf-404f-b159-bc835bf963e6", 0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<MobEffect> NO_BLOOD = EFFECTS.register("no_blood", () -> new VampirismEffect(MobEffectCategory.HARMFUL, 0x191919).m_19472_(Attributes.f_22279_, "48bb1318-3d52-4030-a264-de52b59d03d0", -0.4f, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22283_, "6d9474ab-6693-49f5-9357-ad4444a16bd4", (double)-0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_((Attribute)ModAttributes.SUNDAMAGE.get(), "45ebd53a-14fa-4ede-b4e7-412e075a8b5f", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22285_, "45ebd53a-14fa-4ede-b4e7-412e075a8b5f", -0.4, AttributeModifier.Operation.MULTIPLY_TOTAL).m_19472_(Attributes.f_22284_, "45ebd53a-14fa-4ede-b4e7-412e075a8b5f", -0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
    private static final Logger LOGGER = LogManager.getLogger();
    private static MobEffect modded_night_vision;
    private static MobEffect vanilla_night_vision;

    static void register(IEventBus bus) {
        EFFECTS.register(bus);
    }

    static void replaceEffects(@NotNull IForgeRegistry<MobEffect> registry) {
        vanilla_night_vision = MobEffects.f_19611_;
        modded_night_vision = new VampirismNightVisionPotion();
        registry.register(registry.getKey((Object)vanilla_night_vision), (Object)modded_night_vision);
    }

    static void fixNightVisionEffectTypesUnsafe() {
        LOGGER.info("Fixing vanilla night vision potion types");
        try {
            for (MobEffectInstance effect : Potions.f_43603_.m_43488_()) {
                if (!effect.m_19544_().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(MobEffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"effect");
            }
            for (MobEffectInstance effect : Potions.f_43604_.m_43488_()) {
                if (!effect.m_19544_().equals(vanilla_night_vision)) continue;
                ObfuscationReflectionHelper.setPrivateValue(MobEffectInstance.class, (Object)effect, (Object)modded_night_vision, (String)"effect");
            }
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
            LOGGER.error("Unable to modify vanilla night vision types. Potion tileInventory and more might not work", (Throwable)e);
        }
    }

    static boolean checkNightVision() {
        if (!(MobEffects.f_19611_ instanceof VampirismNightVisionPotion)) {
            LOGGER.warn("Vampirism was not able to register it's night vision potion");
            return false;
        }
        return true;
    }
}

