/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class MoveToPositionGoal<T extends PathfinderMob>
extends Goal {
    protected final T entity;
    @NotNull
    protected final LevelReader world;
    private final double followSpeed;
    @NotNull
    private final PathNavigation navigator;
    private final float minDist;
    private final float maxDist;
    private final boolean doTeleport;
    private final boolean look;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public MoveToPositionGoal(@NotNull T entity, double followSpeed, float minDist, float maxDist, boolean doTeleport, boolean look) {
        this.entity = entity;
        this.world = entity.m_20193_();
        this.followSpeed = followSpeed;
        this.minDist = minDist;
        this.navigator = entity.m_21573_();
        this.maxDist = maxDist;
        this.doTeleport = doTeleport;
        this.look = look;
        this.m_7021_(look ? EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP) : EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
        if (!(entity.m_21573_() instanceof GroundPathNavigation) && !(entity.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for MoveToPositionGoal");
        }
    }

    public boolean m_8045_() {
        return this.getTargetPosition().m_123331_((Vec3i)this.entity.m_20183_()) > (double)(this.minDist * this.minDist);
    }

    public boolean m_8036_() {
        return this.getTargetPosition().m_123331_((Vec3i)this.entity.m_20183_()) > (double)(this.minDist * this.minDist);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.navigator.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        Vec3i target = this.getTargetPosition();
        if (this.look) {
            this.entity.m_21563_().m_24964_(this.getLookPosition());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            boolean flag = this.navigator.m_26519_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), this.followSpeed);
            if (!(!this.doTeleport || flag && this.entity.m_217043_().m_188503_(8) != 0 || this.entity.m_20275_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_()) < (double)(this.maxDist * this.maxDist))) {
                int sX = target.m_123341_() - 2;
                int sZ = target.m_123343_() - 2;
                int sY = target.m_123342_();
                for (int dX = 0; dX <= 4; ++dX) {
                    for (int dZ = 0; dZ <= 4; ++dZ) {
                        if (dX >= 1 && dZ >= 1 && dX <= 3 && dZ <= 3 || !this.canTeleportToBlock(new BlockPos(sX + dX, sY - 1, sZ + dZ))) continue;
                        this.entity.m_7678_((double)((float)(sX + dX) + 0.5f), (double)sY, (double)((float)(sZ + dZ) + 0.5f), this.entity.m_146908_(), this.entity.m_146909_());
                        this.navigator.m_26573_();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(@NotNull BlockPos pos) {
        BlockState blockstate = this.world.m_8055_(pos);
        return blockstate.m_60643_((BlockGetter)this.world, pos, this.entity.m_6095_()) && this.world.m_46859_(pos.m_7494_()) && this.world.m_46859_(pos.m_6630_(2));
    }

    protected abstract Vec3 getLookPosition();

    protected abstract Vec3i getTargetPosition();
}

