/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModAi;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModVillage;
import de.teamlapen.vampirism.entity.VampirismVillagerEntity;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.entity.villager.Trades;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.TotemHelper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class ConvertedVillagerEntity
extends VampirismVillagerEntity
implements CurableConvertedCreature<Villager, ConvertedVillagerEntity> {
    @NotNull
    public static final List<SensorType<? extends Sensor<? super Villager>>> SENSOR_TYPES;
    private static final EntityDataAccessor<Boolean> CONVERTING;
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;
    private final CurableConvertedCreature.Data<Villager> convertedData = new CurableConvertedCreature.Data();

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return VampirismVillagerEntity.getAttributeBuilder().m_22266_((Attribute)ModAttributes.SUNDAMAGE.get());
    }

    public ConvertedVillagerEntity(EntityType<? extends ConvertedVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        this.addAdditionalSaveDataC(compound);
    }

    @Override
    public void m_8107_() {
        this.aiStepC(EntityType.f_20492_);
        ++this.bloodTimer;
        super.m_8107_();
    }

    public Optional<BlockPos> getClosestVampireForest(Level level, BlockPos blockPos) {
        Optional<Object> optional;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            optional = TotemHelper.getTotemNearPos(serverLevel, blockPos, true).flatMap(TotemBlockEntity::getVampireForestLocation);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    @NotNull
    public Villager cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<Villager> newType) {
        Player playerentity;
        Villager villager = CurableConvertedCreature.super.cureEntity(world, entity, newType);
        if (((CurableConvertedCreature.Data)this.data()).conversationStarter != null && (playerentity = world.m_46003_(((CurableConvertedCreature.Data)this.data()).conversationStarter)) instanceof ServerPlayer) {
            ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.trigger((ServerPlayer)playerentity, (Entity)this, villager);
            world.m_8670_(ReputationEventType.f_26985_, (Entity)playerentity, (ReputationEventHandler)villager);
        }
        return villager;
    }

    @Override
    public boolean m_7327_(@NotNull Entity entity) {
        Player player;
        if (!this.m_9236_().f_46443_ && this.wantsBlood() && entity instanceof Player && !Helper.isHunter(player = (Player)entity) && !UtilLib.canReallySee((LivingEntity)player, (LivingEntity)this, true)) {
            int amt = VampirePlayer.getOpt(player).map(vampire -> vampire.onBite(this)).orElse(0);
            this.drinkBlood(amt, 0.7f, new DrinkBloodContext((LivingEntity)player));
            return true;
        }
        return super.m_7327_(entity);
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    @NotNull
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
        @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, event.getAmount() * 20));
        this.bloodTimer = -1200 - this.f_19796_.m_188503_(1200);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.m_7822_(id);
    }

    @Override
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean hurtSuper(DamageSource damageSource, float amount) {
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource src, float amount) {
        return this.hurtC(src, amount);
    }

    @NotNull
    protected Component m_5677_() {
        ResourceLocation profName = RegUtil.id(this.m_7141_().m_35571_());
        return Component.m_237115_((String)(EntityType.f_20492_.m_20675_() + "." + (String)(!"minecraft".equals(profName.m_135827_()) ? profName.m_135827_() + "." : "") + profName.m_135815_()));
    }

    public void m_7822_(byte id) {
        if (!this.handleSound(id, (PathfinderMob)this)) {
            super.m_7822_(id);
        }
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.m_9236_().m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        return this.mobInteractC(player, hand);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.readAdditionalSaveDataC(compound);
    }

    public void m_35424_(@NotNull Brain<Villager> brain) {
        super.m_35424_(brain);
        if (!this.m_6162_()) {
            brain.m_21912_((Schedule)ModVillage.CONVERTED_DEFAULT.get());
            brain.m_21862_(this.m_9236_().m_46468_(), this.m_9236_().m_46467_());
        }
    }

    @Override
    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, amt * 20));
        this.bloodTimer = 0;
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData((PathfinderMob)this);
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamicIn) {
        Brain brain = Brain.m_21923_((Collection)f_35367_, SENSOR_TYPES).m_22073_(dynamicIn);
        this.m_35424_((Brain<Villager>)brain);
        return brain;
    }

    protected void m_7604_() {
        super.m_7604_();
        if (!this.m_6616_().isEmpty() && this.m_217043_().m_188503_(3) == 0) {
            this.m_35277_(this.m_6616_(), Trades.converted_trades, 1);
        }
    }

    @Override
    public CurableConvertedCreature.Data<Villager> data() {
        return this.convertedData;
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        super.m_6667_(pCause);
        this.dieC(pCause);
    }

    protected void m_6153_() {
        super.m_6153_();
        this.tickDeathC();
    }

    static {
        CONVERTING = SynchedEntityData.m_135353_(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        OVERLAY_TEXTURE = SynchedEntityData.m_135353_(ConvertedVillagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        SENSOR_TYPES = Lists.newArrayList((Iterable)Villager.f_35368_);
        SENSOR_TYPES.remove(SensorType.f_26815_);
        SENSOR_TYPES.add((SensorType<? extends Sensor<? super Villager>>)((SensorType)ModAi.VAMPIRE_VILLAGER_HOSTILES.get()));
    }
}

