/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.vampire.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModRefinements;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class TeleportVampireAction
extends DefaultVampireAction {
    @Override
    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        Player player = vampire.getRepresentingPlayer();
        int dist = (Integer)VampirismConfig.BALANCE.vaTeleportMaxDistance.get();
        if (vampire.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.TELEPORT_DISTANCE.get())) {
            dist = (int)((double)dist * (Double)VampirismConfig.BALANCE.vrTeleportDistanceMod.get());
        }
        HitResult target = UtilLib.getPlayerLookingSpot(player, dist);
        double ox = player.m_20185_();
        double oy = player.m_20186_();
        double oz = player.m_20189_();
        if (target.m_6662_() == HitResult.Type.MISS) {
            player.m_5496_((SoundEvent)SoundEvents.f_12209_.get(), 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            if (player.m_20193_().m_8055_(((BlockHitResult)target).m_82425_()).m_280555_()) {
                pos = ((BlockHitResult)target).m_82425_().m_7494_();
            }
        } else if (player.m_20193_().m_8055_(((EntityHitResult)target).m_82443_().m_20183_()).m_280555_()) {
            pos = ((EntityHitResult)target).m_82443_().m_20183_();
        }
        if (pos != null) {
            player.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
            if (player.m_20193_().m_46855_(player.m_20191_()) || !player.m_20193_().m_45784_((Entity)player)) {
                pos = null;
            }
        }
        if (pos == null) {
            player.m_6034_(ox, oy, oz);
            player.m_5496_((SoundEvent)SoundEvents.f_12208_.get(), 1.0f, 1.0f);
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer playerMp = (ServerPlayer)player;
            playerMp.m_6038_();
            playerMp.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5);
        }
        AreaParticleCloudEntity particleCloud = new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)((EntityType)ModEntities.PARTICLE_CLOUD.get()), player.m_20193_());
        particleCloud.m_6034_(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.m_20206_());
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.m_20193_().m_7967_((Entity)particleCloud);
        player.m_20193_().m_6263_(null, ox, oy, oz, (SoundEvent)ModSounds.TELEPORT_AWAY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.TELEPORT_HERE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public boolean canBeUsedBy(@NotNull IVampirePlayer vampire) {
        return !vampire.getActionHandler().isActionActive((ILastingAction)VampireActions.BAT.get());
    }

    @Override
    public int getCooldown(@NotNull IVampirePlayer player) {
        return (int)((player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.TELEPORT_DISTANCE.get()) ? 0.5 : 1.0) * (double)((Integer)VampirismConfig.BALANCE.vaTeleportCooldown.get()).intValue() * 20.0);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)VampirismConfig.BALANCE.vaTeleportEnabled.get();
    }

    @Override
    public boolean showHudCooldown(Player player) {
        return true;
    }
}

