/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InvisibleEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public InvisibleEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(@NotNull T entity) {
        ModParticles.spawnParticlesServer(entity.m_20193_(), (ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 60, 1.0, 1.0, 1.0, 0.0);
    }

    @Override
    public void deactivate(@NotNull T entity) {
        ((IFactionEntity)entity).getRepresentingEntity().m_6842_(false);
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaInvisibilityCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaInvisibilityDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        if (entity.m_5448_() == null) {
            return 0;
        }
        double distanceToTarget = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82492_(entity.m_5448_().m_20185_(), entity.m_5448_().m_20186_(), entity.m_5448_().m_20189_()).m_82553_();
        if (distanceToTarget > 4.0) {
            return 3;
        }
        return 1;
    }

    @Override
    public void onUpdate(@NotNull T entity, int duration) {
        if (!((IFactionEntity)entity).getRepresentingEntity().m_20145_()) {
            ((IFactionEntity)entity).getRepresentingEntity().m_6842_(true);
        }
    }

    @Override
    public void updatePreAction(@NotNull T entity, int duration) {
        if (duration % 5 == 0) {
            ModParticles.spawnParticlesServer(entity.m_20193_(), (ParticleOptions)ParticleTypes.f_123813_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 10, 1.0, 1.0, 1.0, 0.0);
        }
    }
}

