/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.core.ModContainer;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionTableMenu
extends InventoryContainerMenu {
    public static final InventoryContainerMenu.SelectorInfo @NotNull [] SELECTOR_INFOS = new InventoryContainerMenu.SelectorInfo[6];
    public static final InventoryContainerMenu.SelectorInfo @NotNull [] SELECTOR_INFOS_EXTENDED = new InventoryContainerMenu.SelectorInfo[8];
    private final boolean extended;
    @NotNull
    private final ContainerData syncedProperties;

    public PotionTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPos, @NotNull Container inventory, boolean extended, @Nullable ContainerData syncedProperties) {
        super((MenuType<? extends InventoryContainerMenu>)((MenuType)ModContainer.EXTENDED_POTION_TABLE.get()), id, playerInventory, worldPos, inventory, extended ? SELECTOR_INFOS_EXTENDED : SELECTOR_INFOS);
        assert (inventory.m_6643_() >= (extended ? 8 : 6));
        this.syncedProperties = syncedProperties == null ? new SimpleContainerData(2) : syncedProperties;
        this.addPlayerSlots(playerInventory);
        this.m_38884_(this.syncedProperties);
        this.extended = extended;
    }

    public int getBrewTime() {
        return this.syncedProperties.m_6413_(0);
    }

    public int getFuelTime() {
        return this.syncedProperties.m_6413_(1);
    }

    public boolean isExtendedTable() {
        return this.extended;
    }

    @Override
    protected boolean isSlotEnabled(int id) {
        return id <= 5 || this.isExtendedTable();
    }

    static {
        PotionTableMenu.SELECTOR_INFOS[0] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[0] = new InventoryContainerMenu.SelectorInfo((Predicate<ItemStack>)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_}), 23, 14);
        PotionTableMenu.SELECTOR_INFOS[1] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[1] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidExtraIngredient((ItemStack)stack), 101, 16);
        PotionTableMenu.SELECTOR_INFOS[2] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[2] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidIngredient((ItemStack)stack), 126, 8);
        PotionTableMenu.SELECTOR_INFOS[3] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[3] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 148, 59);
        PotionTableMenu.SELECTOR_INFOS[4] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[4] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 126, 59);
        PotionTableMenu.SELECTOR_INFOS[5] = PotionTableMenu.SELECTOR_INFOS_EXTENDED[5] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 104, 59);
        PotionTableMenu.SELECTOR_INFOS_EXTENDED[6] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 82, 59);
        PotionTableMenu.SELECTOR_INFOS_EXTENDED[7] = new InventoryContainerMenu.SelectorInfo(stack -> VampirismAPI.extendedBrewingRecipeRegistry().isValidInput((ItemStack)stack), 60, 59);
    }

    public static class Factory
    implements IContainerFactory<PotionTableMenu> {
        @Nullable
        public PotionTableMenu create(int windowId, @NotNull Inventory inv, @Nullable FriendlyByteBuf data) {
            if (data == null) {
                return new PotionTableMenu(windowId, inv, ContainerLevelAccess.f_39287_, (Container)new SimpleContainer(6), false, null);
            }
            boolean extraSlots = data.readBoolean();
            return new PotionTableMenu(windowId, inv, ContainerLevelAccess.f_39287_, (Container)new SimpleContainer(extraSlots ? 8 : 6), extraSlots, null);
        }
    }
}

