/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.inventory.VampireBeaconMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public record ServerboundSetVampireBeaconPacket(Optional<MobEffect> effect, Optional<Integer> amplifier) implements IMessage.IServerBoundMessage
{
    public static final Codec<ServerboundSetVampireBeaconPacket> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().optionalFieldOf("effect").forGetter(l -> l.effect), (App)Codec.INT.optionalFieldOf("amplifier").forGetter(l -> l.amplifier)).apply((Applicative)builder, ServerboundSetVampireBeaconPacket::new));

    static void encode(@NotNull ServerboundSetVampireBeaconPacket msg, @NotNull FriendlyByteBuf buf) {
        buf.m_272073_(CODEC, (Object)msg);
    }

    @NotNull
    static ServerboundSetVampireBeaconPacket decode(@NotNull FriendlyByteBuf buf) {
        return (ServerboundSetVampireBeaconPacket)buf.m_271872_(CODEC);
    }

    public static void handle(ServerboundSetVampireBeaconPacket msg, @NotNull Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            VampireBeaconMenu beaconMenu;
            ServerPlayer sender = ctx.getSender();
            AbstractContainerMenu patt1760$temp = sender.f_36096_;
            if (patt1760$temp instanceof VampireBeaconMenu && (beaconMenu = (VampireBeaconMenu)patt1760$temp).m_6875_((Player)sender)) {
                beaconMenu.updateEffects(msg.effect, msg.amplifier);
            }
        });
        ctx.setPacketHandled(true);
    }
}

