/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTIngredient
extends Ingredient {
    private final ItemStack[] stacks;

    public NBTIngredient(ItemStack ... stack) {
        super(Stream.of(stack).map(Ingredient.ItemValue::new));
        this.stacks = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        for (ItemStack stack : this.stacks) {
            if (stack.m_41720_() != input.m_41720_() || stack.m_41773_() != input.m_41773_() || !stack.areShareTagsEqual(input)) continue;
            return true;
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        if (this.stacks.length == 1) {
            json.addProperty("item", RegUtil.id(this.stacks[0].m_41720_()).toString());
            json.addProperty("count", (Number)this.stacks[0].m_41613_());
            if (this.stacks[0].m_41782_()) {
                json.add("nbt", (JsonElement)new JsonParser().parse(this.stacks[0].m_41783_().toString()).getAsJsonObject());
            }
        } else {
            JsonArray array = new JsonArray();
            for (ItemStack stack : this.stacks) {
                JsonObject obj = new JsonObject();
                obj.addProperty("item", RegUtil.id(stack.m_41720_()).toString());
                obj.addProperty("count", (Number)stack.m_41613_());
                if (stack.m_41782_()) {
                    obj.add("nbt", (JsonElement)new JsonParser().parse(stack.m_41783_().toString()).getAsJsonObject());
                }
                array.add((JsonElement)obj);
            }
            json.add("items", (JsonElement)array);
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public NBTIngredient parse(@NotNull FriendlyByteBuf buffer) {
            int length = buffer.m_130242_();
            ItemStack[] stacks = new ItemStack[length];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = buffer.m_130267_();
            }
            return new NBTIngredient(stacks);
        }

        @NotNull
        public NBTIngredient parse(@NotNull JsonObject json) {
            if (json.has("items")) {
                JsonArray items = json.get("items").getAsJsonArray();
                ItemStack[] stacks = new ItemStack[items.size()];
                for (int i = 0; i < stacks.length; ++i) {
                    stacks[i] = CraftingHelper.getItemStack((JsonObject)items.get(i).getAsJsonObject(), (boolean)true);
                }
                return new NBTIngredient(stacks);
            }
            return new NBTIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull NBTIngredient ingredient) {
            buffer.m_130130_(ingredient.stacks.length);
            for (ItemStack stack : ingredient.stacks) {
                buffer.m_130055_(stack);
            }
        }
    }
}

