/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;

public class ManagedPos
extends AbstractManagedData<BlockPos> {
    private BlockPos value;
    private BlockPos defaultValue;
    protected Function<BlockPos, BlockPos> validator = null;

    public ManagedPos(String name, @Nullable BlockPos defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
        this.defaultValue = defaultValue == null ? null : new BlockPos((Vec3i)defaultValue);
    }

    public ManagedPos(String name, DataFlags ... flags) {
        this(name, BlockPos.f_121853_, flags);
    }

    public BlockPos set(BlockPos value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            BlockPos prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    @Nullable
    public BlockPos get() {
        return this.value;
    }

    public ManagedPos setValidator(Function<BlockPos, BlockPos> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value != null);
        if (this.value != null) {
            output.writePos(this.value);
        }
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean() ? input.readPos() : null;
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        CompoundTag nbt;
        CompoundTag compoundTag = nbt = this.value == null ? new CompoundTag() : NbtUtils.m_129224_((BlockPos)this.value);
        if (this.value == null) {
            nbt.m_128379_("null", true);
        }
        compound.m_128365_(this.name, (Tag)nbt);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        CompoundTag nbt;
        this.value = !compound.m_128425_(this.name, 10) ? (this.defaultValue == null ? null : new BlockPos((Vec3i)this.defaultValue)) : ((nbt = compound.m_128469_(this.name)).m_128441_("null") ? null : NbtUtils.m_129239_((CompoundTag)nbt));
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean notNull() {
        return this.value != null;
    }
}

