/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannelBuilder;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.handlers.contributor.ContributorProperties;
import com.brandon3055.brandonscore.multiblock.MultiBlockDefinition;
import com.brandon3055.brandonscore.multiblock.MultiBlockManager;
import com.brandon3055.brandonscore.network.ClientPacketHandler;
import com.brandon3055.brandonscore.network.ServerPacketHandler;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.Map;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.registries.ForgeRegistries;

public class BCoreNetwork {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final ResourceLocation CHANNEL = new ResourceLocation("brandonscore:network");
    public static EventNetworkChannel netChannel;
    public static final int C_TILE_DATA_MANAGER = 1;
    public static final int C_TILE_MESSAGE = 2;
    public static final int C_NO_CLIP = 4;
    public static final int C_PLAYER_ACCESS = 5;
    public static final int C_PLAYER_ACCESS_UPDATE = 6;
    public static final int C_INDEXED_MESSAGE = 7;
    public static final int C_TILE_CAP_DATA = 8;
    public static final int C_PLAY_SOUND = 9;
    public static final int C_SPAWN_ENTITY = 10;
    public static final int C_SPAWN_PARTICLE = 11;
    public static final int C_ENTITY_VELOCITY = 12;
    public static final int C_OPEN_HUD_CONFIG = 13;
    public static final int C_MULTI_BLOCK_DEFINITIONS = 14;
    public static final int C_CONTRIBUTOR_CONFIG = 15;
    public static final int S_CONTAINER_MESSAGE = 1;
    public static final int S_PLAYER_ACCESS_BUTTON = 2;
    public static final int S_TILE_DATA_MANAGER = 3;
    public static final int S_CONTRIBUTOR_CONFIG = 4;
    public static final int S_CONTRIBUTOR_LINK = 5;
    public static final int S_DUMMY_PACKET = 99;

    public static void sendNoClip(ServerPlayer player, boolean enabled) {
        PacketCustom packet = new PacketCustom(CHANNEL, 4);
        packet.writeBoolean(enabled);
        packet.sendToPlayer(player);
        LogHelperBC.dev("Sending NoClip update to player: " + player + " Enabled: " + enabled);
    }

    public static void sendOpenPlayerAccessUI(ServerPlayer player, int windowID) {
        PacketCustom packet = new PacketCustom(CHANNEL, 5);
        packet.writeInt(windowID);
        packet.sendToPlayer(player);
    }

    public static void sendPlayerAccessUIUpdate(ServerPlayer player, Player target) {
        PacketCustom packet = new PacketCustom(CHANNEL, 6);
        packet.writeString(target.m_36316_().getName());
        packet.writePos(target.m_20183_());
    }

    public static void sendPlayerAccessButton(int button) {
        PacketCustom packet = new PacketCustom(CHANNEL, 2);
        packet.writeByte(button);
        packet.sendToServer();
    }

    public static void sendIndexedMessage(ServerPlayer player, Component message, MessageSignature signature) {
        PacketCustom packet = new PacketCustom(CHANNEL, 7);
        packet.writeTextComponent(message);
        packet.writeBytes(signature.f_240884_());
        packet.sendToPlayer(player);
    }

    public static void sendSound(Level world, int x, int y, int z, SoundEvent sound, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        BCoreNetwork.sendSound(world, new BlockPos(x, y, z), sound, category, volume, pitch, distanceDelay);
    }

    public static void sendSound(Level world, Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        BCoreNetwork.sendSound(world, entity.m_20183_(), sound, category, volume, pitch, distanceDelay);
    }

    public static void sendSound(Level world, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch, boolean distanceDelay) {
        if (!world.f_46443_) {
            PacketCustom packet = new PacketCustom(CHANNEL, 9);
            packet.writePos(pos);
            packet.writeRegistryId(ForgeRegistries.SOUND_EVENTS, (Object)sound);
            packet.writeVarInt(category.ordinal());
            packet.writeFloat(volume);
            packet.writeFloat(pitch);
            packet.writeBoolean(distanceDelay);
            packet.sendToChunk(world, pos);
        }
    }

    public static void sendParticle(Level world, ParticleOptions particleData, Vector3 pos, Vector3 motion, boolean distanceOverride) {
        if (!world.f_46443_) {
            PacketCustom packet = new PacketCustom(CHANNEL, 11);
            packet.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)particleData.m_6012_());
            particleData.m_7711_(packet.toPacketBuffer());
            packet.writeVector(pos);
            packet.writeVector(motion);
            packet.writeBoolean(distanceOverride);
            packet.sendToChunk(world, pos.pos());
        }
    }

    public static Packet<?> getEntitySpawnPacket(Entity entity) {
        PacketCustom packet = new PacketCustom(CHANNEL, 10);
        packet.writeRegistryId(ForgeRegistries.ENTITY_TYPES, (Object)entity.m_6095_());
        packet.writeInt(entity.m_19879_());
        packet.writeUUID(entity.m_20148_());
        packet.writeDouble(entity.m_20185_());
        packet.writeDouble(entity.m_20186_());
        packet.writeDouble(entity.m_20189_());
        packet.writeByte((int)((byte)Mth.m_14143_((float)(entity.m_146909_() * 256.0f / 360.0f))));
        packet.writeByte((int)((byte)Mth.m_14143_((float)(entity.m_146908_() * 256.0f / 360.0f))));
        packet.writeByte((int)((byte)(entity.m_6080_() * 256.0f / 360.0f)));
        Vec3 velocity = entity.m_20184_();
        packet.writeFloat((float)velocity.f_82479_);
        packet.writeFloat((float)velocity.f_82480_);
        packet.writeFloat((float)velocity.f_82481_);
        return packet.toPacket(NetworkDirection.PLAY_TO_CLIENT);
    }

    public static Packet<?> sendEntityVelocity(Entity entity, boolean movement) {
        PacketCustom packet = new PacketCustom(CHANNEL, 12);
        packet.writeInt(entity.m_19879_());
        packet.writeVec3f(entity.m_20184_().m_252839_());
        packet.writeBoolean(movement);
        if (movement) {
            packet.writeFloat(entity.m_146909_());
            packet.writeFloat(entity.m_146908_());
            packet.writeBoolean(entity.m_20096_());
        }
        return packet.toPacket(NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendOpenHudConfig(ServerPlayer player) {
        new PacketCustom(CHANNEL, 13).sendToPlayer(player);
    }

    public static void sendMultiBlockDefinitions(ServerPlayer player, Map<ResourceLocation, MultiBlockDefinition> multiBlockMap) {
        PacketCustom packet = new PacketCustom(CHANNEL, 14);
        packet.writeVarInt(multiBlockMap.size());
        multiBlockMap.forEach((key, value) -> {
            packet.writeResourceLocation(key);
            packet.writeString(MultiBlockManager.GSON.toJson(value.getJson()));
        });
        packet.sendToPlayer(player);
    }

    public static void sendContributorConfigToServer(ContributorProperties props) {
        PacketCustom packet = new PacketCustom(CHANNEL, 4);
        if (props.isContributor()) {
            props.getConfig().serialize((MCDataOutput)packet);
            packet.sendToServer();
        }
    }

    public static PacketCustom contributorConfigToClient(ContributorProperties props) {
        PacketCustom packet = new PacketCustom(CHANNEL, 15);
        packet.writeUUID(props.getUserID());
        props.getConfig().serialize((MCDataOutput)packet);
        return packet;
    }

    public static void sendContribLinkToServer() {
        new PacketCustom(CHANNEL, 5).sendToServer();
    }

    public static void sentToAllExcept(PacketCustom packet, Player exclude) {
        for (ServerPlayer player : ServerUtils.getPlayers()) {
            if (player.m_20148_().equals(exclude.m_20148_())) continue;
            packet.sendToPlayer(player);
        }
    }

    public static void init() {
        LOCK.lock();
        netChannel = PacketCustomChannelBuilder.named((ResourceLocation)CHANNEL).networkProtocolVersion(() -> "1").clientAcceptedVersions(e -> true).serverAcceptedVersions(e -> true).assignClientHandler(() -> ClientPacketHandler::new).assignServerHandler(() -> ServerPacketHandler::new).build();
    }
}

