/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.worldentity;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.worldentity.ITickableWorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntitySaveData;
import com.brandon3055.brandonscore.worldentity.WorldEntityType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class WorldEntityHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final ResourceKey<Registry<WorldEntityType<?>>> ENTITY_TYPE = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("brandonscore", "world_entity"));
    public static IForgeRegistry<WorldEntityType<?>> REGISTRY;
    private static final Map<UUID, WorldEntity> ID_ENTITY_MAP;
    private static final Map<ResourceKey<Level>, List<WorldEntity>> WORLD_ENTITY_MAP;
    private static final Map<ResourceKey<Level>, List<ITickableWorldEntity>> TICKING_ENTITY_MAP;
    private static final Map<ResourceKey<Level>, List<WorldEntity>> ADDED_WORLD_ENTITIES;

    public static void createRegistry(NewRegistryEvent event) {
        event.create(new RegistryBuilder().setName(ENTITY_TYPE.m_135782_()).disableSaving().disableSync(), ts -> {
            REGISTRY = ts;
        });
    }

    public static void init() {
        LOCK.lock();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(WorldEntityHandler::createRegistry);
        MinecraftForge.EVENT_BUS.addListener(WorldEntityHandler::worldLoad);
        MinecraftForge.EVENT_BUS.addListener(WorldEntityHandler::worldUnload);
        MinecraftForge.EVENT_BUS.addListener(WorldEntityHandler::onServerStop);
        MinecraftForge.EVENT_BUS.addListener(WorldEntityHandler::worldTick);
    }

    public static void worldLoad(LevelEvent.Load event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        ResourceKey key = world.m_46472_();
        List<WorldEntity> oldEntities = WORLD_ENTITY_MAP.remove(key);
        TICKING_ENTITY_MAP.remove(key);
        if (oldEntities != null) {
            LogHelperBC.warn("Detected stray world entities for world " + key.toString() + ". These should have been removed when the world unloaded.");
            oldEntities.forEach(e -> ID_ENTITY_MAP.remove(e.getUniqueID()));
            WORLD_ENTITY_MAP.remove(key);
        }
        WorldEntitySaveData data = (WorldEntitySaveData)world.m_8895_().m_164861_(WorldEntitySaveData::load, WorldEntitySaveData::new, "brandonscore_world_entity");
        data.setSaveCallback(() -> WorldEntityHandler.handleSave(data, (ResourceKey<Level>)key));
        for (WorldEntity entity : data.getEntities()) {
            WorldEntityHandler.addWorldEntity((Level)world, entity);
        }
    }

    private static void handleSave(WorldEntitySaveData data, ResourceKey<Level> key) {
        List<WorldEntity> worldEntities = WORLD_ENTITY_MAP.get(key);
        data.updateEntities(worldEntities);
    }

    public static void worldUnload(LevelEvent.Unload event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        ResourceKey key = world.m_46472_();
        TICKING_ENTITY_MAP.remove(key);
        List<WorldEntity> removed = WORLD_ENTITY_MAP.get(key);
        if (removed != null) {
            removed.forEach(e -> ID_ENTITY_MAP.remove(e.getUniqueID()));
        }
    }

    public static void onServerStop(ServerStoppedEvent event) {
        WORLD_ENTITY_MAP.clear();
        TICKING_ENTITY_MAP.clear();
        ID_ENTITY_MAP.clear();
    }

    public static void worldTick(TickEvent.LevelTickEvent event) {
        if (!(event.level instanceof ServerLevel)) {
            return;
        }
        Level world = event.level;
        ResourceKey key = world.m_46472_();
        ID_ENTITY_MAP.entrySet().removeIf(entry -> {
            WorldEntity entity = (WorldEntity)entry.getValue();
            if (entity.isRemoved()) {
                ResourceKey removeKey = entity.level.m_46472_();
                if (WORLD_ENTITY_MAP.containsKey(removeKey)) {
                    WORLD_ENTITY_MAP.get(removeKey).remove(entity);
                }
                if (entity instanceof ITickableWorldEntity && TICKING_ENTITY_MAP.containsKey(removeKey)) {
                    TICKING_ENTITY_MAP.get(removeKey).remove(entity);
                }
                return true;
            }
            return false;
        });
        if (TICKING_ENTITY_MAP.containsKey(key)) {
            TICKING_ENTITY_MAP.get(key).forEach(e -> {
                if (e.getPhase() == event.phase) {
                    e.tick();
                }
            });
        }
        if (event.phase == TickEvent.Phase.END && ADDED_WORLD_ENTITIES.containsKey(key)) {
            List<WorldEntity> newEntities = ADDED_WORLD_ENTITIES.get(key);
            if (!newEntities.isEmpty()) {
                List worldEntities = WORLD_ENTITY_MAP.computeIfAbsent((ResourceKey<Level>)key, e -> new ArrayList());
                List worldTickingEntities = TICKING_ENTITY_MAP.computeIfAbsent((ResourceKey<Level>)key, e -> new ArrayList());
                for (WorldEntity entity : newEntities) {
                    if (entity.isRemoved()) {
                        worldEntities.remove(entity);
                        if (!(entity instanceof ITickableWorldEntity)) continue;
                        worldTickingEntities.remove(entity);
                        continue;
                    }
                    ID_ENTITY_MAP.put(entity.getUniqueID(), entity);
                    if (!worldEntities.contains(entity)) {
                        worldEntities.add(entity);
                    }
                    if (entity instanceof ITickableWorldEntity && !worldTickingEntities.contains(entity)) {
                        worldTickingEntities.add((ITickableWorldEntity)((Object)entity));
                    }
                    if (entity.getLevel() != world) {
                        entity.setLevel(world);
                    }
                    entity.onLoad();
                }
            }
            ADDED_WORLD_ENTITIES.remove(key);
        }
    }

    public static void addWorldEntity(Level world, WorldEntity entity) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ResourceKey key = world.m_46472_();
        ADDED_WORLD_ENTITIES.computeIfAbsent((ResourceKey<Level>)key, e -> new ArrayList()).add(entity);
        entity.setLevel(world);
    }

    @Nullable
    public static WorldEntity getWorldEntity(Level world, UUID id) {
        WorldEntity entity = ID_ENTITY_MAP.get(id);
        if (entity == null && ADDED_WORLD_ENTITIES.containsKey(world.m_46472_())) {
            entity = ADDED_WORLD_ENTITIES.get(world.m_46472_()).stream().filter(e -> e.getUniqueID().equals(id)).findAny().orElse(null);
        }
        return entity;
    }

    public static List<WorldEntity> getWorldEntities() {
        if (ADDED_WORLD_ENTITIES.isEmpty()) {
            return ImmutableList.copyOf(ID_ENTITY_MAP.values());
        }
        HashSet<WorldEntity> set = new HashSet<WorldEntity>();
        set.addAll(ID_ENTITY_MAP.values());
        set.addAll(ADDED_WORLD_ENTITIES.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        return ImmutableList.copyOf(set);
    }

    protected static void onEntityRemove(WorldEntity entity) {
        ResourceKey key = entity.getLevel().m_46472_();
        if (ADDED_WORLD_ENTITIES.containsKey(key)) {
            ADDED_WORLD_ENTITIES.get(key).remove(entity);
        }
    }

    static {
        ID_ENTITY_MAP = new HashMap<UUID, WorldEntity>();
        WORLD_ENTITY_MAP = new HashMap<ResourceKey<Level>, List<WorldEntity>>();
        TICKING_ENTITY_MAP = new HashMap<ResourceKey<Level>, List<ITickableWorldEntity>>();
        ADDED_WORLD_ENTITIES = new HashMap<ResourceKey<Level>, List<WorldEntity>>();
    }
}

