/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.api.data.recipe;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.block.CopperBlockSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.WeatheringCopper;

public abstract class DeployingRecipeGen
extends ProcessingRecipeGen {
    public BaseRecipeProvider.GeneratedRecipe copperChain(CopperBlockSet set) {
        for (CopperBlockSet.Variant<?> variant : set.getVariants()) {
            ArrayList<Supplier<ItemLike>> chain = new ArrayList<Supplier<ItemLike>>(4);
            for (WeatheringCopper.WeatherState state : WeatheringCopper.WeatherState.values()) {
                this.addWax(() -> set.get(variant, state, true).get(), () -> set.get(variant, state, false).get());
                chain.add(() -> set.get(variant, state, false).get());
            }
            this.oxidizationChain(chain);
        }
        return null;
    }

    public BaseRecipeProvider.GeneratedRecipe addWax(Supplier<ItemLike> waxed, Supplier<ItemLike> nonWaxed) {
        this.createWithDeferredId(this.idWithSuffix(nonWaxed, "_from_removing_wax"), b -> b.require((ItemLike)waxed.get()).require((TagKey<Item>)ItemTags.f_271207_).toolNotConsumed().output((ItemLike)nonWaxed.get()));
        return this.createWithDeferredId(this.idWithSuffix(waxed, "_from_adding_wax"), b -> b.require((ItemLike)nonWaxed.get()).require((ItemLike)Items.f_42789_).toolNotConsumed().output((ItemLike)waxed.get()));
    }

    public BaseRecipeProvider.GeneratedRecipe oxidizationChain(List<Supplier<ItemLike>> chain) {
        for (int i = 0; i < chain.size() - 1; ++i) {
            Supplier<ItemLike> to = chain.get(i);
            Supplier<ItemLike> from = chain.get(i + 1);
            this.createWithDeferredId(this.idWithSuffix(to, "_from_deoxidising"), b -> b.require((ItemLike)from.get()).require((TagKey<Item>)ItemTags.f_271207_).toolNotConsumed().output((ItemLike)to.get()));
        }
        return null;
    }

    public DeployingRecipeGen(PackOutput output, String defaultNamespace) {
        super(output, defaultNamespace);
    }

    @Override
    protected AllRecipeTypes getRecipeType() {
        return AllRecipeTypes.DEPLOYING;
    }
}

