/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.model;

import com.simibubi.create.foundation.block.render.CustomBlockModels;
import com.simibubi.create.foundation.item.render.CustomItemModels;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItems;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ModelSwapper {
    protected CustomBlockModels customBlockModels = new CustomBlockModels();
    protected CustomItemModels customItemModels = new CustomItemModels();

    public CustomBlockModels getCustomBlockModels() {
        return this.customBlockModels;
    }

    public CustomItemModels getCustomItemModels() {
        return this.customItemModels;
    }

    public void onModelBake(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        this.customBlockModels.forEach((NonNullBiConsumer<Block, NonNullFunction<BakedModel, ? extends BakedModel>>)((NonNullBiConsumer)(block, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getAllBlockStateModelLocations(block), modelFunc)));
        this.customItemModels.forEach((NonNullBiConsumer<Item, NonNullFunction<BakedModel, ? extends BakedModel>>)((NonNullBiConsumer)(item, modelFunc) -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), modelFunc)));
        CustomRenderedItems.forEach(item -> ModelSwapper.swapModels((Map<ResourceLocation, BakedModel>)modelRegistry, ModelSwapper.getItemModelLocation(item), CustomRenderedItemModel::new));
    }

    public void registerListeners(IEventBus modEventBus) {
        modEventBus.addListener(this::onModelBake);
    }

    public static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> factory) {
        locations.forEach(location -> ModelSwapper.swapModels(modelRegistry, location, factory));
    }

    public static <T extends BakedModel> void swapModels(Map<ResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put((ResourceLocation)location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static List<ModelResourceLocation> getAllBlockStateModelLocations(Block block) {
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>();
        ResourceLocation blockRl = CatnipServices.REGISTRIES.getKeyOrThrow(block);
        block.m_49965_().m_61056_().forEach(state -> models.add(BlockModelShaper.m_110889_((ResourceLocation)blockRl, (BlockState)state)));
        return models;
    }

    public static ModelResourceLocation getItemModelLocation(Item item) {
        return new ModelResourceLocation(CatnipServices.REGISTRIES.getKeyOrThrow(item), "inventory");
    }
}

